/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.quark.plugins.qubole;

import com.google.common.collect.ImmutableMap;
import com.qubole.qds.sdk.java.client.DefaultQdsConfiguration;
import com.qubole.qds.sdk.java.client.QdsClient;
import com.qubole.qds.sdk.java.client.QdsClientFactory;
import com.qubole.qds.sdk.java.client.QdsConfiguration;
import com.qubole.qds.sdk.java.entities.ResultValue;
import com.qubole.qds.sdk.java.entities.SchemaOrdinal;
import com.qubole.quark.QuarkException;
import com.qubole.quark.plugins.Executor;
import com.qubole.quark.plugins.qubole.QuboleSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.calcite.schema.Schema;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QuboleDB
implements Executor {
    private static final Logger LOG = LoggerFactory.getLogger((String)QuboleDB.class.getName());
    private static final String ROW_DELIMETER = "\r\n";
    private static final String COLUMN_DELIMETER = "\t";
    protected String token;
    protected String endpoint;

    QuboleDB(Map<String, Object> properties) {
        this.validate(properties);
        this.endpoint = (String)properties.get("endpoint");
        this.token = (String)properties.get("token");
    }

    protected abstract Map<String, List<SchemaOrdinal>> getSchemaListDescribed() throws ExecutionException, InterruptedException;

    protected abstract ImmutableMap<String, Integer> getDataTypes();

    public abstract boolean isCaseSensitive();

    private void validate(Map<String, Object> properties) {
        Validate.notNull((Object)properties.get("endpoint"), (String)"Field \"endpoint\" specifying Qubole's endpoint needs to be defined for Qubole Data Source in JSON");
        Validate.notNull((Object)properties.get("token"), (String)"Field \"token\" specifying Authentication token needs to be defined for Qubole Data Source in JSON");
    }

    protected QdsClient getQdsClient() {
        DefaultQdsConfiguration configuration = new DefaultQdsConfiguration(this.endpoint, this.token);
        return QdsClientFactory.newClient((QdsConfiguration)configuration);
    }

    @Override
    public void cleanup() throws Exception {
    }

    public ImmutableMap<String, Schema> getSchemas() throws QuarkException {
        Map<String, List<SchemaOrdinal>> schemas;
        try {
            schemas = this.getSchemaListDescribed();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Getting Schema metadata for " + this.endpoint + " failed. Error: " + e.getMessage(), (Throwable)e);
            throw new QuarkException((Throwable)e);
        }
        ImmutableMap.Builder schemaBuilder = new ImmutableMap.Builder();
        Iterator<String> iterator = schemas.keySet().iterator();
        while (iterator.hasNext()) {
            String schemaName;
            String schemaKey = schemaName = iterator.next();
            if (!this.isCaseSensitive()) {
                schemaKey = schemaName.toUpperCase();
            }
            schemaBuilder.put((Object)schemaKey, (Object)new QuboleSchema(schemaKey, schemas.get(schemaName), this.isCaseSensitive(), this.getDataTypes()));
        }
        return schemaBuilder.build();
    }

    protected Iterator<Object> convertToIterator(ResultValue resultValue) {
        String[] result = resultValue.getResults().split(ROW_DELIMETER);
        ArrayList<String[]> resultSet = new ArrayList<String[]>();
        for (int i = 0; i < result.length; ++i) {
            if (result[i].length() == 0) {
                resultSet = new ArrayList();
                break;
            }
            String[] row = result[i].split(COLUMN_DELIMETER);
            resultSet.add(row);
        }
        return resultSet.iterator();
    }

    protected Map<String, List<SchemaOrdinal>> mergeSchemas(Map<String, List<SchemaOrdinal>> schemas1, Map<String, List<SchemaOrdinal>> schemas2) {
        for (String schemaName : schemas2.keySet()) {
            if (schemas1.containsKey(schemaName)) {
                schemas1.get(schemaName).addAll((Collection<SchemaOrdinal>)schemas2.get(schemaName));
                continue;
            }
            schemas1.put(schemaName, schemas2.get(schemaName));
        }
        return schemas1;
    }
}

