/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.quark.plugins.qubole;

import com.google.common.collect.ImmutableMap;
import com.qubole.quark.QuarkException;
import com.qubole.quark.plugin.DataSource;
import com.qubole.quark.plugin.DataSourceFactory;
import com.qubole.quark.plugins.qubole.DbTapDb;
import com.qubole.quark.plugins.qubole.HiveDb;
import com.qubole.quark.plugins.qubole.QuboleDB;
import com.qubole.quark.plugins.qubole.SparkDb;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class QuboleFactory
implements DataSourceFactory {
    private static final Map<String, Class<? extends QuboleDB>> DB_PLUGINS = ImmutableMap.of((Object)"HIVE", HiveDb.class, (Object)"DBTAP", DbTapDb.class, (Object)"SPARKSQL", SparkDb.class);

    public DataSource create(Map<String, Object> properties) throws QuarkException {
        Validate.notNull((Object)properties.get("type"), (String)"Field \"type\" specifying either HIVE or DBTAP needs to be defined for Qubole Data Source in JSON");
        String type = (String)properties.get("type");
        Class<? extends QuboleDB> dbClass = DB_PLUGINS.get(type.toUpperCase());
        Validate.notNull(dbClass, (String)("Invalid DataSource type: " + type + " Please specify one of these: " + Arrays.toString(DB_PLUGINS.keySet().toArray())));
        return this.getDataSource(properties, dbClass);
    }

    private DataSource getDataSource(Map<String, Object> properties, Class dbClass) throws QuarkException {
        try {
            return (DataSource)dbClass.getConstructor(Map.class).newInstance(properties);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new QuarkException(new Throwable("Invoking invalid constructor on class specified for type " + properties.get("type") + ": " + dbClass.getCanonicalName()));
        }
        catch (InvocationTargetException e) {
            throw new QuarkException(e.getTargetException());
        }
    }
}

