/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.quark.plugins.qubole;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.qubole.qds.sdk.java.entities.NameAndType;
import com.qubole.qds.sdk.java.entities.SchemaOrdinal;
import com.qubole.quark.QuarkException;
import com.qubole.quark.planner.QuarkColumn;
import com.qubole.quark.planner.QuarkSchema;
import com.qubole.quark.planner.QuarkTable;
import com.qubole.quark.plugins.qubole.ColumnComparator;
import com.qubole.quark.sql.QueryContext;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;

public class QuboleSchema
extends QuarkSchema {
    protected static final ImmutableMap<String, Integer> DATA_TYPES = new ImmutableMap.Builder().put((Object)"string", (Object)12).put((Object)"character varying", (Object)12).put((Object)"character", (Object)1).put((Object)"integer", (Object)4).put((Object)"smallint", (Object)5).put((Object)"bigint", (Object)-5).put((Object)"tinyint", (Object)-6).put((Object)Primitive.BYTE.primitiveClass.getSimpleName(), (Object)-6).put((Object)Primitive.CHAR.primitiveClass.getSimpleName(), (Object)-6).put((Object)Primitive.SHORT.primitiveClass.getSimpleName(), (Object)5).put((Object)Primitive.INT.primitiveClass.getSimpleName(), (Object)4).put((Object)Primitive.LONG.primitiveClass.getSimpleName(), (Object)-5).put((Object)Primitive.FLOAT.primitiveClass.getSimpleName(), (Object)6).put((Object)Primitive.DOUBLE.primitiveClass.getSimpleName(), (Object)8).put((Object)"date", (Object)91).put((Object)"time", (Object)93).put((Object)"boolean", (Object)16).build();
    private final ImmutableMap<String, Table> tableMap;

    public QuboleSchema(String name, List<SchemaOrdinal> tables, boolean isCaseSensitive, ImmutableMap<String, Integer> dataTypes) throws QuarkException {
        super(isCaseSensitive ? name : name.toUpperCase());
        ImmutableMap.Builder tableBuilder = new ImmutableMap.Builder();
        for (SchemaOrdinal table : tables) {
            List columns = table.getColumns();
            columns.sort(new ColumnComparator());
            ImmutableList.Builder columnBuilder = new ImmutableList.Builder();
            for (NameAndType column : columns) {
                String columnName = column.getName();
                if (!isCaseSensitive) {
                    columnName = columnName.toUpperCase();
                }
                columnBuilder.add((Object)new QuarkColumn(columnName, this.getType(column.getType(), dataTypes).intValue()));
            }
            String tableName = table.getTable_name();
            if (!isCaseSensitive) {
                tableName = tableName.toUpperCase();
            }
            tableBuilder.put((Object)tableName, (Object)new QuarkTable((QuarkSchema)this, tableName, (List)columnBuilder.build()));
        }
        this.tableMap = tableBuilder.build();
    }

    private Integer getType(String dataType, ImmutableMap<String, Integer> dataTypes) throws QuarkException {
        if (DATA_TYPES.containsKey((Object)dataType)) {
            return (Integer)DATA_TYPES.get((Object)dataType);
        }
        for (String key : dataTypes.keySet()) {
            if (!dataType.matches(key)) continue;
            return (Integer)dataTypes.get((Object)key);
        }
        throw new QuarkException("Unknown DataType `" + dataType + "`");
    }

    public void initialize(QueryContext queryContext, SchemaPlus schemaPlus) {
        this.schemaPlus = schemaPlus;
        for (Map.Entry entry : this.tableMap.entrySet()) {
            this.schemaPlus.add((String)entry.getKey(), (Table)entry.getValue());
        }
    }

    public Map<String, Table> getTableMap() {
        return this.tableMap;
    }
}

