/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.spi.fop;

import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.fop.ObjectFactory;
import com.qubole.rubix.spi.fop.ObjectPool;
import com.qubole.rubix.spi.fop.PoolConfig;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class SocketChannelObjectFactory
implements ObjectFactory<SocketChannel> {
    private static final Log log = LogFactory.getLog((String)SocketChannelObjectFactory.class.getName());
    private static final String LDS_POOL = "lds-pool";
    private final int port;

    public SocketChannelObjectFactory(int port) {
        this.port = port;
    }

    @Override
    public SocketChannel create(String host, int socketTimeout, int connectTimeout) {
        InetSocketAddress sad = new InetSocketAddress(host, this.port);
        SocketChannel socket = null;
        try {
            socket = SocketChannel.open();
            socket.socket().setSoTimeout(socketTimeout);
            socket.socket().connect(sad, connectTimeout);
            log.debug((Object)("lds-pool : Socket channel connected to host: " + host + " with local socket address: " + socket.socket().getLocalSocketAddress()));
        }
        catch (IOException e) {
            log.warn((Object)("lds-pool : Unable to open connection to host " + host), (Throwable)e);
        }
        return socket;
    }

    @Override
    public void destroy(SocketChannel o) {
        log.debug((Object)("lds-pool : Destroy socket channel: " + o));
        try {
            o.close();
        }
        catch (IOException e) {
            log.warn((Object)("lds-pool : Error in closing connection " + o), (Throwable)e);
        }
    }

    @Override
    public boolean validate(SocketChannel o) {
        boolean isClosed;
        boolean bl = isClosed = o != null && !o.isOpen();
        if (isClosed && o != null) {
            try {
                o.socket().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        log.debug((Object)("lds-pool : Validate socket channel: " + o + " isvalid: " + !isClosed));
        return !isClosed;
    }

    public static ObjectPool<SocketChannel> createSocketChannelObjectPool(Configuration conf, String host, int port) {
        log.debug((Object)"lds-pool : Creating socket channel object pool");
        PoolConfig poolConfig = new PoolConfig();
        poolConfig.setMaxSize(CacheConfig.getTranportPoolMaxSize(conf));
        poolConfig.setMinSize(CacheConfig.getTransportPoolMinSize(conf));
        poolConfig.setDelta(CacheConfig.getTransportPoolDeltaSize(conf));
        poolConfig.setMaxWaitMilliseconds(CacheConfig.getTransportPoolMaxWait(conf));
        poolConfig.setScavengeIntervalMilliseconds(CacheConfig.getScavengeInterval(conf));
        poolConfig.setConnectTimeoutMilliseconds(CacheConfig.getServerConnectTimeout(conf));
        poolConfig.setSocketTimeoutMilliseconds(CacheConfig.getClientReadTimeout(conf));
        SocketChannelObjectFactory factory = new SocketChannelObjectFactory(port);
        ObjectPool<SocketChannel> pool = new ObjectPool<SocketChannel>(poolConfig, factory, LDS_POOL);
        pool.registerHost(host);
        return pool;
    }
}

