/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.sqs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.client.builder.AwsSyncClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.BatchResultErrorEntry;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.DeleteMessageResult;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.streaming.sqs.BasicAWSCredentialsProvider;
import org.apache.spark.sql.streaming.sqs.InstanceProfileCredentialsProviderWithRetries;
import org.apache.spark.sql.streaming.sqs.MessageDescription;
import org.apache.spark.sql.streaming.sqs.SqsClient$;
import org.apache.spark.sql.streaming.sqs.SqsFileCache;
import org.apache.spark.sql.streaming.sqs.SqsSourceOptions;
import org.apache.spark.util.ThreadUtils$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package;
import org.json4s.package$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\u0001\u0003\u0001=\u0011\u0011bU9t\u00072LWM\u001c;\u000b\u0005\r!\u0011aA:rg*\u0011QAB\u0001\ngR\u0014X-Y7j]\u001eT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011qCG\u0007\u00021)\u0011\u0011\u0004C\u0001\tS:$XM\u001d8bY&\u00111\u0004\u0007\u0002\b\u0019><w-\u001b8h\u0011!i\u0002A!A!\u0002\u0013q\u0012!D:pkJ\u001cWm\u00149uS>t7\u000f\u0005\u0002 A5\t!!\u0003\u0002\"\u0005\t\u00012+]:T_V\u00148-Z(qi&|gn\u001d\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\u0005\u0015RS\"\u0001\u0014\u000b\u0005\u001dB\u0013\u0001B2p]\u001aT!!\u000b\u0006\u0002\r!\fGm\\8q\u0013\tYcEA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\u0002\u0014\u0007\u0005\u0002 \u0001!)Q\u0004\fa\u0001=!)1\u0005\fa\u0001I!91\u0007\u0001b\u0001\n\u0013!\u0014aF:rg\u001a+Go\u00195J]R,'O^1m'\u0016\u001cwN\u001c3t+\u0005)\u0004CA\t7\u0013\t9$CA\u0002J]RDa!\u000f\u0001!\u0002\u0013)\u0014\u0001G:rg\u001a+Go\u00195J]R,'O^1m'\u0016\u001cwN\u001c3tA!91\b\u0001b\u0001\n\u0013!\u0014AG:rg2{gn\u001a)pY2<\u0016-\u001b;US6,7+Z2p]\u0012\u001c\bBB\u001f\u0001A\u0003%Q'A\u000etcNduN\\4Q_2dw+Y5u)&lWmU3d_:$7\u000f\t\u0005\b\u007f\u0001\u0011\r\u0011\"\u00035\u00035\u0019\u0018o]'bqJ+GO]5fg\"1\u0011\t\u0001Q\u0001\nU\nab]9t\u001b\u0006D(+\u001a;sS\u0016\u001c\b\u0005C\u0004D\u0001\t\u0007I\u0011\u0002\u001b\u0002\u001d5\f\u0007pQ8o]\u0016\u001cG/[8og\"1Q\t\u0001Q\u0001\nU\nq\"\\1y\u0007>tg.Z2uS>t7\u000f\t\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003I\u0003IIwM\\8sK\u001aKG.\u001a#fY\u0016$\u0018n\u001c8\u0016\u0003%\u0003\"!\u0005&\n\u0005-\u0013\"a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u001b\u0002\u0001\u000b\u0011B%\u0002'%<gn\u001c:f\r&dW\rR3mKRLwN\u001c\u0011\t\u000f=\u0003!\u0019!C\u0005!\u00061!/Z4j_:,\u0012!\u0015\t\u0003%Vs!!E*\n\u0005Q\u0013\u0012A\u0002)sK\u0012,g-\u0003\u0002W/\n11\u000b\u001e:j]\u001eT!\u0001\u0016\n\t\re\u0003\u0001\u0015!\u0003R\u0003\u001d\u0011XmZ5p]\u0002Bqa\u0017\u0001C\u0002\u0013\u0005\u0001+\u0001\u0004tcN,&\u000f\u001c\u0005\u0007;\u0002\u0001\u000b\u0011B)\u0002\u000fM\f8/\u0016:mA!9q\f\u0001a\u0001\n\u0003\u0001\u0017!C3yG\u0016\u0004H/[8o+\u0005\t\u0007cA\tcI&\u00111M\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0015lgB\u00014l\u001d\t9'.D\u0001i\u0015\tIg\"\u0001\u0004=e>|GOP\u0005\u0002'%\u0011ANE\u0001\ba\u0006\u001c7.Y4f\u0013\tqwNA\u0005Fq\u000e,\u0007\u000f^5p]*\u0011AN\u0005\u0005\bc\u0002\u0001\r\u0011\"\u0001s\u00035)\u0007pY3qi&|gn\u0018\u0013fcR\u00111O\u001e\t\u0003#QL!!\u001e\n\u0003\tUs\u0017\u000e\u001e\u0005\boB\f\t\u00111\u0001b\u0003\rAH%\r\u0005\u0007s\u0002\u0001\u000b\u0015B1\u0002\u0015\u0015D8-\u001a9uS>t\u0007\u0005\u000b\u0002ywB\u0011\u0011\u0003`\u0005\u0003{J\u0011\u0001B^8mCRLG.\u001a\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002\u0005yA/[7fgR\fW\u000e\u001d$pe6\fG/\u0006\u0002\u0002\u0004A!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011\u0001\u0002;fqRT!!!\u0004\u0002\t)\fg/Y\u0005\u0005\u0003#\t9A\u0001\tTS6\u0004H.\u001a#bi\u00164uN]7bi\"A\u0011Q\u0003\u0001!\u0002\u0013\t\u0019!\u0001\tuS6,7\u000f^1na\u001a{'/\\1uA!A\u0011\u0011\u0004\u0001A\u0002\u0013%A'\u0001\tsKR\u0014\u0018.Z:P]\u001a\u000b\u0017\u000e\\;sK\"I\u0011Q\u0004\u0001A\u0002\u0013%\u0011qD\u0001\u0015e\u0016$(/[3t\u001f:4\u0015-\u001b7ve\u0016|F%Z9\u0015\u0007M\f\t\u0003\u0003\u0005x\u00037\t\t\u00111\u00016\u0011\u001d\t)\u0003\u0001Q!\nU\n\u0011C]3ue&,7o\u00148GC&dWO]3!\u0011%\tI\u0003\u0001b\u0001\n\u0013\tY#A\u0005tcN\u001cE.[3oiV\u0011\u0011Q\u0006\t\u0005\u0003_\ty$\u0004\u0002\u00022)\u00191!a\r\u000b\t\u0005U\u0012qG\u0001\tg\u0016\u0014h/[2fg*!\u0011\u0011HA\u001e\u0003%\tW.\u0019>p]\u0006<8O\u0003\u0002\u0002>\u0005\u00191m\\7\n\t\u0005\u0005\u0013\u0011\u0007\u0002\n\u00036\f'p\u001c8T#NC\u0001\"!\u0012\u0001A\u0003%\u0011QF\u0001\u000bgF\u001c8\t\\5f]R\u0004\u0003\"CA%\u0001\t\u0007I\u0011AA&\u00031\u0019\u0018o]*dQ\u0016$W\u000f\\3s+\t\ti\u0005\u0005\u0003\u0002P\u0005eSBAA)\u0015\u0011\t\u0019&!\u0016\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002X\u0005-\u0011\u0001B;uS2LA!a\u0017\u0002R\tA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\u0011\u0005}\u0003\u0001)A\u0005\u0003\u001b\nQb]9t'\u000eDW\rZ;mKJ\u0004\u0003\"CA2\u0001\t\u0007I\u0011AA3\u00031\u0019\u0018o\u001d$jY\u0016\u001c\u0015m\u00195f+\t\t9\u0007E\u0002 \u0003SJ1!a\u001b\u0003\u00051\u0019\u0016o\u001d$jY\u0016\u001c\u0015m\u00195f\u0011!\ty\u0007\u0001Q\u0001\n\u0005\u001d\u0014!D:rg\u001aKG.Z\"bG\",\u0007\u0005C\u0005\u0002t\u0001\u0011\r\u0011\"\u0001\u0002v\u0005\u0011B-\u001a7fi\u0016lUm]:bO\u0016\fV/Z;f+\t\t9\bE\u0003\u0002P\u0005e\u0014+\u0003\u0003\u0002|\u0005E#!F\"p]\u000e,(O]3oi2Kgn[3e#V,W/\u001a\u0005\t\u0003\u007f\u0002\u0001\u0015!\u0003\u0002x\u0005\u0019B-\u001a7fi\u0016lUm]:bO\u0016\fV/Z;fA!I\u00111\u0011\u0001C\u0002\u0013%\u0011QQ\u0001\u0017gF\u001ch)\u001a;dQ6+7o]1hKN$\u0006N]3bIV\u0011\u0011q\u0011\n\u0007\u0003\u0013\u000b\t*!(\u0007\u000f\u0005-\u0015Q\u0012\u0001\u0002\b\naAH]3gS:,W.\u001a8u}!A\u0011q\u0012\u0001!\u0002\u0013\t9)A\ftcN4U\r^2i\u001b\u0016\u001c8/Y4fgRC'/Z1eAA!\u00111SAM\u001b\t\t)J\u0003\u0003\u0002\u0018\u0006-\u0011\u0001\u00027b]\u001eLA!a'\u0002\u0016\n1qJ\u00196fGR\u0004B!a%\u0002 &!\u0011\u0011UAK\u0005!\u0011VO\u001c8bE2,\u0007bBAS\u0001\u0011%\u0011qU\u0001\u0011gF\u001ch)\u001a;dQ6+7o]1hKN$\"!!+\u0011\u000b\u0015\fY+a,\n\u0007\u00055vNA\u0002TKF\u0004r!EAY#\u0006U\u0016+C\u0002\u00024J\u0011a\u0001V;qY\u0016\u001c\u0004cA\t\u00028&\u0019\u0011\u0011\u0018\n\u0003\t1{gn\u001a\u0005\b\u0003{\u0003A\u0011BA`\u0003A\u0001\u0018M]:f'F\u001cX*Z:tC\u001e,7\u000f\u0006\u0003\u0002*\u0006\u0005\u0007\u0002CAb\u0003w\u0003\r!!2\u0002\u00175,7o]1hK2K7\u000f\u001e\t\u0006K\u0006-\u0016q\u0019\t\u0005\u0003\u0013\fy-\u0004\u0002\u0002L*!\u0011QZA\u0019\u0003\u0015iw\u000eZ3m\u0013\u0011\t\t.a3\u0003\u000f5+7o]1hK\"9\u0011Q\u001b\u0001\u0005\n\u0005]\u0017aF2p]Z,'\u000f\u001e+j[\u0016\u001cH/Y7q)>l\u0015\u000e\u001c7t)\u0011\t),!7\t\u000f\u0005m\u00171\u001ba\u0001#\u0006IA/[7fgR\fW\u000e\u001d\u0005\b\u0003?\u0004A\u0011BAq\u0003=)g/\u00197vCR,'+\u001a;sS\u0016\u001cH#A:\t\u000f\u0005\u0015\b\u0001\"\u0003\u0002h\u0006y1M]3bi\u0016\u001c\u0016o]\"mS\u0016tG\u000f\u0006\u0002\u0002.!9\u00111\u001e\u0001\u0005\u0002\u00055\u0018aF1eIR{G)\u001a7fi\u0016lUm]:bO\u0016\fV/Z;f)\r\u0019\u0018q\u001e\u0005\t\u0003c\fI\u000f1\u0001\u0002t\u0006)R.Z:tC\u001e,'+Z2fSB$\b*\u00198eY\u0016\u001c\b\u0003B3\u0002vFK1!a>p\u0005\u0011a\u0015n\u001d;\t\u000f\u0005m\b\u0001\"\u0001\u0002b\u00069B-\u001a7fi\u0016lUm]:bO\u0016\u001chI]8n#V,W/\u001a\u0005\b\u0003\u007f\u0004A\u0011AAq\u0003I\t7o]3siN\u000b8/S:X_J\\\u0017N\\4")
public class SqsClient
implements Logging {
    private final SqsSourceOptions sourceOptions;
    private final Configuration hadoopConf;
    private final int org$apache$spark$sql$streaming$sqs$SqsClient$$sqsFetchIntervalSeconds;
    private final int sqsLongPollWaitTimeSeconds;
    private final int sqsMaxRetries;
    private final int maxConnections;
    private final boolean org$apache$spark$sql$streaming$sqs$SqsClient$$ignoreFileDeletion;
    private final String region;
    private final String sqsUrl;
    private volatile Option<Exception> exception;
    private final SimpleDateFormat timestampFormat;
    private int org$apache$spark$sql$streaming$sqs$SqsClient$$retriesOnFailure;
    private final AmazonSQS org$apache$spark$sql$streaming$sqs$SqsClient$$sqsClient;
    private final ScheduledExecutorService sqsScheduler;
    private final SqsFileCache sqsFileCache;
    private final ConcurrentLinkedQueue<String> deleteMessageQueue;
    private final Runnable sqsFetchMessagesThread;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public void initalizeLoganIfNecessary() {
        Logging.class.initalizeLoganIfNecessary((Logging)this);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public int org$apache$spark$sql$streaming$sqs$SqsClient$$sqsFetchIntervalSeconds() {
        return this.org$apache$spark$sql$streaming$sqs$SqsClient$$sqsFetchIntervalSeconds;
    }

    private int sqsLongPollWaitTimeSeconds() {
        return this.sqsLongPollWaitTimeSeconds;
    }

    private int sqsMaxRetries() {
        return this.sqsMaxRetries;
    }

    private int maxConnections() {
        return this.maxConnections;
    }

    public boolean org$apache$spark$sql$streaming$sqs$SqsClient$$ignoreFileDeletion() {
        return this.org$apache$spark$sql$streaming$sqs$SqsClient$$ignoreFileDeletion;
    }

    private String region() {
        return this.region;
    }

    public String sqsUrl() {
        return this.sqsUrl;
    }

    public Option<Exception> exception() {
        return this.exception;
    }

    public void exception_$eq(Option<Exception> x$1) {
        this.exception = x$1;
    }

    private SimpleDateFormat timestampFormat() {
        return this.timestampFormat;
    }

    public int org$apache$spark$sql$streaming$sqs$SqsClient$$retriesOnFailure() {
        return this.org$apache$spark$sql$streaming$sqs$SqsClient$$retriesOnFailure;
    }

    private void org$apache$spark$sql$streaming$sqs$SqsClient$$retriesOnFailure_$eq(int x$1) {
        this.org$apache$spark$sql$streaming$sqs$SqsClient$$retriesOnFailure = x$1;
    }

    public AmazonSQS org$apache$spark$sql$streaming$sqs$SqsClient$$sqsClient() {
        return this.org$apache$spark$sql$streaming$sqs$SqsClient$$sqsClient;
    }

    public ScheduledExecutorService sqsScheduler() {
        return this.sqsScheduler;
    }

    public SqsFileCache sqsFileCache() {
        return this.sqsFileCache;
    }

    public ConcurrentLinkedQueue<String> deleteMessageQueue() {
        return this.deleteMessageQueue;
    }

    private Runnable sqsFetchMessagesThread() {
        return this.sqsFetchMessagesThread;
    }

    public Seq<Tuple3<String, Object, String>> org$apache$spark$sql$streaming$sqs$SqsClient$$sqsFetchMessages() {
        List list;
        try {
            ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest().withQueueUrl(this.sqsUrl()).withWaitTimeSeconds(Predef$.MODULE$.int2Integer(this.sqsLongPollWaitTimeSeconds()));
            Buffer messages = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.org$apache$spark$sql$streaming$sqs$SqsClient$$sqsClient().receiveMessage(receiveMessageRequest).getMessages()).asScala();
            this.org$apache$spark$sql$streaming$sqs$SqsClient$$retriesOnFailure_$eq(0);
            this.logDebug((Function0<String>)new Serializable(this, messages){
                public static final long serialVersionUID = 0L;
                private final Buffer messages$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"successfully received ", " messages"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messages$1.size())}));
                }
                {
                    this.messages$1 = messages$1;
                }
            });
            list = messages;
        }
        catch (Exception exception) {
            String message = "Received unexpected error from SQS";
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$3;

                public final String apply() {
                    return this.message$3;
                }
                {
                    this.message$3 = message$3;
                }
            });
            this.logWarning((Function0<String>)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error Message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$1.getMessage()}));
                }
                {
                    this.e$1 = e$1;
                }
            });
            this.evaluateRetries();
            list = List$.MODULE$.empty();
        }
        catch (AmazonClientException amazonClientException) {
            String message = new StringOps(Predef$.MODULE$.augmentString("\n           |Caught an AmazonClientException, which means, the client encountered a serious\n           | internal problem while trying to communicate with Amazon SQS, such as not\n           |  being able to access the network.\n        ")).stripMargin();
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$2;

                public final String apply() {
                    return this.message$2;
                }
                {
                    this.message$2 = message$2;
                }
            });
            this.logWarning((Function0<String>)new Serializable(this, amazonClientException){
                public static final long serialVersionUID = 0L;
                private final AmazonClientException ace$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error Message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ace$1.getMessage()}));
                }
                {
                    this.ace$1 = ace$1;
                }
            });
            this.evaluateRetries();
            list = List$.MODULE$.empty();
        }
        catch (AmazonServiceException amazonServiceException) {
            String message = new StringOps(Predef$.MODULE$.augmentString("\n          |Caught an AmazonServiceException, which means your request made it to Amazon SQS,\n          | rejected with an error response for some reason.\n        ")).stripMargin();
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            this.logWarning((Function0<String>)new Serializable(this, amazonServiceException){
                public static final long serialVersionUID = 0L;
                private final AmazonServiceException ase$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error Message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ase$1.getMessage()}));
                }
                {
                    this.ase$1 = ase$1;
                }
            });
            this.logWarning((Function0<String>)new Serializable(this, amazonServiceException){
                public static final long serialVersionUID = 0L;
                private final AmazonServiceException ase$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HTTP Status Code: ", ", AWS Error Code: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.ase$1.getStatusCode()), this.ase$1.getErrorCode()}));
                }
                {
                    this.ase$1 = ase$1;
                }
            });
            this.logWarning((Function0<String>)new Serializable(this, amazonServiceException){
                public static final long serialVersionUID = 0L;
                private final AmazonServiceException ase$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error Type: ", ", Request ID: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ase$1.getErrorType(), this.ase$1.getRequestId()}));
                }
                {
                    this.ase$1 = ase$1;
                }
            });
            this.evaluateRetries();
            list = List$.MODULE$.empty();
        }
        List messageList = list;
        return messageList.nonEmpty() ? this.parseSqsMessages((Seq<Message>)messageList) : (Seq)Seq$.MODULE$.empty();
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Tuple3<String, Object, String>> parseSqsMessages(Seq<Message> messageList) {
        void var3_3;
        ListBuffer errorMessages = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq parsedMessages = (Seq)messageList.foldLeft((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2)new Serializable(this, errorMessages){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SqsClient $outer;
            private final ListBuffer errorMessages$1;

            public final Seq<Tuple3<String, Object, String>> apply(Seq<Tuple3<String, Object, String>> list, Message message) {
                Seq seq;
                DefaultFormats$ formats = DefaultFormats$.MODULE$;
                try {
                    String messageReceiptHandle = message.getReceiptHandle();
                    JsonAST.JValue messageJson = (JsonAST.JValue)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(message.getBody()), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract((Formats)formats, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class));
                    String bucketName = (String)Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(messageJson).$bslash("Records")).$bslash("s3")).$bslash("bucket")).$bslash("name")).extract((Formats)formats, ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)))).head();
                    String eventName = (String)Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(messageJson).$bslash("Records")).$bslash("eventName")).extract((Formats)formats, ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)))).head();
                    if (eventName.contains("ObjectCreated")) {
                        String timestamp = (String)Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(messageJson).$bslash("Records")).$bslash("eventTime")).extract((Formats)formats, ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)))).head();
                        long timestampMills = this.$outer.org$apache$spark$sql$streaming$sqs$SqsClient$$convertTimestampToMills(timestamp);
                        String path = new StringBuilder().append((Object)"s3://").append((Object)bucketName).append((Object)"/").append(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(messageJson).$bslash("Records")).$bslash("s3")).$bslash("object")).$bslash("key")).extract((Formats)formats, ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)))).head()).toString();
                        this.$outer.logDebug((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Successfully parsed sqs message";
                            }
                        });
                        seq = (Seq)list.$colon$plus((Object)new Tuple3((Object)path, (Object)BoxesRunTime.boxToLong((long)timestampMills), (Object)messageReceiptHandle), Seq$.MODULE$.canBuildFrom());
                    } else {
                        if (eventName.contains("ObjectRemoved")) {
                            if (this.$outer.org$apache$spark$sql$streaming$sqs$SqsClient$$ignoreFileDeletion()) {
                                this.$outer.logInfo((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "Ignoring file deletion message since ignoreFileDeletion is true";
                                    }
                                });
                            } else {
                                this.$outer.exception_$eq((Option<Exception>)new Some((Object)new SparkException("ObjectDelete message detected in SQS")));
                            }
                        } else {
                            this.$outer.logWarning((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Ignoring unexpected message detected in SQS";
                                }
                            });
                        }
                        this.errorMessages$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{messageReceiptHandle}));
                        seq = list;
                    }
                }
                catch (Exception exception) {
                    this.errorMessages$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{message.getReceiptHandle()}));
                    this.$outer.logWarning((Function0<String>)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception e$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected error while parsing SQS message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$2.getMessage()}));
                        }
                        {
                            this.e$2 = e$2;
                        }
                    });
                    seq = list;
                }
                catch (package.MappingException mappingException) {
                    this.errorMessages$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{message.getReceiptHandle()}));
                    this.$outer.logWarning((Function0<String>)new Serializable(this, mappingException){
                        public static final long serialVersionUID = 0L;
                        private final package.MappingException me$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error in parsing SQS message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.me$1.getMessage()}));
                        }
                        {
                            this.me$1 = me$1;
                        }
                    });
                    seq = list;
                }
                return seq;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.errorMessages$1 = errorMessages$1;
            }
        });
        if (errorMessages.nonEmpty()) {
            this.addToDeleteMessageQueue((List<String>)errorMessages.toList());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public long org$apache$spark$sql$streaming$sqs$SqsClient$$convertTimestampToMills(String timestamp) {
        void var2_2;
        long timeInMillis = this.timestampFormat().parse(timestamp).getTime();
        return (long)var2_2;
    }

    private void evaluateRetries() {
        this.org$apache$spark$sql$streaming$sqs$SqsClient$$retriesOnFailure_$eq(this.org$apache$spark$sql$streaming$sqs$SqsClient$$retriesOnFailure() + 1);
        if (this.org$apache$spark$sql$streaming$sqs$SqsClient$$retriesOnFailure() >= this.sqsMaxRetries()) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Max retries reached";
                }
            });
            this.exception_$eq((Option<Exception>)new Some((Object)new SparkException(new StringBuilder().append((Object)"Unable to receive Messages from SQS for ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " times Giving up. Check logs for details."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.sqsMaxRetries())}))).toString())));
        } else {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SqsClient $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempt ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$sql$streaming$sqs$SqsClient$$retriesOnFailure())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will reattempt after ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$sql$streaming$sqs$SqsClient$$sqsFetchIntervalSeconds())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    private AmazonSQS createSqsClient() {
        try {
            AmazonSQS amazonSQS;
            boolean isClusterOnEc2Role;
            boolean bl = isClusterOnEc2Role = this.hadoopConf.getBoolean("fs.s3.isClusterOnEc2Role", false) || this.hadoopConf.getBoolean("fs.s3n.isClusterOnEc2Role", false) || this.sourceOptions.useInstanceProfileCredentials();
            if (isClusterOnEc2Role) {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Using the credentials attached to the instance";
                    }
                });
                InstanceProfileCredentialsProviderWithRetries instanceProfileCredentialsProvider = new InstanceProfileCredentialsProviderWithRetries();
                amazonSQS = (AmazonSQS)((AwsSyncClientBuilder)((AwsClientBuilder)AmazonSQSClientBuilder.standard().withClientConfiguration(new ClientConfiguration().withMaxConnections(this.maxConnections()))).withCredentials(instanceProfileCredentialsProvider)).build();
            } else {
                String accessKey = this.hadoopConf.getTrimmed("fs.s3n.awsAccessKeyId");
                String secretAccessKey = new String(this.hadoopConf.getPassword("fs.s3n.awsSecretAccessKey")).trim();
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Using credentials from keys provided";
                    }
                });
                BasicAWSCredentialsProvider basicAwsCredentialsProvider = new BasicAWSCredentialsProvider(accessKey, secretAccessKey);
                amazonSQS = (AmazonSQS)((AwsSyncClientBuilder)((AwsClientBuilder)((AwsClientBuilder)AmazonSQSClientBuilder.standard().withClientConfiguration(new ClientConfiguration().withMaxConnections(this.maxConnections()))).withCredentials(basicAwsCredentialsProvider)).withRegion(this.region())).build();
            }
            return amazonSQS;
        }
        catch (Exception exception) {
            throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error occured while creating Amazon SQS Client ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage()})));
        }
    }

    public void addToDeleteMessageQueue(List<String> messageReceiptHandles) {
        this.deleteMessageQueue().addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(messageReceiptHandles).asJava());
    }

    public void deleteMessagesFromQueue() {
        try {
            IntRef count = IntRef.create((int)-1);
            List messageReceiptHandles = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.deleteMessageQueue()).asScala()).toList();
            List messageGroups = messageReceiptHandles.sliding(10, 10).toList();
            messageGroups.foreach((Function1)new Serializable(this, count){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SqsClient $outer;
                public final IntRef count$1;

                public final void apply(List<String> messageGroup) {
                    java.util.List requestEntries = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)messageGroup.foldLeft((Object)Nil$.MODULE$, (Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$deleteMessagesFromQueue$1 $outer;

                        public final List<DeleteMessageBatchRequestEntry> apply(List<DeleteMessageBatchRequestEntry> list, String messageReceiptHandle) {
                            ++this.$outer.count$1.elem;
                            return (List)list.$colon$plus((Object)new DeleteMessageBatchRequestEntry(((Object)BoxesRunTime.boxToInteger((int)this.$outer.count$1.elem)).toString(), messageReceiptHandle), List$.MODULE$.canBuildFrom());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    })).asJava();
                    DeleteMessageBatchResult batchResult = this.$outer.org$apache$spark$sql$streaming$sqs$SqsClient$$sqsClient().deleteMessageBatch(this.$outer.sqsUrl(), requestEntries);
                    if (!batchResult.getFailed().isEmpty()) {
                        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(batchResult.getFailed()).asScala()).foreach((Function1)new Serializable(this, requestEntries){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$deleteMessagesFromQueue$1 $outer;
                            private final java.util.List requestEntries$1;

                            public final DeleteMessageResult apply(BatchResultErrorEntry entry) {
                                return this.$outer.org$apache$spark$sql$streaming$sqs$SqsClient$$anonfun$$$outer().org$apache$spark$sql$streaming$sqs$SqsClient$$sqsClient().deleteMessage(this.$outer.org$apache$spark$sql$streaming$sqs$SqsClient$$anonfun$$$outer().sqsUrl(), ((DeleteMessageBatchRequestEntry)this.requestEntries$1.get(new StringOps(Predef$.MODULE$.augmentString(entry.getId())).toInt())).getReceiptHandle());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.requestEntries$1 = requestEntries$1;
                            }
                        });
                    }
                }

                public /* synthetic */ SqsClient org$apache$spark$sql$streaming$sqs$SqsClient$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.count$1 = count$1;
                }
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$3;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to delete message from SQS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$3.getMessage()}));
                }
                {
                    this.e$3 = e$3;
                }
            });
        }
        this.deleteMessageQueue().clear();
    }

    public void assertSqsIsWorking() {
        if (this.exception().isDefined()) {
            throw (Throwable)this.exception().get();
        }
    }

    public SqsClient(SqsSourceOptions sourceOptions, Configuration hadoopConf) {
        this.sourceOptions = sourceOptions;
        this.hadoopConf = hadoopConf;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$sql$streaming$sqs$SqsClient$$sqsFetchIntervalSeconds = sourceOptions.fetchIntervalSeconds();
        this.sqsLongPollWaitTimeSeconds = sourceOptions.longPollWaitTimeSeconds();
        this.sqsMaxRetries = sourceOptions.maxRetries();
        this.maxConnections = sourceOptions.maxConnections();
        this.org$apache$spark$sql$streaming$sqs$SqsClient$$ignoreFileDeletion = sourceOptions.ignoreFileDeletion();
        this.region = sourceOptions.region();
        this.sqsUrl = sourceOptions.sqsUrl();
        this.exception = None$.MODULE$;
        this.timestampFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.timestampFormat().setTimeZone(TimeZone.getTimeZone("UTC"));
        this.org$apache$spark$sql$streaming$sqs$SqsClient$$retriesOnFailure = 0;
        this.org$apache$spark$sql$streaming$sqs$SqsClient$$sqsClient = this.createSqsClient();
        this.sqsScheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("sqs-scheduler");
        this.sqsFileCache = new SqsFileCache(sourceOptions.maxFileAgeMs(), sourceOptions.fileNameOnly());
        this.deleteMessageQueue = new ConcurrentLinkedQueue();
        this.sqsFetchMessagesThread = new Runnable(this){
            private final /* synthetic */ SqsClient $outer;

            public void run() {
                try {
                    Seq<Tuple3<String, Object, String>> newMessages = this.$outer.org$apache$spark$sql$streaming$sqs$SqsClient$$sqsFetchMessages();
                    if (newMessages.nonEmpty()) {
                        ((IterableLike)newMessages.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1 $outer;

                            public final boolean apply(Tuple3<String, Object, String> message) {
                                return this.$outer.org$apache$spark$sql$streaming$sqs$SqsClient$$anon$$$outer().sqsFileCache().isNewFile((String)message._1(), BoxesRunTime.unboxToLong((Object)message._2()));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        })).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1 $outer;

                            public final void apply(Tuple3<String, Object, String> message) {
                                this.$outer.org$apache$spark$sql$streaming$sqs$SqsClient$$anon$$$outer().sqsFileCache().add((String)message._1(), new MessageDescription(BoxesRunTime.unboxToLong((Object)message._2()), false, (String)message._3()));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    this.$outer.exception_$eq((Option<Exception>)new Some((Object)exception));
                }
            }

            public /* synthetic */ SqsClient org$apache$spark$sql$streaming$sqs$SqsClient$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.sqsScheduler().scheduleWithFixedDelay(this.sqsFetchMessagesThread(), 0L, this.org$apache$spark$sql$streaming$sqs$SqsClient$$sqsFetchIntervalSeconds(), TimeUnit.SECONDS);
    }
}

