/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.sqs;

import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.streaming.sqs.MessageDescription;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001=\u0011AbU9t\r&dWmQ1dQ\u0016T!a\u0001\u0003\u0002\u0007M\f8O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A1\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\u0011\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u001c1\t9Aj\\4hS:<\u0007\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u00115\f\u00070Q4f\u001bN\u0004\"!E\u0010\n\u0005\u0001\u0012\"\u0001\u0002'p]\u001eDAB\t\u0001\u0005\u0002\u0003\u0015)\u0011!Q\u0001\n\r\nQh\u001c:hI\u0005\u0004\u0018m\u00195fIM\u0004\u0018M]6%gFdGe\u001d;sK\u0006l\u0017N\\4%gF\u001cHeU9t\r&dWmQ1dQ\u0016$CEZ5mK:\u000bW.Z(oYf\u0004\"!\u0005\u0013\n\u0005\u0015\u0012\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006O\u0001!\t\u0001K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007%ZC\u0006\u0005\u0002+\u00015\t!\u0001C\u0003\u001eM\u0001\u0007a\u0004C\u0003.M\u0001\u00071%\u0001\u0007gS2,g*Y7f\u001f:d\u0017\u0010C\u00040\u0001\t\u0007I\u0011\u0002\u0019\u0002\rM\f8/T1q+\u0005\t\u0004\u0003\u0002\u001a:w\tk\u0011a\r\u0006\u0003iU\n!bY8oGV\u0014(/\u001a8u\u0015\t1t'\u0001\u0003vi&d'\"\u0001\u001d\u0002\t)\fg/Y\u0005\u0003uM\u0012\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\tatH\u0004\u0002\u0012{%\u0011aHE\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?%A\u0011!fQ\u0005\u0003\t\n\u0011!#T3tg\u0006<W\rR3tGJL\u0007\u000f^5p]\"1a\t\u0001Q\u0001\nE\nqa]9t\u001b\u0006\u0004\b\u0005C\u0004I\u0001\u0001\u0007I\u0011B%\u0002%1\f7\u000f\u001e)ve\u001e,G+[7fgR\fW\u000e]\u000b\u0002=!91\n\u0001a\u0001\n\u0013a\u0015A\u00067bgR\u0004VO]4f)&lWm\u001d;b[B|F%Z9\u0015\u00055\u0003\u0006CA\tO\u0013\ty%C\u0001\u0003V]&$\bbB)K\u0003\u0003\u0005\rAH\u0001\u0004q\u0012\n\u0004BB*\u0001A\u0003&a$A\nmCN$\b+\u001e:hKRKW.Z:uC6\u0004\b\u0005C\u0004V\u0001\u0001\u0007I\u0011B%\u0002\u001f1\fG/Z:u)&lWm\u001d;b[BDqa\u0016\u0001A\u0002\u0013%\u0001,A\nmCR,7\u000f\u001e+j[\u0016\u001cH/Y7q?\u0012*\u0017\u000f\u0006\u0002N3\"9\u0011KVA\u0001\u0002\u0004q\u0002BB.\u0001A\u0003&a$\u0001\tmCR,7\u000f\u001e+j[\u0016\u001cH/Y7qA!)Q\f\u0001C\u0005=\u0006!2\u000f\u001e:jaB\u000bG\u000f[%g\u001d\u0016\u001cWm]:bef$\"a\u00183\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t<\u0014\u0001\u00027b]\u001eL!\u0001Q1\t\u000b\u0015d\u0006\u0019A\u001e\u0002\tA\fG\u000f\u001b\u0015\u00039\u001e\u0004\"!\u00055\n\u0005%\u0014\"AB5oY&tW\rC\u0003l\u0001\u0011\u0005A.A\u0005jg:+wOR5mKR\u00191%\u001c8\t\u000b\u0015T\u0007\u0019A\u001e\t\u000b=T\u0007\u0019\u0001\u0010\u0002\u0013QLW.Z:uC6\u0004\b\"B9\u0001\t\u0003\u0011\u0018aA1eIR\u0019Qj\u001d;\t\u000b\u0015\u0004\b\u0019A\u001e\t\u000bU\u0004\b\u0019\u0001\"\u0002\u0015\u0019LG.Z*uCR,8\u000fC\u0003x\u0001\u0011\u0005\u00010A\nhKR,fnY8n[&$H/\u001a3GS2,7\u000fF\u0003z\u0003#\t\t\u0003E\u0003{\u0003\u000b\tYAD\u0002|\u0003\u0003q!\u0001`@\u000e\u0003uT!A \b\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0012bAA\u0002%\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0004\u0003\u0013\u00111aU3r\u0015\r\t\u0019A\u0005\t\u0007#\u000551HH\u001e\n\u0007\u0005=!C\u0001\u0004UkBdWm\r\u0005\b\u0003'1\b\u0019AA\u000b\u0003Ii\u0017\r\u001f$jY\u0016\u001c\b+\u001a:Ue&<w-\u001a:\u0011\u000bE\t9\"a\u0007\n\u0007\u0005e!C\u0001\u0004PaRLwN\u001c\t\u0004#\u0005u\u0011bAA\u0010%\t\u0019\u0011J\u001c;\t\r\u0005\rb\u000f1\u0001$\u0003=\u0019\bn\\;mIN{'\u000f\u001e$jY\u0016\u001c\bbBA\u0014\u0001\u0011%\u0011\u0011F\u0001\u001aM&dG/\u001a:U_B,fnY8n[&$H/\u001a3GS2,7\u000f\u0006\u0003\u0002,\u0005E\u0002#\u0002>\u0002.\u0005-\u0011\u0002BA\u0018\u0003\u0013\u0011A\u0001T5ti\"A\u00111CA\u0013\u0001\u0004\tY\u0002C\u0004\u00026\u0001!I!a\u000e\u0002\u001fI,\u0007o\u001c:u)&lW\rV1lK:,B!!\u000f\u0002BQ!\u00111HA/)\u0011\ti$a\u0015\u0011\t\u0005}\u0012\u0011\t\u0007\u0001\t!\t\u0019%a\rC\u0002\u0005\u0015#!\u0001+\u0012\t\u0005\u001d\u0013Q\n\t\u0004#\u0005%\u0013bAA&%\t9aj\u001c;iS:<\u0007cA\t\u0002P%\u0019\u0011\u0011\u000b\n\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002V\u0005MB\u00111\u0001\u0002X\u0005!!m\u001c3z!\u0015\t\u0012\u0011LA\u001f\u0013\r\tYF\u0005\u0002\ty\tLh.Y7f}!9\u0011qLA\u001a\u0001\u0004Y\u0014!C8qKJ\fG/[8o\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003K\n\u0011DZ5mi\u0016\u0014\u0018\t\u001c7V]\u000e|W.\\5ui\u0016$g)\u001b7fgR\u0011\u00111\u0006\u0005\b\u0003S\u0002A\u0011AA6\u0003\u0015\u0001XO]4f)\t\tY\u0002C\u0004\u0002p\u0001!\t!!\u001d\u0002\u001b5\f'o[\"p[6LG\u000f^3e)\ri\u00151\u000f\u0005\u0007K\u00065\u0004\u0019A\u001e\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z\u0005!1/\u001b>f+\t\tY\u0002")
public class SqsFileCache
implements Logging {
    private final long maxAgeMs;
    public final boolean org$apache$spark$sql$streaming$sqs$SqsFileCache$$fileNameOnly;
    private final ConcurrentHashMap<String, MessageDescription> org$apache$spark$sql$streaming$sqs$SqsFileCache$$sqsMap;
    private long org$apache$spark$sql$streaming$sqs$SqsFileCache$$lastPurgeTimestamp;
    private long latestTimestamp;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public void initalizeLoganIfNecessary() {
        Logging.class.initalizeLoganIfNecessary((Logging)this);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public ConcurrentHashMap<String, MessageDescription> org$apache$spark$sql$streaming$sqs$SqsFileCache$$sqsMap() {
        return this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$sqsMap;
    }

    public long org$apache$spark$sql$streaming$sqs$SqsFileCache$$lastPurgeTimestamp() {
        return this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$lastPurgeTimestamp;
    }

    private void org$apache$spark$sql$streaming$sqs$SqsFileCache$$lastPurgeTimestamp_$eq(long x$1) {
        this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$lastPurgeTimestamp = x$1;
    }

    private long latestTimestamp() {
        return this.latestTimestamp;
    }

    private void latestTimestamp_$eq(long x$1) {
        this.latestTimestamp = x$1;
    }

    private String stripPathIfNecessary(String path) {
        return this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$fileNameOnly ? new Path(new URI(path)).getName() : path;
    }

    public boolean isNewFile(String path, long timestamp) {
        return timestamp >= this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$lastPurgeTimestamp() && !this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$sqsMap().containsKey(this.stripPathIfNecessary(path));
    }

    public void add(String path, MessageDescription fileStatus) {
        this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$sqsMap().put(this.stripPathIfNecessary(path), fileStatus);
        if (fileStatus.timestamp() > this.latestTimestamp()) {
            this.latestTimestamp_$eq(fileStatus.timestamp());
        }
    }

    public Seq<Tuple3<String, Object, String>> getUncommittedFiles(Option<Object> maxFilesPerTrigger, boolean shouldSortFiles) {
        Object object;
        if (shouldSortFiles) {
            List<Tuple3<String, Object, String>> uncommittedFiles = this.filterAllUncommittedFiles();
            List sortedFiles = (List)this.reportTimeTaken("Sorting Files", (Function0)new Serializable(this, uncommittedFiles){
                public static final long serialVersionUID = 0L;
                private final List uncommittedFiles$1;

                public final List<Tuple3<String, Object, String>> apply() {
                    return (List)this.uncommittedFiles$1.sortWith((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple3<String, Object, String> x$1, Tuple3<String, Object, String> x$2) {
                            return BoxesRunTime.unboxToLong((Object)x$1._2()) < BoxesRunTime.unboxToLong((Object)x$2._2());
                        }
                    });
                }
                {
                    this.uncommittedFiles$1 = uncommittedFiles$1;
                }
            });
            object = maxFilesPerTrigger.nonEmpty() ? sortedFiles.take(BoxesRunTime.unboxToInt((Object)maxFilesPerTrigger.get())) : sortedFiles;
        } else {
            object = maxFilesPerTrigger.isEmpty() ? this.filterAllUncommittedFiles() : this.filterTopUncommittedFiles(BoxesRunTime.unboxToInt((Object)maxFilesPerTrigger.get()));
        }
        return object;
    }

    private List<Tuple3<String, Object, String>> filterTopUncommittedFiles(int maxFilesPerTrigger) {
        Iterator iterator = ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$sqsMap()).asScala()).iterator();
        ListBuffer uncommittedFiles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (uncommittedFiles.length() < maxFilesPerTrigger && iterator.hasNext()) {
            Tuple2 file = (Tuple2)iterator.next();
            Object object = ((MessageDescription)file._2()).isCommitted() && ((MessageDescription)file._2()).timestamp() >= this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$lastPurgeTimestamp() ? uncommittedFiles.$plus$eq((Object)new Tuple3(file._1(), (Object)BoxesRunTime.boxToLong((long)((MessageDescription)file._2()).timestamp()), (Object)((MessageDescription)file._2()).messageReceiptHandle())) : BoxedUnit.UNIT;
        }
        return uncommittedFiles.toList();
    }

    private <T> T reportTimeTaken(String operation, Function0<T> body) {
        long startTime = System.currentTimeMillis();
        Object result = body.apply();
        long endTime = System.currentTimeMillis();
        long timeTaken = package$.MODULE$.max(endTime - startTime, 0L);
        this.logDebug((Function0<String>)new Serializable(this, operation, timeTaken){
            public static final long serialVersionUID = 0L;
            private final String operation$1;
            private final long timeTaken$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " took ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.operation$1, BoxesRunTime.boxToLong((long)this.timeTaken$1)}));
            }
            {
                this.operation$1 = operation$1;
                this.timeTaken$1 = timeTaken$1;
            }
        });
        return (T)result;
    }

    private List<Tuple3<String, Object, String>> filterAllUncommittedFiles() {
        return (List)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$sqsMap()).asScala()).foldLeft((Object)Nil$.MODULE$, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SqsFileCache $outer;

            public final List<Tuple3<String, Object, String>> apply(List<Tuple3<String, Object, String>> list, Tuple2<String, MessageDescription> file) {
                return !((MessageDescription)file._2()).isCommitted() && ((MessageDescription)file._2()).timestamp() >= this.$outer.org$apache$spark$sql$streaming$sqs$SqsFileCache$$lastPurgeTimestamp() ? (List)list.$colon$plus((Object)new Tuple3(file._1(), (Object)BoxesRunTime.boxToLong((long)((MessageDescription)file._2()).timestamp()), (Object)((MessageDescription)file._2()).messageReceiptHandle()), List$.MODULE$.canBuildFrom()) : list;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public int purge() {
        this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$lastPurgeTimestamp_$eq(this.latestTimestamp() - this.maxAgeMs);
        IntRef count = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$sqsMap()).asScala()).foreach((Function1)new Serializable(this, count){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SqsFileCache $outer;
            private final IntRef count$1;

            public final void apply(Tuple2<String, MessageDescription> fileEntry) {
                if (((MessageDescription)fileEntry._2()).timestamp() < this.$outer.org$apache$spark$sql$streaming$sqs$SqsFileCache$$lastPurgeTimestamp()) {
                    this.$outer.org$apache$spark$sql$streaming$sqs$SqsFileCache$$sqsMap().remove(fileEntry._1());
                    ++this.count$1.elem;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.count$1 = count$1;
            }
        });
        return count.elem;
    }

    public void markCommitted(String path) {
        this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$sqsMap().replace(path, new MessageDescription(this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$sqsMap().get(path).timestamp(), true, this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$sqsMap().get(path).messageReceiptHandle()));
    }

    public int size() {
        return this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$sqsMap().size();
    }

    public SqsFileCache(long maxAgeMs, boolean fileNameOnly) {
        this.maxAgeMs = maxAgeMs;
        this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$fileNameOnly = fileNameOnly;
        Logging.class.$init$((Logging)this);
        Predef$.MODULE$.require(maxAgeMs >= 0L);
        if (fileNameOnly) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "'fileNameOnly' is enabled. Make sure your file names are unique (e.g. using UUID), otherwise, files with the same name but under different paths will be considered the same and causes data lost.";
                }
            });
        }
        this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$sqsMap = new ConcurrentHashMap();
        this.org$apache$spark$sql$streaming$sqs$SqsFileCache$$lastPurgeTimestamp = 0L;
        this.latestTimestamp = 0L;
    }
}

