/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.sqs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.streaming.FileStreamSource;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog$;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset$;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.streaming.sqs.MessageDescription;
import org.apache.spark.sql.streaming.sqs.SqsClient;
import org.apache.spark.sql.streaming.sqs.SqsSourceOptions;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0001\u0003\u0001=\u0011\u0011bU9t'>,(oY3\u000b\u0005\r!\u0011aA:rg*\u0011QAB\u0001\ngR\u0014X-Y7j]\u001eT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u0019?A\u0011\u0011CF\u0007\u0002%)\u00111\u0003F\u0001\u0005Y\u0006twMC\u0001\u0016\u0003\u0011Q\u0017M^1\n\u0005]\u0011\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001a;5\t!D\u0003\u0002\u00067)\u0011ADB\u0001\nKb,7-\u001e;j_:L!A\b\u000e\u0003\rM{WO]2f!\t\u00013%D\u0001\"\u0015\t\u0011\u0003\"\u0001\u0005j]R,'O\\1m\u0013\t!\u0013EA\u0004M_\u001e<\u0017N\\4\t\u0011\u0019\u0002!\u0011!Q\u0001\n\u001d\nAb\u001d9be.\u001cVm]:j_:\u0004\"\u0001K\u0015\u000e\u0003\u0019I!A\u000b\u0004\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u00111\u0002!\u0011!Q\u0001\n5\nA\"\\3uC\u0012\fG/\u0019)bi\"\u0004\"A\f\u001b\u000f\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0002\rA\u0013X\rZ3g\u0013\t)dG\u0001\u0004TiJLgn\u001a\u0006\u0003gAB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!O\u0001\b_B$\u0018n\u001c8t!\u0011q#(L\u0017\n\u0005m2$aA'ba\"AQ\b\u0001BC\u0002\u0013\u0005c(\u0001\u0004tG\",W.Y\u000b\u0002\u007fA\u0011\u0001iQ\u0007\u0002\u0003*\u0011!IB\u0001\u0006if\u0004Xm]\u0005\u0003\t\u0006\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011!1\u0005A!A!\u0002\u0013y\u0014aB:dQ\u0016l\u0017\r\t\u0005\u0006\u0011\u0002!\t!S\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b)cUJT(\u0011\u0005-\u0003Q\"\u0001\u0002\t\u000b\u0019:\u0005\u0019A\u0014\t\u000b1:\u0005\u0019A\u0017\t\u000ba:\u0005\u0019A\u001d\t\u000bu:\u0005\u0019A \t\u000fE\u0003!\u0019!C\u0005%\u0006i1o\\;sG\u0016|\u0005\u000f^5p]N,\u0012a\u0015\t\u0003\u0017RK!!\u0016\u0002\u0003!M\u000b8oU8ve\u000e,w\n\u001d;j_:\u001c\bBB,\u0001A\u0003%1+\u0001\bt_V\u00148-Z(qi&|gn\u001d\u0011\t\u000fe\u0003!\u0019!C\u00055\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0016\u0003m\u0003\"\u0001X1\u000e\u0003uS!AX0\u0002\t\r|gN\u001a\u0006\u0003A*\ta\u0001[1e_>\u0004\u0018B\u00012^\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"1A\r\u0001Q\u0001\nm\u000b1\u0002[1e_>\u00048i\u001c8gA!9a\r\u0001b\u0001\n\u00139\u0017aC7fi\u0006$\u0017\r^1M_\u001e,\u0012\u0001\u001b\t\u00033%L!A\u001b\u000e\u0003'\u0019KG.Z*ue\u0016\fWnU8ve\u000e,Gj\\4\t\r1\u0004\u0001\u0015!\u0003i\u00031iW\r^1eCR\fGj\\4!\u0011\u001dq\u0007\u00011A\u0005\n=\f\u0001$\\3uC\u0012\fG/\u0019'pO\u000e+(O]3oi>3gm]3u+\u0005\u0001\bCA\u0018r\u0013\t\u0011\bG\u0001\u0003M_:<\u0007b\u0002;\u0001\u0001\u0004%I!^\u0001\u001d[\u0016$\u0018\rZ1uC2{wmQ;se\u0016tGo\u00144gg\u0016$x\fJ3r)\t1\u0018\u0010\u0005\u00020o&\u0011\u0001\u0010\r\u0002\u0005+:LG\u000fC\u0004{g\u0006\u0005\t\u0019\u00019\u0002\u0007a$\u0013\u0007\u0003\u0004}\u0001\u0001\u0006K\u0001]\u0001\u001a[\u0016$\u0018\rZ1uC2{wmQ;se\u0016tGo\u00144gg\u0016$\b\u0005C\u0004\u007f\u0001\t\u0007I\u0011B@\u0002%5\f\u0007PR5mKN\u0004VM\u001d+sS\u001e<WM]\u000b\u0003\u0003\u0003\u0001RaLA\u0002\u0003\u000fI1!!\u00021\u0005\u0019y\u0005\u000f^5p]B\u0019q&!\u0003\n\u0007\u0005-\u0001GA\u0002J]RD\u0001\"a\u0004\u0001A\u0003%\u0011\u0011A\u0001\u0014[\u0006Dh)\u001b7fgB+'\u000f\u0016:jO\u001e,'\u000f\t\u0005\t\u0003'\u0001!\u0019!C\u0005_\u0006aQ.\u0019=GS2,\u0017iZ3Ng\"9\u0011q\u0003\u0001!\u0002\u0013\u0001\u0018!D7bq\u001aKG.Z!hK6\u001b\b\u0005C\u0005\u0002\u001c\u0001\u0011\r\u0011\"\u0003\u0002\u001e\u0005\u0019b-\u001b7f\r>\u0014X.\u0019;DY\u0006\u001c8OT1nKV\tQ\u0006C\u0004\u0002\"\u0001\u0001\u000b\u0011B\u0017\u0002)\u0019LG.\u001a$pe6\fGo\u00117bgNt\u0015-\\3!\u0011%\t)\u0003\u0001b\u0001\n\u0013\t9#A\btQ>,H\u000eZ*peR4\u0015\u000e\\3t+\t\tI\u0003E\u00020\u0003WI1!!\f1\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\r\u0001A\u0003%\u0011\u0011F\u0001\u0011g\"|W\u000f\u001c3T_J$h)\u001b7fg\u0002B\u0011\"!\u000e\u0001\u0005\u0004%I!a\u000e\u0002\u0013M\f8o\u00117jK:$XCAA\u001d!\rY\u00151H\u0005\u0004\u0003{\u0011!!C*rg\u000ec\u0017.\u001a8u\u0011!\t\t\u0005\u0001Q\u0001\n\u0005e\u0012AC:rg\u000ec\u0017.\u001a8uA!9\u0011Q\t\u0001\u0005B\u0005\u001d\u0013\u0001C4fi\n\u000bGo\u00195\u0015\r\u0005%\u0013QNA=!\u0011\tY%a\u001a\u000f\t\u00055\u00131\r\b\u0005\u0003\u001f\n\tG\u0004\u0003\u0002R\u0005}c\u0002BA*\u0003;rA!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0004\u00033r\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0004\u0003K2\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003S\nYGA\u0005ECR\fgI]1nK*\u0019\u0011Q\r\u0004\t\u0011\u0005=\u00141\ta\u0001\u0003c\nQa\u001d;beR\u0004RaLA\u0002\u0003g\u00022!GA;\u0013\r\t9H\u0007\u0002\u0007\u001f\u001a47/\u001a;\t\u0011\u0005m\u00141\ta\u0001\u0003g\n1!\u001a8e\u0011\u001d\ty\b\u0001C\u0005\u0003\u0003\u000baBZ3uG\"l\u0015\r_(gMN,G\u000f\u0006\u0002\u0002\u0004B\u0019\u0011$!\"\n\u0007\u0005\u001d%D\u0001\fGS2,7\u000b\u001e:fC6\u001cv.\u001e:dK>3gm]3u\u0011\u001d\tY\t\u0001C!\u0003\u001b\u000b\u0011bZ3u\u001f\u001a47/\u001a;\u0016\u0005\u0005E\u0004bBAI\u0001\u0011\u0005\u00131S\u0001\u0007G>lW.\u001b;\u0015\u0007Y\f)\n\u0003\u0005\u0002|\u0005=\u0005\u0019AA:\u0011\u001d\tI\n\u0001C!\u00037\u000bAa\u001d;paR\ta\u000fC\u0004\u0002 \u0002!\t%!)\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\f")
public class SqsSource
implements Source,
Logging {
    private final SparkSession sparkSession;
    private final Map<String, String> options;
    private final StructType schema;
    private final SqsSourceOptions sourceOptions;
    private final Configuration hadoopConf;
    private final FileStreamSourceLog metadataLog;
    private long org$apache$spark$sql$streaming$sqs$SqsSource$$metadataLogCurrentOffset;
    private final Option<Object> org$apache$spark$sql$streaming$sqs$SqsSource$$maxFilesPerTrigger;
    private final long org$apache$spark$sql$streaming$sqs$SqsSource$$maxFileAgeMs;
    private final String fileFormatClassName;
    private final boolean shouldSortFiles;
    private final SqsClient org$apache$spark$sql$streaming$sqs$SqsSource$$sqsClient;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public void initalizeLoganIfNecessary() {
        Logging.class.initalizeLoganIfNecessary((Logging)this);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public StructType schema() {
        return this.schema;
    }

    private SqsSourceOptions sourceOptions() {
        return this.sourceOptions;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private FileStreamSourceLog metadataLog() {
        return this.metadataLog;
    }

    public long org$apache$spark$sql$streaming$sqs$SqsSource$$metadataLogCurrentOffset() {
        return this.org$apache$spark$sql$streaming$sqs$SqsSource$$metadataLogCurrentOffset;
    }

    private void org$apache$spark$sql$streaming$sqs$SqsSource$$metadataLogCurrentOffset_$eq(long x$1) {
        this.org$apache$spark$sql$streaming$sqs$SqsSource$$metadataLogCurrentOffset = x$1;
    }

    public Option<Object> org$apache$spark$sql$streaming$sqs$SqsSource$$maxFilesPerTrigger() {
        return this.org$apache$spark$sql$streaming$sqs$SqsSource$$maxFilesPerTrigger;
    }

    public long org$apache$spark$sql$streaming$sqs$SqsSource$$maxFileAgeMs() {
        return this.org$apache$spark$sql$streaming$sqs$SqsSource$$maxFileAgeMs;
    }

    private String fileFormatClassName() {
        return this.fileFormatClassName;
    }

    private boolean shouldSortFiles() {
        return this.shouldSortFiles;
    }

    public SqsClient org$apache$spark$sql$streaming$sqs$SqsSource$$sqsClient() {
        return this.org$apache$spark$sql$streaming$sqs$SqsSource$$sqsClient;
    }

    public Dataset<Row> getBatch(Option<Offset> start, Offset end) {
        long endOffset;
        long startOffset = BoxesRunTime.unboxToLong((Object)start.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Offset x$2) {
                return FileStreamSourceOffset$.MODULE$.apply(x$2).logOffset();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        Predef$.MODULE$.assert(startOffset <= (endOffset = FileStreamSourceOffset$.MODULE$.apply(end).logOffset()));
        FileStreamSource.FileEntry[] files = (FileStreamSource.FileEntry[])Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().get((Option)new Some((Object)BoxesRunTime.boxToLong((long)(startOffset + 1L))), (Option)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)))).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<FileStreamSource.FileEntry> apply(Tuple2<Object, FileStreamSource.FileEntry[]> x$3) {
                return Predef$.MODULE$.refArrayOps((Object[])x$3._2());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class)));
        this.logInfo((Function0<String>)new Serializable(this, startOffset, endOffset, files){
            public static final long serialVersionUID = 0L;
            private final long startOffset$1;
            private final long endOffset$1;
            private final FileStreamSource.FileEntry[] files$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing ", " files from ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$1.length), BoxesRunTime.boxToLong((long)(this.startOffset$1 + 1L)), BoxesRunTime.boxToLong((long)this.endOffset$1)}));
            }
            {
                this.startOffset$1 = startOffset$1;
                this.endOffset$1 = endOffset$1;
                this.files$1 = files$1;
            }
        });
        this.logTrace((Function0<String>)new Serializable(this, files){
            public static final long serialVersionUID = 0L;
            private final FileStreamSource.FileEntry[] files$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files are:\\n\\t"})).s((Seq)Nil$.MODULE$)).append((Object)Predef$.MODULE$.refArrayOps((Object[])this.files$1).mkString("\n\t")).toString();
            }
            {
                this.files$1 = files$1;
            }
        });
        SparkSession x$5 = this.sparkSession;
        Seq x$6 = (Seq)Predef$.MODULE$.refArrayOps((Object[])files).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStreamSource.FileEntry f) {
                return new Path(new URI(f.path())).toString();
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        Some x$7 = new Some((Object)this.schema());
        String x$8 = this.fileFormatClassName();
        Map<String, String> x$9 = this.options;
        Seq x$10 = DataSource$.MODULE$.apply$default$5();
        Option x$11 = DataSource$.MODULE$.apply$default$6();
        Option x$12 = DataSource$.MODULE$.apply$default$8();
        DataSource newDataSource = new DataSource(x$5, x$8, x$6, (Option)x$7, x$10, x$11, x$9, x$12);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)LogicalRelation$.MODULE$.apply(newDataSource.resolveRelation(false), true), Dataset$.MODULE$.ofRows$default$3());
    }

    private synchronized FileStreamSourceOffset fetchMaxOffset() {
        this.org$apache$spark$sql$streaming$sqs$SqsSource$$sqsClient().assertSqsIsWorking();
        Seq<Tuple3<String, Object, String>> batchFiles = this.org$apache$spark$sql$streaming$sqs$SqsSource$$sqsClient().sqsFileCache().getUncommittedFiles(this.org$apache$spark$sql$streaming$sqs$SqsSource$$maxFilesPerTrigger(), this.shouldSortFiles());
        if (batchFiles.nonEmpty()) {
            this.org$apache$spark$sql$streaming$sqs$SqsSource$$metadataLogCurrentOffset_$eq(this.org$apache$spark$sql$streaming$sqs$SqsSource$$metadataLogCurrentOffset() + 1L);
            this.metadataLog().add(this.org$apache$spark$sql$streaming$sqs$SqsSource$$metadataLogCurrentOffset(), (FileStreamSource.FileEntry[])((TraversableOnce)batchFiles.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SqsSource $outer;

                public final FileStreamSource.FileEntry apply(Tuple3<String, Object, String> x0$1) {
                    Tuple3<String, Object, String> tuple3 = x0$1;
                    if (tuple3 != null) {
                        String path = (String)tuple3._1();
                        long timestamp = BoxesRunTime.unboxToLong((Object)tuple3._2());
                        FileStreamSource.FileEntry fileEntry = new FileStreamSource.FileEntry(path, timestamp, this.$outer.org$apache$spark$sql$streaming$sqs$SqsSource$$metadataLogCurrentOffset());
                        return fileEntry;
                    }
                    throw new MatchError(tuple3);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class)));
            this.logInfo((Function0<String>)new Serializable(this, batchFiles){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SqsSource $outer;
                private final Seq batchFiles$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log offset set to ", " with ", " new files"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$sql$streaming$sqs$SqsSource$$metadataLogCurrentOffset()), BoxesRunTime.boxToInteger((int)this.batchFiles$1.size())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.batchFiles$1 = batchFiles$1;
                }
            });
            List messageReceiptHandles = ((TraversableOnce)batchFiles.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SqsSource $outer;

                public final String apply(Tuple3<String, Object, String> x0$2) {
                    Tuple3<String, Object, String> tuple3 = x0$2;
                    if (tuple3 != null) {
                        String path = (String)tuple3._1();
                        String receiptHandle = (String)tuple3._3();
                        this.$outer.org$apache$spark$sql$streaming$sqs$SqsSource$$sqsClient().sqsFileCache().markCommitted(path);
                        this.$outer.logDebug((Function0<String>)new Serializable(this, path){
                            public static final long serialVersionUID = 0L;
                            private final String path$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"New file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
                            }
                            {
                                this.path$1 = path$1;
                            }
                        });
                        String string = receiptHandle;
                        return string;
                    }
                    throw new MatchError(tuple3);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom())).toList();
            this.org$apache$spark$sql$streaming$sqs$SqsSource$$sqsClient().addToDeleteMessageQueue((List<String>)messageReceiptHandles);
        }
        int numPurged = this.org$apache$spark$sql$streaming$sqs$SqsSource$$sqsClient().sqsFileCache().purge();
        if (!this.org$apache$spark$sql$streaming$sqs$SqsSource$$sqsClient().deleteMessageQueue().isEmpty()) {
            this.org$apache$spark$sql$streaming$sqs$SqsSource$$sqsClient().deleteMessagesFromQueue();
        }
        this.logTrace((Function0<String>)new Serializable(this, batchFiles, numPurged){
            public static final long serialVersionUID = 0L;
            private final Seq batchFiles$1;
            private final int numPurged$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |Number of files selected for batch = ", "\n         |Number of files purged from tracking map = ", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.batchFiles$1.size()), BoxesRunTime.boxToInteger((int)this.numPurged$1)})))).stripMargin();
            }
            {
                this.batchFiles$1 = batchFiles$1;
                this.numPurged$1 = numPurged$1;
            }
        });
        return new FileStreamSourceOffset(this.org$apache$spark$sql$streaming$sqs$SqsSource$$metadataLogCurrentOffset());
    }

    public Option<Offset> getOffset() {
        return new Some((Object)this.fetchMaxOffset()).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStreamSourceOffset x$4) {
                return x$4.logOffset() == -1L;
            }
        });
    }

    public void commit(Offset end) {
    }

    public void stop() {
        if (!this.org$apache$spark$sql$streaming$sqs$SqsSource$$sqsClient().sqsScheduler().isTerminated()) {
            this.org$apache$spark$sql$streaming$sqs$SqsSource$$sqsClient().sqsScheduler().shutdownNow();
        }
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SqsSource[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$streaming$sqs$SqsSource$$sqsClient().sqsUrl()}));
    }

    public SqsSource(SparkSession sparkSession, String metadataPath, Map<String, String> options, StructType schema) {
        this.sparkSession = sparkSession;
        this.options = options;
        this.schema = schema;
        Source.class.$init$((Source)this);
        Logging.class.$init$((Logging)this);
        this.sourceOptions = new SqsSourceOptions(options);
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
        this.metadataLog = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), sparkSession, metadataPath);
        this.org$apache$spark$sql$streaming$sqs$SqsSource$$metadataLogCurrentOffset = BoxesRunTime.unboxToLong((Object)this.metadataLog().getLatest().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, FileStreamSource.FileEntry[]> x$1) {
                return x$1._1$mcJ$sp();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        this.org$apache$spark$sql$streaming$sqs$SqsSource$$maxFilesPerTrigger = this.sourceOptions().maxFilesPerTrigger();
        this.org$apache$spark$sql$streaming$sqs$SqsSource$$maxFileAgeMs = this.sourceOptions().maxFileAgeMs();
        this.fileFormatClassName = this.sourceOptions().fileFormatClassName();
        this.shouldSortFiles = this.sourceOptions().shouldSortFiles();
        this.org$apache$spark$sql$streaming$sqs$SqsSource$$sqsClient = new SqsClient(this.sourceOptions(), this.hadoopConf());
        Predef$.MODULE$.refArrayOps(this.metadataLog().allFiles()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SqsSource $outer;

            public final void apply(FileStreamSource.FileEntry entry) {
                this.$outer.org$apache$spark$sql$streaming$sqs$SqsSource$$sqsClient().sqsFileCache().add(entry.path(), new MessageDescription(entry.timestamp(), true, ""));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$spark$sql$streaming$sqs$SqsSource$$sqsClient().sqsFileCache().purge();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SqsSource $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxFilesPerBatch = ", ", maxFileAgeMs = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$streaming$sqs$SqsSource$$maxFilesPerTrigger(), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$sql$streaming$sqs$SqsSource$$maxFileAgeMs())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

