/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.support;

import com.querydsl.core.JoinExpression;
import com.querydsl.core.alias.Alias;
import com.querydsl.core.domain.QCommonPersistence;
import com.querydsl.core.support.DummyEntity;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MapExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadataFactory;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import org.junit.Assert;
import org.junit.Test;

public class QueryMixinTest {
    private QueryMixin<?> mixin = new QueryMixin();
    private QCommonPersistence entity = new QCommonPersistence(PathMetadataFactory.forVariable((String)"entity"));

    @Test
    public void where_null() {
        this.mixin.where((Predicate)null);
    }

    @Test
    public void getJoins_with_condition() {
        this.mixin.innerJoin((Expression)this.entity);
        this.mixin.on(new Predicate[]{this.entity.version.isNull(), this.entity.version.isNotNull()});
        Assert.assertEquals((long)1L, (long)this.mixin.getMetadata().getJoins().size());
        JoinExpression je = (JoinExpression)this.mixin.getMetadata().getJoins().get(0);
        Assert.assertEquals((Object)((Object)this.entity), (Object)je.getTarget());
        Assert.assertEquals((Object)Expressions.allOf((BooleanExpression[])new BooleanExpression[]{this.entity.version.isNull(), this.entity.version.isNotNull()}), (Object)je.getCondition());
    }

    @Test
    public void getJoins_no_condition() {
        this.mixin.innerJoin((Expression)this.entity);
        Assert.assertEquals((long)1L, (long)this.mixin.getMetadata().getJoins().size());
        JoinExpression je = (JoinExpression)this.mixin.getMetadata().getJoins().get(0);
        Assert.assertEquals((Object)((Object)this.entity), (Object)je.getTarget());
        Assert.assertNull((Object)je.getCondition());
    }

    @Test
    public void innerJoin() {
        DummyEntity e = (DummyEntity)Alias.alias(DummyEntity.class);
        DummyEntity e2 = (DummyEntity)Alias.alias(DummyEntity.class, (String)"e2");
        DummyEntity e3 = (DummyEntity)Alias.alias(DummyEntity.class, (String)"e3");
        DummyEntity e4 = (DummyEntity)Alias.alias(DummyEntity.class, (String)"e4");
        this.mixin.innerJoin((Expression)Alias.$((Object)e));
        this.mixin.innerJoin((Expression)Alias.$((Object)e.getOther()), (Path)Alias.$((Object)e2));
        this.mixin.innerJoin((CollectionExpression)Alias.$(e.getList()), (Path)Alias.$((Object)e3));
        this.mixin.innerJoin((Expression)Alias.$(e.getList()));
        this.mixin.innerJoin((MapExpression)Alias.$(e.getMap()), (Path)Alias.$((Object)e4));
        this.mixin.innerJoin((Expression)Alias.$(e.getMap()));
        Assert.assertEquals((long)6L, (long)this.mixin.getMetadata().getJoins().size());
    }

    @Test
    public void join() {
        DummyEntity e = (DummyEntity)Alias.alias(DummyEntity.class);
        DummyEntity e2 = (DummyEntity)Alias.alias(DummyEntity.class, (String)"e2");
        DummyEntity e3 = (DummyEntity)Alias.alias(DummyEntity.class, (String)"e3");
        DummyEntity e4 = (DummyEntity)Alias.alias(DummyEntity.class, (String)"e4");
        this.mixin.innerJoin((Expression)Alias.$((Object)e));
        this.mixin.innerJoin((Expression)Alias.$((Object)e.getOther()), (Path)Alias.$((Object)e2));
        this.mixin.innerJoin((CollectionExpression)Alias.$(e.getList()), (Path)Alias.$((Object)e3));
        this.mixin.innerJoin((Expression)Alias.$(e.getList()));
        this.mixin.innerJoin((MapExpression)Alias.$(e.getMap()), (Path)Alias.$((Object)e4));
        this.mixin.innerJoin((Expression)Alias.$(e.getMap()));
        Assert.assertEquals((long)6L, (long)this.mixin.getMetadata().getJoins().size());
    }

    @Test
    public void joins() {
        DummyEntity e = (DummyEntity)Alias.alias(DummyEntity.class);
        DummyEntity e2 = (DummyEntity)Alias.alias(DummyEntity.class, (String)"e2");
        this.mixin.join((Expression)Alias.$((Object)e));
        this.mixin.on((Predicate)Alias.$((Object)e).isNotNull());
        this.mixin.join((Expression)Alias.$((Object)e.getOther()), (Path)Alias.$((Object)e2));
        this.mixin.on((Predicate)Alias.$((Object)e).isNotNull());
        Assert.assertEquals((long)2L, (long)this.mixin.getMetadata().getJoins().size());
    }

    @Test
    public void leftJoin() {
        DummyEntity e = (DummyEntity)Alias.alias(DummyEntity.class);
        DummyEntity e2 = (DummyEntity)Alias.alias(DummyEntity.class, (String)"e2");
        DummyEntity e3 = (DummyEntity)Alias.alias(DummyEntity.class, (String)"e3");
        DummyEntity e4 = (DummyEntity)Alias.alias(DummyEntity.class, (String)"e4");
        this.mixin.leftJoin((Expression)Alias.$((Object)e));
        this.mixin.leftJoin((Expression)Alias.$((Object)e.getOther()), (Path)Alias.$((Object)e2));
        this.mixin.leftJoin((CollectionExpression)Alias.$(e.getList()), (Path)Alias.$((Object)e3));
        this.mixin.leftJoin((Expression)Alias.$(e.getList()));
        this.mixin.leftJoin((MapExpression)Alias.$(e.getMap()), (Path)Alias.$((Object)e4));
        this.mixin.leftJoin((Expression)Alias.$(e.getMap()));
        Assert.assertEquals((long)6L, (long)this.mixin.getMetadata().getJoins().size());
    }

    @Test
    public void rightJoin() {
        DummyEntity e = (DummyEntity)Alias.alias(DummyEntity.class);
        DummyEntity e2 = (DummyEntity)Alias.alias(DummyEntity.class, (String)"e2");
        DummyEntity e3 = (DummyEntity)Alias.alias(DummyEntity.class, (String)"e3");
        DummyEntity e4 = (DummyEntity)Alias.alias(DummyEntity.class, (String)"e4");
        this.mixin.rightJoin((Expression)Alias.$((Object)e));
        this.mixin.rightJoin((Expression)Alias.$((Object)e.getOther()), (Path)Alias.$((Object)e2));
        this.mixin.rightJoin((CollectionExpression)Alias.$(e.getList()), (Path)Alias.$((Object)e3));
        this.mixin.rightJoin((Expression)Alias.$(e.getList()));
        this.mixin.rightJoin((MapExpression)Alias.$(e.getMap()), (Path)Alias.$((Object)e4));
        this.mixin.rightJoin((Expression)Alias.$(e.getMap()));
        Assert.assertEquals((long)6L, (long)this.mixin.getMetadata().getJoins().size());
    }

    @Test
    public void fullJoin() {
        DummyEntity e = (DummyEntity)Alias.alias(DummyEntity.class);
        DummyEntity e2 = (DummyEntity)Alias.alias(DummyEntity.class, (String)"e2");
        DummyEntity e3 = (DummyEntity)Alias.alias(DummyEntity.class, (String)"e3");
        DummyEntity e4 = (DummyEntity)Alias.alias(DummyEntity.class, (String)"e4");
        this.mixin.fullJoin((Expression)Alias.$((Object)e));
        this.mixin.fullJoin((Expression)Alias.$((Object)e.getOther()), (Path)Alias.$((Object)e2));
        this.mixin.fullJoin((CollectionExpression)Alias.$(e.getList()), (Path)Alias.$((Object)e3));
        this.mixin.fullJoin((Expression)Alias.$(e.getList()));
        this.mixin.fullJoin((MapExpression)Alias.$(e.getMap()), (Path)Alias.$((Object)e4));
        this.mixin.fullJoin((Expression)Alias.$(e.getMap()));
        Assert.assertEquals((long)6L, (long)this.mixin.getMetadata().getJoins().size());
    }
}

