/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.annotations.PropertyType;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathMetadataFactory;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BeanPath;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.PathInits;
import com.querydsl.core.types.dsl.SimplePath;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class BeanPathTest {
    private BeanPath<BeanPathTest> beanPath = new BeanPath(BeanPathTest.class, "p");

    @Test
    public void as_path() {
        SimplePath simplePath = new SimplePath(BeanPathTest.class, "p");
        Assert.assertNotNull((Object)this.beanPath.as((Path)simplePath));
    }

    @Test
    @Ignore
    public void as_class() {
        MyBeanPath otherPath = (MyBeanPath)this.beanPath.as(MyBeanPath.class);
        Assert.assertEquals(this.beanPath, (Object)((Object)otherPath));
        Assert.assertTrue((boolean)otherPath.getMetadata().isRoot());
    }

    @Test
    public void as_class_cached() {
        MyBeanPath otherPath = (MyBeanPath)this.beanPath.as(MyBeanPath.class);
        Assert.assertTrue((otherPath == this.beanPath.as(MyBeanPath.class) ? 1 : 0) != 0);
    }

    @Test
    @Ignore
    public void as_class_with_inits() {
        this.beanPath = new BeanPath(BeanPathTest.class, PathMetadataFactory.forVariable((String)"p"), PathInits.DEFAULT);
        MyBeanPath otherPath = (MyBeanPath)this.beanPath.as(MyBeanPath.class);
        Assert.assertEquals(this.beanPath, (Object)((Object)otherPath));
    }

    @Test
    public void as_class_with_inits_cached() {
        this.beanPath = new BeanPath(BeanPathTest.class, PathMetadataFactory.forVariable((String)"p"), PathInits.DEFAULT);
        MyBeanPath otherPath = (MyBeanPath)this.beanPath.as(MyBeanPath.class);
        Assert.assertTrue((otherPath == this.beanPath.as(MyBeanPath.class) ? 1 : 0) != 0);
    }

    @Test
    public void createEnum() {
        Assert.assertNotNull((Object)this.beanPath.createEnum("property", PropertyType.class));
    }

    @Test
    public void instanceOf() {
        Assert.assertNotNull((Object)this.beanPath.instanceOf(BeanPathTest.class));
    }

    @Test
    public void instanceOfAny() {
        BooleanExpression pred1 = this.beanPath.instanceOf(BeanPathTest.class).or((Predicate)this.beanPath.instanceOf(SubClass.class));
        BooleanExpression pred2 = this.beanPath.instanceOfAny(new Class[]{BeanPathTest.class, SubClass.class});
        Assert.assertEquals((Object)pred1, (Object)pred2);
        Assert.assertEquals((Object)"p instanceof class com.querydsl.core.types.dsl.BeanPathTest || p instanceof class com.querydsl.core.types.dsl.BeanPathTest$SubClass", (Object)pred2.toString());
    }

    public static class MyBeanPath
    extends BeanPath<BeanPathTest> {
        private static final long serialVersionUID = 6225684967115368814L;

        public MyBeanPath(PathMetadata metadata) {
            super(BeanPathTest.class, metadata);
        }

        public MyBeanPath(PathMetadata metadata, @Nullable PathInits inits) {
            super(BeanPathTest.class, metadata);
        }
    }

    public static class SubClass
    extends BeanPathTest {
    }
}

