/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.ArrayPath;
import com.querydsl.core.types.dsl.BeanPath;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.CollectionPath;
import com.querydsl.core.types.dsl.ComparableExpression;
import com.querydsl.core.types.dsl.ComparablePath;
import com.querydsl.core.types.dsl.DateExpression;
import com.querydsl.core.types.dsl.DatePath;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.DateTimePath;
import com.querydsl.core.types.dsl.DslExpression;
import com.querydsl.core.types.dsl.EnumExpression;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.ListPath;
import com.querydsl.core.types.dsl.MapPath;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SetPath;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.TimeExpression;
import com.querydsl.core.types.dsl.TimePath;
import java.lang.reflect.Method;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SimpleExpressionTest {
    @Test
    public void as_usage() {
        StringPath str = new StringPath("str");
        Assert.assertEquals((Object)"str as alias", (Object)str.as("alias").toString());
        Assert.assertEquals((Object)"str as alias", (Object)str.as((Path)new StringPath("alias")).toString());
    }

    @Test
    public void case_() {
        StringPath str = new StringPath("str");
        str.when((Object)"xxx").thenNull().otherwise((Object)str);
    }

    @Test
    public void subclasses_override_as() throws SecurityException, NoSuchMethodException {
        List<Class> classes = Arrays.asList(BooleanExpression.class, ComparableExpression.class, DateExpression.class, DateTimeExpression.class, EnumExpression.class, NumberExpression.class, SimpleExpression.class, StringExpression.class, TimeExpression.class);
        for (Class cl : classes) {
            Method asPath = cl.getDeclaredMethod("as", Path.class);
            Assert.assertEquals((Object)cl, asPath.getReturnType());
            Method asString = cl.getDeclaredMethod("as", String.class);
            Assert.assertEquals((Object)cl, asString.getReturnType());
        }
    }

    @Test
    public void various() {
        ArrayList<Object> paths = new ArrayList<Object>();
        paths.add(new ArrayPath(String[].class, "p"));
        paths.add(new BeanPath(Object.class, "p"));
        paths.add(new BooleanPath("p"));
        paths.add(new CollectionPath(String.class, StringPath.class, "p"));
        paths.add(new ComparablePath(String.class, "p"));
        paths.add(new DatePath(Date.class, "p"));
        paths.add(new DateTimePath(Date.class, "p"));
        paths.add(new EnumPath(ExampleEnum.class, "p"));
        paths.add(new ListPath(String.class, StringPath.class, "p"));
        paths.add(new MapPath(String.class, String.class, StringPath.class, "p"));
        paths.add(new NumberPath(Integer.class, "p"));
        paths.add(new SetPath(String.class, StringPath.class, "p"));
        paths.add(new SimplePath(String.class, "p"));
        paths.add(new StringPath("p"));
        paths.add(new TimePath(Time.class, "p"));
        for (DslExpression dslExpression : paths) {
            Path o = ExpressionUtils.path((Class)dslExpression.getType(), (String)"o");
            Assert.assertEquals((Object)ExpressionUtils.operation((Class)dslExpression.getType(), (Operator)Ops.ALIAS, (Expression[])new Expression[]{dslExpression, o}), (Object)dslExpression.as("o"));
            Path p = ExpressionUtils.path((Class)dslExpression.getType(), (String)"p");
            Assert.assertEquals((Object)ExpressionUtils.operation((Class)dslExpression.getType(), (Operator)Ops.ALIAS, (Expression[])new Expression[]{dslExpression, p}), (Object)dslExpression.as(p));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void eq_null() {
        new SimplePath(Object.class, "path").eq(null);
    }

    static enum ExampleEnum {
        A,
        B;

    }
}

