/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.Entity;
import com.querydsl.core.FilterFactory;
import com.querydsl.core.MatchingFiltersFactory;
import com.querydsl.core.Module;
import com.querydsl.core.ProjectionsFactory;
import com.querydsl.core.Target;
import com.querydsl.core.alias.Alias;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.DateExpression;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.TimeExpression;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class CoverageTest {
    private MatchingFiltersFactory matchers = new MatchingFiltersFactory(Module.COLLECTIONS, Target.MEM);
    private ProjectionsFactory projections = new ProjectionsFactory(Module.COLLECTIONS, Target.MEM);
    private FilterFactory filters = new FilterFactory(this.projections, Module.COLLECTIONS, Target.MEM);

    @Test
    public void test() throws IllegalArgumentException, IllegalAccessException {
        HashSet<Operator> usedOperators = new HashSet<Operator>();
        ArrayList<Object> exprs = new ArrayList<Object>();
        Entity entity = (Entity)Alias.alias(Entity.class, (String)"entity");
        exprs.addAll(this.projections.numeric(Alias.$((Integer)entity.getNum()), Alias.$((Integer)entity.getNum()), 1, false));
        exprs.addAll(this.matchers.numeric(Alias.$((Integer)entity.getNum()), Alias.$((Integer)entity.getNum()), 1));
        exprs.addAll(this.filters.numeric(Alias.$((Integer)entity.getNum()), Alias.$((Integer)entity.getNum()), 1));
        exprs.addAll(this.projections.numericCasts(Alias.$((Integer)entity.getNum()), Alias.$((Integer)entity.getNum()), 1));
        exprs.addAll(this.projections.string((StringExpression)Alias.$((String)entity.getStr()), (StringExpression)Alias.$((String)entity.getStr()), "abc"));
        exprs.addAll(this.matchers.string((StringExpression)Alias.$((String)entity.getStr()), (StringExpression)Alias.$((String)entity.getStr()), "abc"));
        exprs.addAll(this.filters.string((StringExpression)Alias.$((String)entity.getStr()), (StringExpression)Alias.$((String)entity.getStr()), "abc"));
        exprs.addAll(this.projections.date(Alias.$((Date)entity.getDate()), Alias.$((Date)entity.getDate()), new Date(0L)));
        exprs.addAll(this.matchers.date((DateExpression<Date>)Alias.$((Date)entity.getDate()), (DateExpression<Date>)Alias.$((Date)entity.getDate()), new Date(0L)));
        exprs.addAll(this.filters.date(Alias.$((Date)entity.getDate()), Alias.$((Date)entity.getDate()), new Date(0L)));
        exprs.addAll(this.projections.dateTime(Alias.$((java.util.Date)entity.getDateTime()), Alias.$((java.util.Date)entity.getDateTime()), new java.util.Date(0L)));
        exprs.addAll(this.matchers.dateTime((DateTimeExpression<java.util.Date>)Alias.$((java.util.Date)entity.getDateTime()), (DateTimeExpression<java.util.Date>)Alias.$((java.util.Date)entity.getDateTime()), new java.util.Date(0L)));
        exprs.addAll(this.filters.dateTime(Alias.$((java.util.Date)entity.getDateTime()), Alias.$((java.util.Date)entity.getDateTime()), new java.util.Date(0L)));
        exprs.addAll(this.projections.time(Alias.$((Time)entity.getTime()), Alias.$((Time)entity.getTime()), new Time(0L)));
        exprs.addAll(this.matchers.time((TimeExpression<Time>)Alias.$((Time)entity.getTime()), (TimeExpression<Time>)Alias.$((Time)entity.getTime()), new Time(0L)));
        exprs.addAll(this.filters.time(Alias.$((Time)entity.getTime()), Alias.$((Time)entity.getTime()), new Time(0L)));
        exprs.addAll(this.filters.booleanFilters((BooleanExpression)Alias.$((Boolean)entity.isBool()), (BooleanExpression)Alias.$((Boolean)entity.isBool())));
        exprs.addAll(this.projections.list(Alias.$(entity.getList()), Alias.$(entity.getList()), ""));
        exprs.addAll(this.filters.list(Alias.$(entity.getList()), Alias.$(entity.getList()), ""));
        exprs.addAll(this.projections.array(Alias.$((Object[])entity.getArray()), Alias.$((Object[])entity.getArray()), ""));
        exprs.addAll(this.filters.array(Alias.$((Object[])entity.getArray()), Alias.$((Object[])entity.getArray()), ""));
        exprs.addAll(this.projections.map(Alias.$(entity.getMap()), Alias.$(entity.getMap()), "", ""));
        exprs.addAll(this.filters.map(Alias.$(entity.getMap()), Alias.$(entity.getMap()), "", ""));
        for (Expression expression : exprs) {
            if (!(expression instanceof Operation)) continue;
            Operation op = (Operation)expression;
            if (op.getArg(0) instanceof Operation) {
                usedOperators.add(((Operation)op.getArg(0)).getOperator());
            } else if (op.getArgs().size() > 1 && op.getArg(1) instanceof Operation) {
                usedOperators.add(((Operation)op.getArg(1)).getOperator());
            }
            usedOperators.add(op.getOperator());
        }
        usedOperators.addAll(Arrays.asList(Ops.INSTANCE_OF, Ops.ALIAS, Ops.ARRAY_SIZE, Ops.MOD, Ops.STRING_CAST, Ops.WRAPPED, Ops.ORDER, Ops.XOR, Ops.XNOR, Ops.CASE_WHEN, Ops.CASE_ELSE, Ops.CASE_EQ_WHEN, Ops.CASE_EQ_ELSE, Ops.LIST, Ops.SET, Ops.SINGLETON, Ops.COALESCE, Ops.ORDINAL, Ops.MATCHES_IC, Ops.AggOps.AVG_AGG, Ops.AggOps.MAX_AGG, Ops.AggOps.MIN_AGG, Ops.AggOps.SUM_AGG, Ops.AggOps.COUNT_AGG, Ops.AggOps.COUNT_ALL_AGG, Ops.EXISTS));
        ArrayList<Operator> notContained = new ArrayList<Operator>();
        for (Field field : Ops.class.getFields()) {
            Operator val;
            if (!Operator.class.isAssignableFrom(field.getType()) || usedOperators.contains(val = (Operator)field.get(null))) continue;
            System.err.println(field.getName() + " was not contained");
            notContained.add(val);
        }
        Assert.assertTrue((String)(notContained.size() + " errors in processing, see log for details"), (boolean)notContained.isEmpty());
    }
}

