/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.google.common.base.StandardSystemProperty;

public enum JavaSpecVersion {
    JAVA6("1.6"),
    JAVA7("1.7"),
    JAVA8("1.8");

    public static final JavaSpecVersion CURRENT;
    private final String versionNumber;

    private JavaSpecVersion(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    private boolean isVersion(String versionNumber) {
        return this.versionNumber.equals(versionNumber);
    }

    private static JavaSpecVersion getByVersionNumber(String versionNumber) {
        for (JavaSpecVersion version : JavaSpecVersion.values()) {
            if (!version.isVersion(versionNumber)) continue;
            return version;
        }
        throw new IllegalArgumentException("versionNumber " + versionNumber + " not found");
    }

    static {
        CURRENT = JavaSpecVersion.getByVersionNumber(StandardSystemProperty.JAVA_SPECIFICATION_VERSION.value());
    }
}

