/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.NumberConstant;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.TimeExpression;
import java.util.Calendar;
import java.util.Date;

public final class TimeConstant<D extends Date>
extends TimeExpression<D>
implements Constant<D> {
    private static final long serialVersionUID = -7835941761930555480L;
    private final Calendar calendar = Calendar.getInstance();
    private final D time;

    public static <D extends Date> TimeExpression<D> create(D time) {
        return new TimeConstant<D>(time);
    }

    public TimeConstant(D time) {
        super((Expression)ConstantImpl.create(time));
        this.time = (Date)((Date)time).clone();
        this.calendar.setTime((Date)time);
    }

    public <R, C> R accept(Visitor<R, C> v, C context) {
        return (R)v.visit((Constant)this, context);
    }

    public NumberExpression<Integer> hour() {
        return NumberConstant.create(this.calendar.get(11));
    }

    public NumberExpression<Integer> minute() {
        return NumberConstant.create(this.calendar.get(12));
    }

    public NumberExpression<Integer> second() {
        return NumberConstant.create(this.calendar.get(13));
    }

    public NumberExpression<Integer> milliSecond() {
        return NumberConstant.create(this.calendar.get(14));
    }

    public D getConstant() {
        return this.time;
    }
}

