/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.group;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.commons.lang.Pair;
import com.querydsl.core.Tuple;
import com.querydsl.core.group.AbstractGroupByTest;
import com.querydsl.core.group.Group;
import com.querydsl.core.group.GroupBy;
import com.querydsl.core.group.GroupExpression;
import com.querydsl.core.group.Post;
import com.querydsl.core.group.User;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Projections;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;

public class GroupByListTest
extends AbstractGroupByTest {
    @Override
    @Test
    public void group_order() {
        List results = (List)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).list(new Expression[]{postName, GroupBy.set((Expression)commentId)}));
        Assert.assertEquals((long)4L, (long)results.size());
    }

    @Override
    @Test
    public void first_set_and_list() {
        List results = (List)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).list(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        Assert.assertEquals((long)4L, (long)results.size());
        Group group = (Group)results.get(1);
        Assert.assertEquals((Object)this.toInt(1), (Object)group.getOne((Expression)postId));
        Assert.assertEquals((Object)"post 1", (Object)group.getOne((Expression)postName));
        Assert.assertEquals(this.toSet(1, 2, 3), (Object)group.getSet((Expression)commentId));
        Assert.assertEquals(Arrays.asList("comment 1", "comment 2", "comment 3"), (Object)group.getList((Expression)commentText));
    }

    @Override
    @Test
    public void group_by_null() {
        List results = (List)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).list(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        Assert.assertEquals((long)4L, (long)results.size());
        Group group = (Group)results.get(0);
        Assert.assertNull((Object)group.getOne((Expression)postId));
        Assert.assertEquals((Object)"null post", (Object)group.getOne((Expression)postName));
        Assert.assertEquals(this.toSet(7, 8), (Object)group.getSet((Expression)commentId));
        Assert.assertEquals(Arrays.asList("comment 7", "comment 8"), (Object)group.getList((Expression)commentText));
    }

    @Override
    @Test(expected=NoSuchElementException.class)
    public void noSuchElementException() {
        List results = (List)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).list(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        Assert.assertEquals((long)4L, (long)results.size());
        Group group = (Group)results.get(1);
        group.getSet((Expression)qComment);
    }

    @Override
    @Test(expected=ClassCastException.class)
    public void classCastException() {
        List results = (List)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).list(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        Assert.assertEquals((long)4L, (long)results.size());
        Group group = (Group)results.get(1);
        group.getList((Expression)commentId);
    }

    @Override
    @Test
    public void map1() {
        List results = (List)MAP_RESULTS.transform(GroupBy.groupBy((Expression)postId).list(new Expression[]{postName, GroupBy.map((Expression)commentId, (Expression)commentText)}));
        Assert.assertEquals((long)4L, (long)results.size());
        Group group = (Group)results.get(1);
        Map comments = group.getMap((Expression)commentId, (Expression)commentText);
        Assert.assertEquals((long)3L, (long)comments.size());
        Assert.assertEquals((Object)"comment 2", comments.get(2));
    }

    @Override
    @Test
    public void map2() {
        List results = (List)MAP2_RESULTS.transform(GroupBy.groupBy((Expression)postId).list((Expression)GroupBy.map((Expression)commentId, (Expression)commentText)));
        Assert.assertEquals((long)4L, (long)results.size());
        Map comments = (Map)results.get(1);
        Assert.assertEquals((long)3L, (long)comments.size());
        Assert.assertEquals((Object)"comment 2", comments.get(2));
    }

    @Override
    @Test
    public void map3() {
        List actual = (List)MAP3_RESULTS.transform(GroupBy.groupBy((Expression)postId).list((Expression)GroupBy.map((Expression)postId, (GroupExpression)GroupBy.map((Expression)commentId, (Expression)commentText))));
        Object postId = null;
        LinkedHashMap posts = null;
        LinkedList expected = new LinkedList();
        CloseableIterator iterator = MAP3_RESULTS.iterate();
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)iterator.next();
            Object[] array = tuple.toArray();
            if (posts == null || postId != array[0] && (postId == null || !postId.equals(array[0]))) {
                posts = new LinkedHashMap();
                expected.add(posts);
            }
            postId = array[0];
            Pair pair = (Pair)array[1];
            Integer first = (Integer)pair.getFirst();
            LinkedHashMap<Object, Object> comments = (LinkedHashMap<Object, Object>)posts.get(first);
            if (comments == null) {
                comments = new LinkedHashMap<Object, Object>();
                posts.put(first, comments);
            }
            Pair second = (Pair)pair.getSecond();
            comments.put(second.getFirst(), second.getSecond());
        }
        Assert.assertEquals((Object)((Object)expected).toString(), (Object)actual.toString());
    }

    @Override
    @Test
    public void map4() {
        CloseableIterator results = (CloseableIterator)MAP4_RESULTS.transform(GroupBy.groupBy((Expression)postId).iterate((Expression)GroupBy.map((GroupExpression)GroupBy.map((Expression)postId, (Expression)commentText), (Expression)postName)));
        List actual = IteratorAdapter.asList((Iterator)results);
        Object commentId = null;
        LinkedHashMap<Map<Object, Object>, Object> comments = null;
        LinkedList expected = new LinkedList();
        CloseableIterator iterator = MAP4_RESULTS.iterate();
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)iterator.next();
            Object[] array = tuple.toArray();
            if (comments == null || commentId != array[0] && (commentId == null || !commentId.equals(array[0]))) {
                comments = new LinkedHashMap<Map<Object, Object>, Object>();
                expected.add(comments);
            }
            commentId = array[0];
            Pair pair = (Pair)array[1];
            Pair first = (Pair)pair.getFirst();
            Map<Object, Object> posts = Collections.singletonMap(first.getFirst(), first.getSecond());
            comments.put(posts, pair.getSecond());
        }
        Assert.assertEquals((Object)((Object)expected).toString(), (Object)actual.toString());
    }

    @Override
    @Test
    public void array_access() {
        List results = (List)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).list(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        Assert.assertEquals((long)4L, (long)results.size());
        Group group = (Group)results.get(1);
        Object[] array = group.toArray();
        Assert.assertEquals((Object)this.toInt(1), (Object)array[0]);
        Assert.assertEquals((Object)"post 1", (Object)array[1]);
        Assert.assertEquals(this.toSet(1, 2, 3), (Object)array[2]);
        Assert.assertEquals(Arrays.asList("comment 1", "comment 2", "comment 3"), (Object)array[3]);
    }

    @Override
    @Test
    public void transform_results() {
        List results = (List)POST_W_COMMENTS.transform(GroupBy.groupBy((Expression)postId).list((FactoryExpression)Projections.constructor(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment)})));
        Assert.assertEquals((long)4L, (long)results.size());
        Post post = (Post)results.get(1);
        Assert.assertNotNull((Object)post);
        Assert.assertEquals((Object)this.toInt(1), (Object)post.getId());
        Assert.assertEquals((Object)"post 1", (Object)post.getName());
        Assert.assertEquals(this.toSet(GroupByListTest.comment(1), GroupByListTest.comment(2), GroupByListTest.comment(3)), post.getComments());
    }

    @Override
    @Test
    public void transform_as_bean() {
        List results = (List)POST_W_COMMENTS.transform(GroupBy.groupBy((Expression)postId).list((FactoryExpression)Projections.bean(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment).as("comments")})));
        Assert.assertEquals((long)4L, (long)results.size());
        Post post = (Post)results.get(1);
        Assert.assertNotNull((Object)post);
        Assert.assertEquals((Object)this.toInt(1), (Object)post.getId());
        Assert.assertEquals((Object)"post 1", (Object)post.getName());
        Assert.assertEquals(this.toSet(GroupByListTest.comment(1), GroupByListTest.comment(2), GroupByListTest.comment(3)), post.getComments());
    }

    @Override
    @Test
    public void oneToOneToMany_projection() {
        List results = (List)USERS_W_LATEST_POST_AND_COMMENTS.transform(GroupBy.groupBy((Expression)userName).list((FactoryExpression)Projections.constructor(User.class, (Expression[])new Expression[]{userName, Projections.constructor(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment)})})));
        Assert.assertEquals((long)2L, (long)results.size());
        User user = (User)results.get(0);
        Post post = user.getLatestPost();
        Assert.assertEquals((Object)this.toInt(2), (Object)post.getId());
        Assert.assertEquals((Object)"post 2", (Object)post.getName());
        Assert.assertEquals(this.toSet(GroupByListTest.comment(4), GroupByListTest.comment(5)), post.getComments());
    }

    @Override
    @Test
    public void oneToOneToMany_projection_as_bean() {
        List results = (List)USERS_W_LATEST_POST_AND_COMMENTS.transform(GroupBy.groupBy((Expression)userName).list((FactoryExpression)Projections.bean(User.class, (Expression[])new Expression[]{userName, Projections.bean(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment).as("comments")}).as("latestPost")})));
        Assert.assertEquals((long)2L, (long)results.size());
        User user = (User)results.get(0);
        Post post = user.getLatestPost();
        Assert.assertEquals((Object)this.toInt(2), (Object)post.getId());
        Assert.assertEquals((Object)"post 2", (Object)post.getName());
        Assert.assertEquals(this.toSet(GroupByListTest.comment(4), GroupByListTest.comment(5)), post.getComments());
    }

    @Override
    @Test
    public void oneToOneToMany_projection_as_bean_and_constructor() {
        List results = (List)USERS_W_LATEST_POST_AND_COMMENTS.transform(GroupBy.groupBy((Expression)userName).list((FactoryExpression)Projections.bean(User.class, (Expression[])new Expression[]{userName, Projections.constructor(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment)}).as("latestPost")})));
        Assert.assertEquals((long)2L, (long)results.size());
        User user = (User)results.get(0);
        Post post = user.getLatestPost();
        Assert.assertEquals((Object)this.toInt(2), (Object)post.getId());
        Assert.assertEquals((Object)"post 2", (Object)post.getName());
        Assert.assertEquals(this.toSet(GroupByListTest.comment(4), GroupByListTest.comment(5)), post.getComments());
    }
}

