/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.group.GroupBy;
import com.querydsl.core.group.GroupExpression;
import com.querydsl.core.testutil.Serialization;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathMetadataFactory;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BeanPath;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilderValidator;
import com.querydsl.core.types.dsl.PathInits;
import com.querydsl.core.types.dsl.SimplePath;
import io.github.classgraph.ClassGraph;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Test;

public class SerializationTest {
    @Test
    public void expressions() throws Exception {
        HashMap<Class<String>, Object> args = new HashMap<Class<String>, Object>();
        args.put(Object.class, "obj");
        args.put(BeanPath.class, new EntityPathBase(Object.class, "obj"));
        args.put(Class.class, Integer.class);
        args.put(Class[].class, new Class[]{Object.class, Object.class});
        args.put(java.util.Date.class, new java.util.Date(0L));
        args.put(Date.class, new Date(0L));
        args.put(Time.class, new Time(0L));
        args.put(Timestamp.class, new Timestamp(0L));
        args.put(Expression.class, Expressions.enumPath(Gender.class, (String)"e"));
        args.put(Expression[].class, new Expression[]{Expressions.enumPath(Gender.class, (String)"e"), Expressions.stringPath((String)"s")});
        args.put(FactoryExpression.class, Projections.tuple((Expression[])new Expression[]{Expressions.stringPath((String)"str")}));
        args.put(GroupExpression.class, GroupBy.avg((Expression)Expressions.numberPath(Integer.class, (String)"num")));
        args.put(Number.class, 1);
        args.put(Operator.class, Ops.AND);
        args.put(Path.class, Expressions.stringPath((String)"str"));
        args.put(PathBuilderValidator.class, PathBuilderValidator.DEFAULT);
        args.put(PathMetadata.class, PathMetadataFactory.forVariable((String)"obj"));
        args.put(PathInits.class, PathInits.DEFAULT);
        args.put(Predicate.class, Expressions.path(Object.class, (String)"obj").isNull());
        args.put(QueryMetadata.class, new DefaultQueryMetadata());
        args.put(String.class, "obj");
        ClassGraph reflections = new ClassGraph().enableClassInfo();
        List types = reflections.scan().getSubclasses(Expression.class.getName()).loadClasses();
        for (Class type : types) {
            if (type.isInterface() || type.isMemberClass() || Modifier.isAbstract(type.getModifiers())) continue;
            for (Constructor<?> c : type.getConstructors()) {
                Object[] parameters = new Object[c.getParameterTypes().length];
                for (int i = 0; i < c.getParameterTypes().length; ++i) {
                    parameters[i] = Objects.requireNonNull(args.get(c.getParameterTypes()[i]), c.getParameterTypes()[i].getName());
                }
                c.setAccessible(true);
                Object o = c.newInstance(parameters);
                Assert.assertEquals(o, Serialization.serialize(o));
            }
        }
    }

    @Test
    public void order() {
        OrderSpecifier order = new OrderSpecifier(Order.ASC, (Expression)Expressions.stringPath((String)"str"));
        Assert.assertEquals((Object)order, (Object)Serialization.serialize(order));
    }

    @Test
    public void roundtrip() throws Exception {
        Path path = ExpressionUtils.path(Object.class, (String)"entity");
        SimplePath path2 = Expressions.path(Object.class, (String)"entity");
        Assert.assertEquals((Object)path, (Object)Serialization.serialize(path));
        Assert.assertEquals((Object)path2, (Object)Serialization.serialize(path2));
        Assert.assertEquals((Object)path2.isNull(), (Object)Serialization.serialize(path2.isNull()));
        Assert.assertEquals((long)path.hashCode(), (long)Serialization.serialize(path).hashCode());
        Assert.assertEquals((long)path2.hashCode(), (long)Serialization.serialize(path2).hashCode());
        Assert.assertEquals((long)path2.isNull().hashCode(), (long)Serialization.serialize(path2.isNull()).hashCode());
    }

    public static enum Gender {
        MALE,
        FEMALE;

    }
}

