/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.annotations.PropertyType;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.JavaTemplates;
import com.querydsl.core.types.Template;
import com.querydsl.core.types.TemplateExpression;
import com.querydsl.core.types.TemplateFactory;
import com.querydsl.core.types.ToStringVisitor;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.BooleanTemplate;
import com.querydsl.core.types.dsl.ComparableTemplate;
import com.querydsl.core.types.dsl.DateTemplate;
import com.querydsl.core.types.dsl.DateTimeTemplate;
import com.querydsl.core.types.dsl.EnumTemplate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberTemplate;
import com.querydsl.core.types.dsl.SimpleTemplate;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.StringTemplate;
import com.querydsl.core.types.dsl.TimeTemplate;
import java.sql.Date;
import java.sql.Time;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TemplateExpressionTest {
    @Test
    public void constructors() {
        JavaTemplates templates = new JavaTemplates();
        Template template = TemplateFactory.DEFAULT.create("{0}");
        List<StringPath> args = Collections.singletonList(new StringPath("a"));
        List<TemplateExpression> customs = Arrays.asList(new BooleanTemplate(template, args), new ComparableTemplate(String.class, template, args), new DateTemplate(Date.class, template, args), new DateTimeTemplate(java.util.Date.class, template, args), new EnumTemplate(PropertyType.class, template, args), new NumberTemplate(Integer.class, template, args), new SimpleTemplate(Object.class, template, args), new StringTemplate(template, args), new TimeTemplate(Time.class, template, args));
        TemplateExpression prev = null;
        for (TemplateExpression custom : customs) {
            Assert.assertNotNull((Object)custom);
            Assert.assertNotNull((Object)custom.getTemplate());
            Assert.assertNotNull((Object)custom.getType());
            Assert.assertNotNull((Object)custom.getArgs());
            Assert.assertEquals((Object)custom, (Object)custom);
            if (prev != null) {
                Assert.assertFalse((boolean)custom.equals(prev));
            }
            custom.accept((Visitor)ToStringVisitor.DEFAULT, (Object)templates);
            prev = custom;
        }
    }

    @Test
    public void factoryMethods() {
        String template = "";
        Constant arg = ConstantImpl.create((boolean)true);
        Expressions.booleanTemplate((String)template, (Object[])new Object[]{arg});
        Expressions.comparableTemplate(String.class, (String)template, (Object[])new Object[]{arg});
        Expressions.dateTemplate(java.util.Date.class, (String)template, (Object[])new Object[]{arg});
        Expressions.dateTimeTemplate(java.util.Date.class, (String)template, (Object[])new Object[]{arg});
        Expressions.enumTemplate(PropertyType.class, (String)template, (Object[])new Object[]{arg});
        Expressions.numberTemplate(Integer.class, (String)template, (Object[])new Object[]{arg});
        Expressions.template(Object.class, (String)template, (Object[])new Object[]{arg});
        Expressions.stringTemplate((String)template, (Object[])new Object[]{arg});
        Expressions.timeTemplate(Time.class, (String)template, (Object[])new Object[]{arg});
    }

    @Test
    public void factoryMethods2() {
        Template template = TemplateFactory.DEFAULT.create("");
        Constant arg = ConstantImpl.create((boolean)true);
        Expressions.booleanTemplate((Template)template, (Object[])new Object[]{arg});
        Expressions.comparableTemplate(String.class, (Template)template, (Object[])new Object[]{arg});
        Expressions.dateTemplate(java.util.Date.class, (Template)template, (Object[])new Object[]{arg});
        Expressions.dateTimeTemplate(java.util.Date.class, (Template)template, (Object[])new Object[]{arg});
        Expressions.enumTemplate(PropertyType.class, (Template)template, (Object[])new Object[]{arg});
        Expressions.numberTemplate(Integer.class, (Template)template, (Object[])new Object[]{arg});
        Expressions.template(Object.class, (Template)template, (Object[])new Object[]{arg});
        Expressions.stringTemplate((Template)template, (Object[])new Object[]{arg});
        Expressions.timeTemplate(Time.class, (Template)template, (Object[])new Object[]{arg});
    }
}

