/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.JoinType;
import com.querydsl.core.QueryFlag;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.testutil.Serialization;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BeanPath;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberOperation;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.NumberTemplate;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.util.ReflectionUtils;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.junit.Assert;
import org.junit.Test;

public class QueryMetadaSerializationTest {
    private QueryMetadata metadata = new DefaultQueryMetadata();

    @Test
    public void serialization() throws IOException, ClassNotFoundException {
        StringPath expr = Expressions.stringPath((String)"str");
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)expr);
        this.metadata.addFlag(new QueryFlag(QueryFlag.Position.AFTER_FILTERS, ""));
        this.metadata.addGroupBy((Expression)expr);
        this.metadata.addHaving((Predicate)expr.isEmpty());
        this.metadata.addJoinCondition((Predicate)expr.isEmpty());
        this.metadata.addOrderBy(expr.asc());
        this.metadata.setProjection((Expression)expr);
        this.metadata.addWhere((Predicate)expr.isEmpty());
        QueryMetadata metadata2 = Serialization.serialize(this.metadata);
        Assert.assertEquals((Object)this.metadata.getFlags(), (Object)metadata2.getFlags());
        Assert.assertEquals(this.metadata.getGroupBy().get(0), metadata2.getGroupBy().get(0));
        Assert.assertEquals((Object)this.metadata.getGroupBy(), (Object)metadata2.getGroupBy());
        Assert.assertEquals((Object)this.metadata.getHaving(), (Object)metadata2.getHaving());
        Assert.assertEquals((Object)this.metadata.getJoins(), (Object)metadata2.getJoins());
        Assert.assertEquals((Object)this.metadata.getModifiers(), (Object)metadata2.getModifiers());
        Assert.assertEquals((Object)this.metadata.getOrderBy(), (Object)metadata2.getOrderBy());
        Assert.assertEquals((Object)this.metadata.getParams(), (Object)metadata2.getParams());
        Assert.assertEquals((Object)this.metadata.getProjection(), (Object)metadata2.getProjection());
        Assert.assertEquals((Object)this.metadata.getWhere(), (Object)metadata2.getWhere());
    }

    @Test
    public void fullySerializable() {
        HashSet<Class> checked = new HashSet<Class>(Arrays.asList(Collection.class, List.class, Set.class, Map.class, Object.class, String.class, Class.class));
        Stack<Class<Object>> classes = new Stack<Class<Object>>();
        classes.addAll(Arrays.asList(NumberPath.class, NumberOperation.class, NumberTemplate.class, BeanPath.class, DefaultQueryMetadata.class));
        while (!classes.isEmpty()) {
            Class clazz = (Class)classes.pop();
            checked.add(clazz);
            if (!Serializable.class.isAssignableFrom(clazz) && !clazz.isPrimitive()) {
                Assert.fail((String)(clazz.getName() + " is not serializable"));
            }
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isTransient(field.getModifiers())) continue;
                HashSet<Class> types = new HashSet<Class>(3);
                types.add(field.getType());
                if (field.getType().getSuperclass() != null) {
                    types.add(field.getType().getSuperclass());
                }
                if (field.getType().getComponentType() != null) {
                    types.add(field.getType().getComponentType());
                }
                if (Collection.class.isAssignableFrom(field.getType())) {
                    types.add(ReflectionUtils.getTypeParameterAsClass((Type)field.getGenericType(), (int)0));
                } else if (Map.class.isAssignableFrom(field.getType())) {
                    types.add(ReflectionUtils.getTypeParameterAsClass((Type)field.getGenericType(), (int)0));
                    types.add(ReflectionUtils.getTypeParameterAsClass((Type)field.getGenericType(), (int)1));
                }
                types.removeAll(checked);
                classes.addAll(types);
            }
        }
    }
}

