/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Template;
import com.querydsl.core.types.Templates;
import org.junit.Assert;

public final class TemplatesTestUtils {
    public static void testPrecedence(Templates templates) {
        int likePrecedence = templates.getPrecedence((Operator)Ops.LIKE);
        int eqPrecedence = templates.getPrecedence((Operator)Ops.EQ);
        if (templates.getPrecedence((Operator)Ops.EQ_IGNORE_CASE) != eqPrecedence) {
            Assert.fail((String)("Unexpected precedence for EQ_IGNORE_CASE " + templates.getPrecedence((Operator)Ops.EQ_IGNORE_CASE)));
        }
        for (Ops op : Ops.values()) {
            Template template = templates.getTemplate((Operator)op);
            String str = template.toString();
            int precedence = templates.getPrecedence((Operator)op);
            if (str.contains(" like ") && precedence != likePrecedence) {
                Assert.fail((String)("Unexpected precedence for " + (Operator)op + " with template " + template));
                continue;
            }
            if (!str.contains("(") && !str.contains(".") && precedence < 0) {
                Assert.fail((String)("Unexpected precedence for " + (Operator)op + " with template " + template));
                continue;
            }
            if (str.matches(".*[<>] ?\\-?\\d")) {
                if (precedence == 50) continue;
                Assert.fail((String)("Unsafe pattern for " + (Operator)op + " with template " + template));
                continue;
            }
            if (!str.matches(".*[\\+\\-] ?\\-?\\d") || precedence == 40 || precedence == 30) continue;
            Assert.fail((String)("Unsafe pattern for " + (Operator)op + " with template " + template));
        }
    }

    private TemplatesTestUtils() {
    }
}

