/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Template;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.util.BeanUtils;
import java.lang.reflect.Method;
import java.sql.Time;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExpressionsTest {
    private static final StringPath str = new StringPath("str");
    private static final BooleanExpression a = new BooleanPath("a");
    private static final BooleanExpression b = new BooleanPath("b");
    private TimeZone timeZone = null;

    @Before
    public void setUp() {
        this.timeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    @After
    public void tearDown() {
        TimeZone.setDefault(this.timeZone);
    }

    @Test
    public void Signature() throws NoSuchMethodException {
        List<String> types = Arrays.asList("boolean", "comparable", "date", "dsl", "dateTime", "enum", "number", "simple", "string", "time");
        for (String type : types) {
            if (type.equals("boolean") || type.equals("string")) {
                this.assertReturnType(Expressions.class.getMethod(type + "Path", String.class));
                this.assertReturnType(Expressions.class.getMethod(type + "Path", Path.class, String.class));
                this.assertReturnType(Expressions.class.getMethod(type + "Path", PathMetadata.class));
                this.assertReturnType(Expressions.class.getMethod(type + "Operation", Operator.class, Expression[].class));
                this.assertReturnType(Expressions.class.getMethod(type + "Template", String.class, Object[].class));
                this.assertReturnType(Expressions.class.getMethod(type + "Template", String.class, List.class));
                this.assertReturnType(Expressions.class.getMethod(type + "Template", Template.class, Object[].class));
                this.assertReturnType(Expressions.class.getMethod(type + "Template", Template.class, List.class));
                continue;
            }
            this.assertReturnType(Expressions.class.getMethod(type + "Path", Class.class, String.class));
            this.assertReturnType(Expressions.class.getMethod(type + "Path", Class.class, Path.class, String.class));
            this.assertReturnType(Expressions.class.getMethod(type + "Path", Class.class, PathMetadata.class));
            this.assertReturnType(Expressions.class.getMethod(type + "Operation", Class.class, Operator.class, Expression[].class));
            this.assertReturnType(Expressions.class.getMethod(type + "Template", Class.class, String.class, Object[].class));
            this.assertReturnType(Expressions.class.getMethod(type + "Template", Class.class, String.class, List.class));
            this.assertReturnType(Expressions.class.getMethod(type + "Template", Class.class, Template.class, Object[].class));
            this.assertReturnType(Expressions.class.getMethod(type + "Template", Class.class, Template.class, List.class));
        }
        this.assertReturnType(Expressions.class.getMethod("arrayPath", Class.class, String.class));
        this.assertReturnType(Expressions.class.getMethod("arrayPath", Class.class, Path.class, String.class));
        this.assertReturnType(Expressions.class.getMethod("arrayPath", Class.class, PathMetadata.class));
    }

    private void assertReturnType(Method method) {
        Assert.assertEquals((Object)BeanUtils.capitalize((String)method.getName()), (Object)method.getReturnType().getSimpleName());
    }

    @Test
    public void as() {
        Assert.assertEquals((Object)"null as str", (Object)Expressions.as(null, (Path)str).toString());
        Assert.assertEquals((Object)"s as str", (Object)Expressions.as((Expression)new StringPath("s"), (Path)str).toString());
    }

    @Test
    public void allOf() {
        Assert.assertEquals((Object)"a && b", (Object)Expressions.allOf((BooleanExpression[])new BooleanExpression[]{a, b}).toString());
    }

    @Test
    public void allOf_with_nulls() {
        Assert.assertEquals((Object)"a && b", (Object)Expressions.allOf((BooleanExpression[])new BooleanExpression[]{a, b, null}).toString());
        Assert.assertEquals((Object)"a", (Object)Expressions.allOf((BooleanExpression[])new BooleanExpression[]{a, null}).toString());
        Assert.assertEquals((Object)"a", (Object)Expressions.allOf((BooleanExpression[])new BooleanExpression[]{null, a}).toString());
    }

    @Test
    public void anyOf() {
        Assert.assertEquals((Object)"a || b", (Object)Expressions.anyOf((BooleanExpression[])new BooleanExpression[]{a, b}).toString());
    }

    @Test
    public void anyOf_with_nulls() {
        Assert.assertEquals((Object)"a || b", (Object)Expressions.anyOf((BooleanExpression[])new BooleanExpression[]{a, b, null}).toString());
        Assert.assertEquals((Object)"a", (Object)Expressions.anyOf((BooleanExpression[])new BooleanExpression[]{a, null}).toString());
        Assert.assertEquals((Object)"a", (Object)Expressions.anyOf((BooleanExpression[])new BooleanExpression[]{null, a}).toString());
    }

    @Test
    public void constant() {
        Assert.assertEquals((Object)"X", (Object)Expressions.constant((Object)"X").toString());
    }

    @Test
    public void constant_as() {
        Assert.assertEquals((Object)"str as str", (Object)Expressions.constantAs((Object)"str", (Path)str).toString());
    }

    @Test
    public void template() {
        Assert.assertEquals((Object)"a && b", (Object)Expressions.template(Object.class, (String)"{0} && {1}", (Object[])new Object[]{a, b}).toString());
    }

    @Test
    public void comparableTemplate() {
        Assert.assertEquals((Object)"a && b", (Object)Expressions.comparableTemplate(Boolean.class, (String)"{0} && {1}", (Object[])new Object[]{a, b}).toString());
    }

    @Test
    public void numberTemplate() {
        Assert.assertEquals((Object)"1", (Object)Expressions.numberTemplate(Integer.class, (String)"1", (Object[])new Object[0]).toString());
    }

    @Test
    public void stringTemplate() {
        Assert.assertEquals((Object)"X", (Object)Expressions.stringTemplate((String)"X", (Object[])new Object[0]).toString());
    }

    @Test
    public void booleanTemplate() {
        Assert.assertEquals((Object)"a && b", (Object)Expressions.booleanTemplate((String)"{0} && {1}", (Object[])new Object[]{a, b}).toString());
    }

    @Test
    public void subQuery() {
    }

    @Test
    public void operation() {
        Assert.assertEquals((Object)"a && b", (Object)Expressions.operation(Boolean.class, (Operator)Ops.AND, (Expression[])new Expression[]{a, b}).toString());
    }

    @Test
    public void predicate() {
        Assert.assertEquals((Object)"a && b", (Object)Expressions.predicate((Operator)Ops.AND, (Expression[])new Expression[]{a, b}).toString());
    }

    @Test
    public void pathClassOfTString() {
        Assert.assertEquals((Object)"variable", (Object)Expressions.path(String.class, (String)"variable").toString());
    }

    @Test
    public void pathClassOfTPathOfQString() {
        Assert.assertEquals((Object)"variable.property", (Object)Expressions.path(String.class, (Path)Expressions.path(Object.class, (String)"variable"), (String)"property").toString());
    }

    @Test
    public void comparablePathClassOfTString() {
        Assert.assertEquals((Object)"variable", (Object)Expressions.comparablePath(String.class, (String)"variable").toString());
    }

    @Test
    public void comparablePathClassOfTPathOfQString() {
        Assert.assertEquals((Object)"variable.property", (Object)Expressions.comparablePath(String.class, (Path)Expressions.path(Object.class, (String)"variable"), (String)"property").toString());
    }

    @Test
    public void datePathClassOfTString() {
        Assert.assertEquals((Object)"variable", (Object)Expressions.datePath(Date.class, (String)"variable").toString());
    }

    @Test
    public void datePathClassOfTPathOfQString() {
        Assert.assertEquals((Object)"variable.property", (Object)Expressions.datePath(Date.class, (Path)Expressions.path(Object.class, (String)"variable"), (String)"property").toString());
    }

    @Test
    public void dateTimePathClassOfTString() {
        Assert.assertEquals((Object)"variable", (Object)Expressions.dateTimePath(Date.class, (String)"variable").toString());
    }

    @Test
    public void dateTimePathClassOfTPathOfQString() {
        Assert.assertEquals((Object)"variable.property", (Object)Expressions.dateTimePath(Date.class, (Path)Expressions.path(Object.class, (String)"variable"), (String)"property").toString());
    }

    @Test
    public void timePathClassOfTString() {
        Assert.assertEquals((Object)"variable", (Object)Expressions.timePath(Date.class, (String)"variable").toString());
    }

    @Test
    public void timePathClassOfTPathOfQString() {
        Assert.assertEquals((Object)"variable.property", (Object)Expressions.timePath(Date.class, (Path)Expressions.path(Object.class, (String)"variable"), (String)"property").toString());
    }

    @Test
    public void numberPathClassOfTString() {
        Assert.assertEquals((Object)"variable", (Object)Expressions.numberPath(Integer.class, (String)"variable").toString());
    }

    @Test
    public void numberPathClassOfTPathOfQString() {
        Assert.assertEquals((Object)"variable.property", (Object)Expressions.numberPath(Integer.class, (Path)Expressions.path(Object.class, (String)"variable"), (String)"property").toString());
    }

    @Test
    public void stringPathString() {
        Assert.assertEquals((Object)"variable", (Object)Expressions.stringPath((String)"variable").toString());
    }

    @Test
    public void stringPathPathOfQString() {
        Assert.assertEquals((Object)"variable.property", (Object)Expressions.stringPath((Path)Expressions.path(Object.class, (String)"variable"), (String)"property").toString());
    }

    @Test
    public void stringOperation() {
        Assert.assertEquals((Object)"substring(str,2)", (Object)Expressions.stringOperation((Operator)Ops.SUBSTR_1ARG, (Expression[])new Expression[]{str, ConstantImpl.create((int)2)}).toString());
    }

    @Test
    public void booleanPathString() {
        Assert.assertEquals((Object)"variable", (Object)Expressions.booleanPath((String)"variable").toString());
    }

    @Test
    public void booleanPathPathOfQString() {
        Assert.assertEquals((Object)"variable.property", (Object)Expressions.booleanPath((Path)Expressions.path(Object.class, (String)"variable"), (String)"property").toString());
    }

    @Test
    public void booleanOperation() {
        Assert.assertEquals((Object)"a && b", (Object)Expressions.booleanOperation((Operator)Ops.AND, (Expression[])new Expression[]{a, b}).toString());
    }

    @Test
    public void comparableOperation() {
        Assert.assertEquals((Object)"a && b", (Object)Expressions.comparableOperation(Boolean.class, (Operator)Ops.AND, (Expression[])new Expression[]{a, b}).toString());
    }

    @Test
    public void dateOperation() {
        Assert.assertEquals((Object)"current_date()", (Object)Expressions.dateOperation(Date.class, (Operator)Ops.DateTimeOps.CURRENT_DATE, (Expression[])new Expression[0]).toString());
    }

    @Test
    public void dateTimeOperation() {
        Assert.assertEquals((Object)"current_timestamp()", (Object)Expressions.dateTimeOperation(Date.class, (Operator)Ops.DateTimeOps.CURRENT_TIMESTAMP, (Expression[])new Expression[0]).toString());
    }

    @Test
    public void timeOperation() {
        Assert.assertEquals((Object)"current_time()", (Object)Expressions.timeOperation(Time.class, (Operator)Ops.DateTimeOps.CURRENT_TIME, (Expression[])new Expression[0]).toString());
    }

    @Test
    public void cases() {
    }

    @Test
    public void asBoolean_returns_a_corresponding_BooleanExpression_for_a_given_Expression() {
        Assert.assertEquals((Object)"true = true", (Object)Expressions.asBoolean((Expression)Expressions.constant((Object)true)).isTrue().toString());
    }

    @Test
    public void asBoolean_returns_a_corresponding_BooleanExpression_for_a_given_Constant() {
        Assert.assertEquals((Object)"true = true", (Object)Expressions.asBoolean((boolean)true).isTrue().toString());
    }

    @Test
    public void asBoolean_equals_works_for_returned_values() {
        Assert.assertEquals((Object)Expressions.asBoolean((boolean)true), (Object)Expressions.asBoolean((boolean)true));
        Assert.assertNotEquals((Object)Expressions.asBoolean((boolean)true), (Object)Expressions.asBoolean((boolean)false));
    }

    @Test
    public void asComparable_returns_a_corresponding_ComparableExpression_for_a_given_Expression() {
        Assert.assertEquals((Object)"1 = 1", (Object)Expressions.asComparable((Expression)Expressions.constant((Object)1L)).eq(Expressions.constant((Object)1L)).toString());
    }

    @Test
    public void asComparable_returns_a_corresponding_ComparableExpression_for_a_given_Constant() {
        Assert.assertEquals((Object)"1 = 1", (Object)Expressions.asComparable((Comparable)Long.valueOf(1L)).eq((Object)1L).toString());
    }

    @Test
    public void asComparable_equals_works_for_returned_values() {
        Assert.assertEquals((Object)Expressions.asComparable((Comparable)Long.valueOf(1L)), (Object)Expressions.asComparable((Comparable)Long.valueOf(1L)));
        Assert.assertNotEquals((Object)Expressions.asComparable((Comparable)Long.valueOf(1L)), (Object)Expressions.asComparable((Comparable)Long.valueOf(2L)));
    }

    @Test
    public void asDate_returns_a_corresponding_DateExpression_for_a_given_Expression() {
        Assert.assertEquals((Object)"year(Thu Jan 01 00:00:00 UTC 1970)", (Object)Expressions.asDate((Expression)Expressions.constant((Object)new Date(1L))).year().toString());
    }

    @Test
    public void asDate_returns_a_corresponding_DateExpression_for_a_given_Constant() {
        Assert.assertEquals((Object)"year(Thu Jan 01 00:00:00 UTC 1970)", (Object)Expressions.asDate((Comparable)new Date(1L)).year().toString());
    }

    @Test
    public void asDate_equals_works_for_returned_values() {
        Assert.assertEquals((Object)Expressions.asDate((Comparable)new Date(1L)).year(), (Object)Expressions.asDate((Comparable)new Date(1L)).year());
        Assert.assertNotEquals((Object)Expressions.asDate((Comparable)new Date(1L)).year(), (Object)Expressions.asDate((Comparable)new Date(2L)).year());
    }

    @Test
    public void asDateTime_returns_a_corresponding_DateTimeExpression_for_a_given_Expression() {
        Assert.assertEquals((Object)"min(Thu Jan 01 00:00:00 UTC 1970)", (Object)Expressions.asDateTime((Expression)Expressions.constant((Object)new Date(1L))).min().toString());
    }

    @Test
    public void asDateTime_returns_a_corresponding_DateTimeExpression_for_a_given_Constant() {
        Assert.assertEquals((Object)"min(Thu Jan 01 00:00:00 UTC 1970)", (Object)Expressions.asDateTime((Comparable)new Date(1L)).min().toString());
    }

    @Test
    public void asDateTime_equals_works_for_returned_values() {
        Assert.assertEquals((Object)Expressions.asDateTime((Comparable)new Date(1L)).min(), (Object)Expressions.asDateTime((Comparable)new Date(1L)).min());
        Assert.assertNotEquals((Object)Expressions.asDateTime((Comparable)new Date(1L)).min(), (Object)Expressions.asDateTime((Comparable)new Date(2L)).min());
    }

    @Test
    public void asTime_returns_a_corresponding_TimeExpression_for_a_given_Expression() {
        Assert.assertEquals((Object)"hour(Thu Jan 01 00:00:00 UTC 1970)", (Object)Expressions.asTime((Expression)Expressions.constant((Object)new Date(1L))).hour().toString());
    }

    @Test
    public void asTime_returns_a_corresponding_TimeExpression_for_a_given_Constant() {
        Assert.assertEquals((Object)"hour(Thu Jan 01 00:00:00 UTC 1970)", (Object)Expressions.asTime((Comparable)new Date(1L)).hour().toString());
    }

    @Test
    public void asTime_equals_works_for_returned_values() {
        Assert.assertEquals((Object)Expressions.asTime((Comparable)new Date(1L)).hour(), (Object)Expressions.asTime((Comparable)new Date(1L)).hour());
        Assert.assertNotEquals((Object)Expressions.asTime((Comparable)new Date(1L)).hour(), (Object)Expressions.asTime((Comparable)new Date(2L)).hour());
    }

    @Test
    public void asEnum_returns_a_corresponding_EnumExpression_for_a_given_Expression() {
        Assert.assertEquals((Object)"ordinal(TEST)", (Object)Expressions.asEnum((Expression)Expressions.constant((Object)((Object)testEnum.TEST))).ordinal().toString());
    }

    @Test
    public void asEnum_returns_a_corresponding_EnumExpression_for_a_given_Constant() {
        Assert.assertEquals((Object)"ordinal(TEST)", (Object)Expressions.asEnum((Enum)testEnum.TEST).ordinal().toString());
    }

    @Test
    public void asEnum_equals_works_for_returned_values() {
        Assert.assertEquals((Object)Expressions.asEnum((Enum)testEnum.TEST), (Object)Expressions.asEnum((Enum)testEnum.TEST));
        Assert.assertNotEquals((Object)Expressions.asEnum((Enum)testEnum.TEST), (Object)Expressions.asEnum((Enum)testEnum.TEST_2));
    }

    @Test
    public void asNumber_returns_a_corresponding_NumberExpression_for_a_given_Expression() {
        Assert.assertEquals((Object)"1 + 1", (Object)Expressions.asNumber((Expression)Expressions.constant((Object)1L)).add(Expressions.constant((Object)1L)).toString());
    }

    @Test
    public void asNumber_returns_a_corresponding_NumberExpression_for_a_given_Constant() {
        Assert.assertEquals((Object)"1 + 1", (Object)Expressions.asNumber((Number)1L).add(Expressions.constant((Object)1L)).toString());
    }

    @Test
    public void asNumber_equals_works_for_returned_values() {
        Assert.assertEquals((Object)Expressions.asNumber((Number)42L), (Object)Expressions.asNumber((Number)42L));
        Assert.assertNotEquals((Object)Expressions.asNumber((Number)42L), (Object)Expressions.asNumber((Number)256L));
    }

    @Test
    public void asString_returns_a_corresponding_StringExpression_for_a_given_Expression() {
        Assert.assertEquals((Object)"left + right", (Object)Expressions.asString((Expression)Expressions.constant((Object)"left")).append(Expressions.constant((Object)"right")).toString());
    }

    @Test
    public void asString_returns_a_corresponding_StringExpression_for_a_given_Constant() {
        Assert.assertEquals((Object)"left + right", (Object)Expressions.asString((String)"left").append(Expressions.constant((Object)"right")).toString());
    }

    @Test
    public void asString_equals_works_for_returned_values() {
        Assert.assertEquals((Object)Expressions.asString((String)"foo"), (Object)Expressions.asString((String)"foo"));
        Assert.assertNotEquals((Object)Expressions.asString((String)"foo"), (Object)Expressions.asString((String)"bar"));
    }

    private static enum testEnum {
        TEST,
        TEST_2;

    }
}

