/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.codegen.ant;

import com.querydsl.jpa.codegen.JPADomainExporter;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.metamodel.Metamodel;

public class AntJPADomainExporter {
    private Configuration configuration;
    private String namePrefix = "Q";
    private String nameSuffix = "";
    private String targetFolder;
    private String persistenceUnitName;
    private Set<File> generatedFiles = Collections.emptySet();

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void addConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }

    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public Set<File> getGeneratedFiles() {
        return this.generatedFiles;
    }

    public void execute() {
        Map<String, String> properties = this.configuration != null ? this.configuration.getProperties() : null;
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.persistenceUnitName, properties);
        Metamodel configuration = emf.getMetamodel();
        JPADomainExporter exporter = new JPADomainExporter(this.namePrefix, this.nameSuffix, new File(this.targetFolder), configuration);
        try {
            exporter.execute();
            this.generatedFiles = exporter.getGeneratedFiles();
        }
        catch (IOException e) {
            throw new RuntimeException("Error in JPADomainExporter", e);
        }
    }

    public static class Configuration {
        private Map<String, String> properties = new HashMap<String, String>();

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void addConfiguredProperty(Property property) {
            this.properties.put(property.getName(), property.getValue());
        }
    }

    public static class Property {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

