/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.google.common.collect.ImmutableMap;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.jpa.DefaultQueryHandler;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.QueryHandler;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class HQLTemplates
extends JPQLTemplates {
    private static final QueryHandler QUERY_HANDLER;
    private static final List<Operator> wrapElements;
    public static final HQLTemplates DEFAULT;
    private final Map<Class<?>, String> typeNames;

    public HQLTemplates() {
        this('!');
    }

    public HQLTemplates(char escape) {
        super(escape, QUERY_HANDLER);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(Byte.class, (Object)"byte");
        builder.put(Short.class, (Object)"short");
        builder.put(Integer.class, (Object)"integer");
        builder.put(Long.class, (Object)"long");
        builder.put(BigInteger.class, (Object)"big_integer");
        builder.put(Float.class, (Object)"float");
        builder.put(Double.class, (Object)"double");
        builder.put(BigDecimal.class, (Object)"big_decimal");
        this.typeNames = builder.build();
        try {
            Class<?> cl = Class.forName("com.querydsl.spatial.hibernate.HibernateSpatialSupport");
            this.add((Map)cl.getMethod("getSpatialOps", new Class[0]).invoke(null, new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean wrapElements(Operator operator) {
        return wrapElements.contains(operator);
    }

    @Override
    public String getTypeForCast(Class<?> cl) {
        return this.typeNames.get(cl);
    }

    @Override
    public String getExistsProjection() {
        return "1";
    }

    @Override
    public boolean isEnumInPathSupported() {
        return false;
    }

    @Override
    public boolean wrapConstant(Object constant) {
        Class<?> type = constant.getClass();
        return type.isArray() || Collection.class.isAssignableFrom(type);
    }

    @Override
    public boolean isWithForOn() {
        return true;
    }

    @Override
    public boolean isCaseWithLiterals() {
        return true;
    }

    static {
        QueryHandler instance;
        try {
            instance = (QueryHandler)Class.forName("com.querydsl.jpa.HibernateHandler").newInstance();
        }
        catch (NoClassDefFoundError e) {
            instance = DefaultQueryHandler.DEFAULT;
        }
        catch (Exception e) {
            instance = DefaultQueryHandler.DEFAULT;
        }
        QUERY_HANDLER = instance;
        wrapElements = Arrays.asList(Ops.QuantOps.ALL, Ops.QuantOps.ANY, Ops.QuantOps.AVG_IN_COL, Ops.EXISTS);
        DEFAULT = new HQLTemplates();
    }
}

