/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.jpa.AbstractQueryTest;
import com.querydsl.jpa.Constants;
import com.querydsl.jpa.domain.QAccount;
import com.querydsl.jpa.domain.QInheritedProperties;
import org.junit.Assert;
import org.junit.Test;

public class FeaturesTest
extends AbstractQueryTest {
    @Test
    public void domainConstruction() {
        QInheritedProperties i = new QInheritedProperties("i");
        Assert.assertNotNull((Object)i.superclassProperty);
        Assert.assertNotNull((Object)i.classProperty);
    }

    @Test
    public void domainConstruction2() {
        QAccount a = new QAccount("a");
        Assert.assertNotNull((Object)a.embeddedData.someData);
    }

    @Test
    public void basicStructure() {
        Assert.assertNull((Object)Constants.cat.getMetadata().getParent());
    }

    @Test
    public void basicStructure2() {
        Assert.assertEquals((Object)((Object)Constants.cat), (Object)Constants.cat.alive.getMetadata().getParent());
    }

    @Test
    public void basicStructure3() {
        Assert.assertEquals((Object)"cat", (Object)Constants.cat.getMetadata().getName());
    }

    @Test
    public void argumentHandling() {
        FeaturesTest.assertToString("cat.name = ?1 or cust.name.firstName = ?2 or kitten.name = ?3", Constants.cat.name.eq((Object)"Kitty").or((Predicate)Constants.cust.name.firstName.eq((Object)"Hans")).or((Predicate)Constants.kitten.name.eq((Object)"Kitty")));
    }

    @Test
    public void basicOperations() {
        FeaturesTest.assertToString("cat.bodyWeight = kitten.bodyWeight", Constants.cat.bodyWeight.eq(Constants.kitten.bodyWeight));
    }

    @Test
    public void basicOperations2() {
        FeaturesTest.assertToString("cat.bodyWeight <> kitten.bodyWeight", Constants.cat.bodyWeight.ne(Constants.kitten.bodyWeight));
    }

    @Test
    public void basicOperations3() {
        FeaturesTest.assertToString("cat.bodyWeight + kitten.bodyWeight = kitten.bodyWeight", Constants.cat.bodyWeight.add(Constants.kitten.bodyWeight).eq(Constants.kitten.bodyWeight));
    }

    @Test
    public void equalsAndNotEqualsForAllExpressions() {
        FeaturesTest.assertToString("cat.name = cust.name.firstName", Constants.cat.name.eq((Expression)Constants.cust.name.firstName));
    }

    @Test
    public void equalsAndNotEqualsForAllExpressions2() {
        FeaturesTest.assertToString("cat.name <> cust.name.firstName", Constants.cat.name.ne((Expression)Constants.cust.name.firstName));
    }

    @Test
    public void groupingOperationsAndNullChecks() {
        Constants.kitten.in((CollectionExpression)Constants.cat.kittens);
        Constants.kitten.in((CollectionExpression)Constants.cat.kittens).not();
        Constants.kitten.bodyWeight.between((Number)10, (Number)20);
        Constants.kitten.bodyWeight.isNull();
        Constants.kitten.bodyWeight.isNotNull();
        Constants.cat.kittens.isEmpty();
        Constants.cat.kittens.isNotEmpty();
    }

    @Test
    public void toString_() {
        FeaturesTest.assertToString("cat", Constants.cat);
        FeaturesTest.assertToString("cat.alive", Constants.cat.alive);
        FeaturesTest.assertToString("cat.bodyWeight", Constants.cat.bodyWeight);
        FeaturesTest.assertToString("cat.name", Constants.cat.name);
        FeaturesTest.assertToString("cust.name", Constants.cust.name);
        FeaturesTest.assertToString("cust.name.firstName = ?1", Constants.cust.name.firstName.eq((Object)"Martin"));
        FeaturesTest.assertToString("cat.bodyWeight + ?1", Constants.cat.bodyWeight.add((Number)10));
        FeaturesTest.assertToString("cat.bodyWeight - ?1", Constants.cat.bodyWeight.subtract((Number)10));
        FeaturesTest.assertToString("cat.bodyWeight * ?1", Constants.cat.bodyWeight.multiply((Number)10));
        FeaturesTest.assertToString("cat.bodyWeight / ?1", Constants.cat.bodyWeight.divide((Number)10));
        FeaturesTest.assertToString("kitten member of cat.kittens", Constants.kitten.in((CollectionExpression)Constants.cat.kittens));
    }

    private <D extends Number> NumberPath<D> var(Class<D> cl) {
        return Expressions.numberPath(cl, (String)"var");
    }
}

