/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.mysema.commons.lang.IteratorAdapter;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.jpa.HibernateHandler;
import com.querydsl.jpa.TransformingIterator;
import com.querydsl.jpa.domain4.Library;
import java.util.Iterator;
import java.util.List;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.easymock.EasyMock;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.ScrollMode;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.transform.ResultTransformer;
import org.junit.Assert;
import org.junit.Test;

public class HibernateHandlerTest {
    private final HibernateHandler hibernateHandler = new HibernateHandler();
    private final NativeQuery nativeQuery = (NativeQuery)EasyMock.createMock(NativeQuery.class);
    private final String alias = "library";
    private final Class<Library> classType = Library.class;

    @Test
    public void should_add_entity() {
        EasyMock.expect((Object)((NativeQuery)this.nativeQuery.unwrap(NativeQuery.class))).andReturn((Object)this.nativeQuery);
        EasyMock.expect((Object)this.nativeQuery.addEntity("library", this.classType)).andReturn((Object)this.nativeQuery);
        EasyMock.replay((Object[])new Object[]{this.nativeQuery});
        this.hibernateHandler.addEntity((Query)this.nativeQuery, "library", this.classType);
        EasyMock.verify((Object[])new Object[]{this.nativeQuery});
    }

    @Test(expected=PersistenceException.class)
    public void addEntity_should_throw_persistence_exception_when_invalid_query_type() {
        Query notSupportedQuery = (Query)EasyMock.createMock(QueryImpl.class);
        PersistenceException expectedThrow = new PersistenceException(ExceptionLocalization.buildMessage((String)"unable_to_unwrap_jpa", (Object[])new String[]{Query.class.getName(), NativeQuery.class.getName()}));
        EasyMock.expect((Object)((NativeQuery)notSupportedQuery.unwrap(NativeQuery.class))).andThrow((Throwable)expectedThrow);
        EasyMock.replay((Object[])new Object[]{notSupportedQuery});
        this.hibernateHandler.addEntity(notSupportedQuery, "library", this.classType);
    }

    @Test
    public void should_add_scalar() {
        EasyMock.expect((Object)((NativeQuery)this.nativeQuery.unwrap(NativeQuery.class))).andReturn((Object)this.nativeQuery);
        EasyMock.expect((Object)this.nativeQuery.addScalar("library")).andReturn((Object)this.nativeQuery);
        EasyMock.replay((Object[])new Object[]{this.nativeQuery});
        this.hibernateHandler.addScalar((Query)this.nativeQuery, "library", this.classType);
        EasyMock.verify((Object[])new Object[]{this.nativeQuery});
    }

    @Test(expected=PersistenceException.class)
    public void addScalar_should_throw_persistence_exception_when_invalid_query_type() {
        Query notSupportedQuery = (Query)EasyMock.createMock(QueryImpl.class);
        PersistenceException expectedThrow = new PersistenceException(ExceptionLocalization.buildMessage((String)"unable_to_unwrap_jpa", (Object[])new String[]{Query.class.getName(), NativeQuery.class.getName()}));
        EasyMock.expect((Object)((NativeQuery)notSupportedQuery.unwrap(NativeQuery.class))).andThrow((Throwable)expectedThrow);
        EasyMock.replay((Object[])new Object[]{notSupportedQuery});
        this.hibernateHandler.addScalar(notSupportedQuery, "library", this.classType);
    }

    @Test
    public void should_get_false_when_check_native_query_type() {
        Assert.assertFalse((boolean)this.hibernateHandler.createNativeQueryTyped());
    }

    @Test
    public void should_get_true_when_check_wrap_entity_projections_for_hibernate_query_syntax_by_using_curly_braces() {
        Assert.assertTrue((boolean)this.hibernateHandler.wrapEntityProjections());
    }

    @Test
    public void should_return_transforming_iterator_when_call_iterate_function() {
        ScrollableResultsImplementor scrollableResultsImplementor = (ScrollableResultsImplementor)EasyMock.createMock(ScrollableResultsImplementor.class);
        FactoryExpression factoryExpression = (FactoryExpression)EasyMock.createMock(FactoryExpression.class);
        EasyMock.expect((Object)((org.hibernate.query.Query)this.nativeQuery.unwrap(org.hibernate.query.Query.class))).andReturn((Object)this.nativeQuery);
        EasyMock.expect((Object)this.nativeQuery.scroll(ScrollMode.FORWARD_ONLY)).andReturn((Object)scrollableResultsImplementor);
        EasyMock.replay((Object[])new Object[]{this.nativeQuery});
        Assert.assertThat((Object)this.hibernateHandler.iterate((Query)this.nativeQuery, factoryExpression), (Matcher)Matchers.instanceOf(TransformingIterator.class));
    }

    @Test
    public void should_return_iterator_adapter_when_call_iterate_function() {
        Query query = (Query)EasyMock.createMock(Query.class);
        List queryResultList = (List)EasyMock.createMock(List.class);
        Iterator iterator = (Iterator)EasyMock.createMock(Iterator.class);
        EasyMock.expect((Object)((org.hibernate.query.Query)query.unwrap(org.hibernate.query.Query.class))).andThrow((Throwable)new PersistenceException("Cannot unwrap Query"));
        EasyMock.expect((Object)query.getResultList()).andReturn((Object)queryResultList);
        EasyMock.expect(queryResultList.iterator()).andReturn((Object)iterator);
        EasyMock.replay((Object[])new Object[]{query});
        Assert.assertEquals(IteratorAdapter.class, this.hibernateHandler.iterate(query, null).getClass());
    }

    @Test
    public void should_ReturnTransformingIterator_when_other_query_implementor() {
        Query query = (Query)EasyMock.createMock(Query.class);
        FactoryExpression factoryExpression = (FactoryExpression)EasyMock.createMock(FactoryExpression.class);
        List queryResultList = (List)EasyMock.createMock(List.class);
        Iterator iterator = (Iterator)EasyMock.createMock(Iterator.class);
        EasyMock.expect((Object)((org.hibernate.query.Query)query.unwrap(org.hibernate.query.Query.class))).andThrow((Throwable)new PersistenceException("Cannot unwrap Query"));
        EasyMock.expect((Object)query.getResultList()).andReturn((Object)queryResultList);
        EasyMock.expect(queryResultList.iterator()).andReturn((Object)iterator);
        EasyMock.replay((Object[])new Object[]{query});
        Assert.assertEquals(TransformingIterator.class, this.hibernateHandler.iterate(query, factoryExpression).getClass());
    }

    @Test
    public void should_transform() {
        FactoryExpression projection = (FactoryExpression)EasyMock.createMock(FactoryExpression.class);
        EasyMock.expect((Object)((org.hibernate.query.Query)this.nativeQuery.unwrap(org.hibernate.query.Query.class))).andReturn((Object)this.nativeQuery);
        EasyMock.expect((Object)this.nativeQuery.setResultTransformer((ResultTransformer)EasyMock.anyObject(ResultTransformer.class))).andReturn((Object)this.nativeQuery);
        EasyMock.replay((Object[])new Object[]{this.nativeQuery});
        Assert.assertTrue((boolean)this.hibernateHandler.transform((Query)this.nativeQuery, projection));
    }
}

