/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.Target;
import com.querydsl.core.testutil.ExcludeIn;
import com.querydsl.core.types.Expression;
import com.querydsl.jpa.AbstractSQLTest;
import com.querydsl.jpa.HibernateTest;
import com.querydsl.jpa.Mode;
import com.querydsl.jpa.TargetRule;
import com.querydsl.jpa.domain.Cat;
import com.querydsl.jpa.domain.Color;
import com.querydsl.jpa.domain.QCat;
import com.querydsl.jpa.domain.sql.SAnimal;
import com.querydsl.jpa.hibernate.sql.HibernateSQLQuery;
import com.querydsl.jpa.testutil.HibernateTestRunner;
import com.querydsl.sql.SQLTemplates;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;

@RunWith(value=HibernateTestRunner.class)
public class HibernateSQLBase
extends AbstractSQLTest
implements HibernateTest {
    @Rule
    @ClassRule
    public static TestRule targetRule = new TargetRule();
    private final SQLTemplates templates = Mode.getSQLTemplates();
    private final SAnimal cat = new SAnimal("cat");
    private Session session;

    protected HibernateSQLQuery<?> query() {
        return new HibernateSQLQuery(this.session, this.templates);
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    @Before
    public void setUp() {
        if (((HibernateSQLQuery)this.query().from((Expression)this.cat)).fetchCount() == 0L) {
            this.session.save((Object)new Cat("Beck", 1, Color.BLACK));
            this.session.save((Object)new Cat("Kate", 2, Color.BLACK));
            this.session.save((Object)new Cat("Kitty", 3, Color.BLACK));
            this.session.save((Object)new Cat("Bobby", 4, Color.BLACK));
            this.session.save((Object)new Cat("Harold", 5, Color.BLACK));
            this.session.save((Object)new Cat("Tim", 6, Color.BLACK));
            this.session.flush();
        }
    }

    @Test
    public void entityQueries_createQuery() {
        SAnimal cat = new SAnimal("cat");
        QCat catEntity = QCat.cat;
        Query query = ((HibernateSQLQuery)this.query().from((Expression)cat)).select((Expression)catEntity).createQuery();
        Assert.assertEquals((long)6L, (long)query.list().size());
    }

    @Test
    @ExcludeIn(value={Target.MYSQL})
    public void entityQueries_createQuery2() {
        SAnimal cat = new SAnimal("CAT");
        QCat catEntity = QCat.cat;
        Query query = ((HibernateSQLQuery)this.query().from((Expression)cat)).select((Expression)catEntity).createQuery();
        Assert.assertEquals((long)6L, (long)query.list().size());
    }
}

