/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.jpa.Constants;
import com.querydsl.jpa.HQLTemplates;
import com.querydsl.jpa.HibernateTest;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLSerializer;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.ParsingTest;
import com.querydsl.jpa.QueryHelper;
import com.querydsl.jpa.domain.Cat;
import com.querydsl.jpa.domain.QCat;
import com.querydsl.jpa.hibernate.HibernateDeleteClause;
import com.querydsl.jpa.hibernate.HibernateInsertClause;
import com.querydsl.jpa.hibernate.HibernateQuery;
import com.querydsl.jpa.hibernate.HibernateUpdateClause;
import com.querydsl.jpa.hibernate.HibernateUtil;
import com.querydsl.jpa.testutil.HibernateTestRunner;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=HibernateTestRunner.class)
public class IntegrationBase
extends ParsingTest
implements HibernateTest {
    private Session session;

    @Override
    protected QueryHelper<?> query() {
        return new QueryHelper<Void>((JPQLTemplates)HQLTemplates.DEFAULT){

            @Override
            public void parse() throws RecognitionException, TokenStreamException {
                try {
                    System.out.println("query : " + this.toString().replace('\n', ' '));
                    JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
                    serializer.serialize(this.getMetadata(), false, null);
                    Query query = IntegrationBase.this.session.createQuery(serializer.toString());
                    HibernateUtil.setConstants((Query)query, (List)serializer.getConstants(), (Map)this.getMetadata().getParams());
                    query.list();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                finally {
                    System.out.println();
                }
            }
        };
    }

    @Override
    @Test
    public void groupBy() throws Exception {
    }

    @Override
    @Test
    public void groupBy_2() throws Exception {
    }

    @Override
    @Test
    public void orderBy() throws Exception {
    }

    @Override
    @Test
    public void docoExamples910() throws Exception {
    }

    private HibernateDeleteClause delete(EntityPath<?> entity) {
        return new HibernateDeleteClause(this.session, entity);
    }

    private HibernateUpdateClause update(EntityPath<?> entity) {
        return new HibernateUpdateClause(this.session, entity);
    }

    private HibernateInsertClause insert(EntityPath<?> entity) {
        return new HibernateInsertClause(this.session, entity);
    }

    @Test
    public void scroll() {
        this.session.save((Object)new Cat("Bob", 10));
        this.session.save((Object)new Cat("Steve", 11));
        QCat cat = QCat.cat;
        HibernateQuery query = new HibernateQuery(this.session);
        ScrollableResults results = ((HibernateQuery)query.from((EntityPath)cat)).select((Expression)cat).scroll(ScrollMode.SCROLL_INSENSITIVE);
        while (results.next()) {
            Assert.assertNotNull((Object)results.get(0));
        }
        results.close();
    }

    @Test
    public void insert() {
        this.session.save((Object)new Cat("Bob", 10));
        QCat cat = QCat.cat;
        long amount = this.insert((EntityPath<?>)cat).set((Path)cat.name, (Object)"Bobby").set((Path)cat.alive, (Object)false).execute();
        Assert.assertEquals((long)1L, (long)amount);
        Assert.assertEquals((long)1L, (long)((QueryHelper)((QueryHelper)this.query().from((EntityPath)cat)).where((Predicate)cat.name.eq((Object)"Bobby"))).fetchCount());
    }

    @Test
    public void insert2() {
        this.session.save((Object)new Cat("Bob", 10));
        QCat cat = QCat.cat;
        long amount = this.insert((EntityPath<?>)cat).columns(new Path[]{cat.name, cat.alive}).values(new Object[]{"Bobby", false}).execute();
        Assert.assertEquals((long)1L, (long)amount);
        Assert.assertEquals((long)1L, (long)((QueryHelper)((QueryHelper)this.query().from((EntityPath)cat)).where((Predicate)cat.name.eq((Object)"Bobby"))).fetchCount());
    }

    @Test
    public void insert3() {
        this.session.save((Object)new Cat("Bob", 10));
        QCat cat = QCat.cat;
        QCat bob = new QCat("Bob");
        long amount = this.insert((EntityPath<?>)cat).columns(new Path[]{cat.name, cat.alive}).select((SubQueryExpression)JPAExpressions.select((Expression[])new Expression[]{bob.name, bob.alive}).from(new EntityPath[]{bob})).execute();
        Assert.assertEquals((long)1L, (long)amount);
        Assert.assertEquals((long)1L, (long)((QueryHelper)((QueryHelper)this.query().from((EntityPath)cat)).where((Predicate)cat.name.eq((Object)"Bobby"))).fetchCount());
    }

    @Test
    public void update() {
        this.session.save((Object)new Cat("Bob", 10));
        this.session.save((Object)new Cat("Steve", 11));
        QCat cat = QCat.cat;
        long amount = this.update((EntityPath<?>)cat).where(new Predicate[]{cat.name.eq((Object)"Bob")}).set((Path)cat.name, (Object)"Bobby").set((Path)cat.alive, (Object)false).execute();
        Assert.assertEquals((long)1L, (long)amount);
        Assert.assertEquals((long)0L, (long)((QueryHelper)((QueryHelper)this.query().from((EntityPath)cat)).where((Predicate)cat.name.eq((Object)"Bob"))).fetchCount());
    }

    @Test
    public void update_with_null() {
        this.session.save((Object)new Cat("Bob", 10));
        this.session.save((Object)new Cat("Steve", 11));
        QCat cat = QCat.cat;
        long amount = this.update((EntityPath<?>)cat).where(new Predicate[]{cat.name.eq((Object)"Bob")}).set((Path)cat.name, (Object)null).set((Path)cat.alive, (Object)false).execute();
        Assert.assertEquals((long)1L, (long)amount);
    }

    @Test
    public void delete() {
        this.session.save((Object)new Cat("Bob", 10));
        this.session.save((Object)new Cat("Steve", 11));
        QCat cat = QCat.cat;
        long amount = this.delete((EntityPath<?>)cat).where(new Predicate[]{cat.name.eq((Object)"Bob")}).execute();
        Assert.assertEquals((long)1L, (long)amount);
    }

    @Test
    public void collection() throws Exception {
        List<Cat> cats = Arrays.asList(new Cat("Bob", 10), new Cat("Steve", 11));
        for (Cat cat : cats) {
            this.session.save((Object)cat);
        }
        ((QueryHelper)((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).innerJoin((CollectionExpression)Constants.cat.kittens, (Path)Constants.kitten)).where((Predicate)Constants.kitten.in(cats))).parse();
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }
}

