/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.jpa.BatooTemplates;
import com.querydsl.jpa.EclipseLinkTemplates;
import com.querydsl.jpa.Hibernate5Templates;
import com.querydsl.jpa.OpenJPATemplates;
import com.querydsl.jpa.impl.JPAProvider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class JPAProviderTest {
    private EntityManagerFactory factory;
    private EntityManager em;

    @After
    public void tearDown() {
        if (this.em != null) {
            this.em.close();
        }
        if (this.factory != null) {
            this.factory.close();
        }
    }

    @Test
    public void hibernate() {
        this.factory = Persistence.createEntityManagerFactory((String)"h2");
        this.em = this.factory.createEntityManager();
        System.out.println(this.em.getDelegate().getClass());
        Assert.assertEquals((Object)Hibernate5Templates.DEFAULT, (Object)JPAProvider.getTemplates((EntityManager)this.em));
    }

    @Test
    public void hibernate_for_proxy() {
        this.factory = Persistence.createEntityManagerFactory((String)"h2");
        this.em = this.factory.createEntityManager();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)JPAProviderTest.this.em, args);
            }
        };
        EntityManager proxy = (EntityManager)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{EntityManager.class}, handler);
        Assert.assertEquals((Object)Hibernate5Templates.DEFAULT, (Object)JPAProvider.getTemplates((EntityManager)proxy));
    }

    @Test
    public void eclipseLink() {
        this.factory = Persistence.createEntityManagerFactory((String)"h2-eclipselink");
        this.em = this.factory.createEntityManager();
        System.out.println(this.em.getDelegate().getClass());
        System.out.println(this.em.getProperties());
        Assert.assertEquals((Object)EclipseLinkTemplates.DEFAULT, (Object)JPAProvider.getTemplates((EntityManager)this.em));
    }

    @Test
    public void eclipseLink_for_proxy() {
        this.factory = Persistence.createEntityManagerFactory((String)"h2-eclipselink");
        this.em = this.factory.createEntityManager();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)JPAProviderTest.this.em, args);
            }
        };
        EntityManager proxy = (EntityManager)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{EntityManager.class}, handler);
        Assert.assertEquals((Object)EclipseLinkTemplates.DEFAULT, (Object)JPAProvider.getTemplates((EntityManager)proxy));
    }

    @Test
    @Ignore
    public void openJPA() {
        this.factory = Persistence.createEntityManagerFactory((String)"derby-openjpa");
        this.em = this.factory.createEntityManager();
        System.out.println(this.em.getDelegate().getClass());
        System.out.println(this.em.getProperties());
        Assert.assertEquals((Object)OpenJPATemplates.DEFAULT, (Object)JPAProvider.getTemplates((EntityManager)this.em));
    }

    @Test
    @Ignore
    public void batoo() {
        this.factory = Persistence.createEntityManagerFactory((String)"h2-batoo");
        this.em = this.factory.createEntityManager();
        System.out.println(this.em.getDelegate().getClass());
        System.out.println(this.em.getProperties());
        Assert.assertEquals((Object)BatooTemplates.DEFAULT, (Object)JPAProvider.getTemplates((EntityManager)this.em));
    }
}

