/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.JoinExpression;
import com.querydsl.core.JoinType;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPAQueryMixin;
import com.querydsl.jpa.QArticle;
import com.querydsl.jpa.domain.QCat;
import com.querydsl.jpa.domain.QCompany;
import com.querydsl.jpa.domain.QDepartment;
import com.querydsl.jpa.domain.QEmployee;
import com.querydsl.jpa.domain4.QBookMark;
import com.querydsl.jpa.domain4.QBookVersion;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class JPAQueryMixinTest {
    private JPAQueryMixin<?> mixin = new JPAQueryMixin();

    @Test
    public void where_null() {
        this.mixin.where((Predicate)null);
    }

    @Test
    public void orderBy() {
        QCat cat = QCat.cat;
        QCat catMate = new QCat("cat_mate");
        this.mixin.from((Expression)cat);
        this.mixin.orderBy(cat.mate.name.asc());
        QueryMetadata md = this.mixin.getMetadata();
        Assert.assertEquals(Arrays.asList(new JoinExpression(JoinType.DEFAULT, (Expression)cat), new JoinExpression(JoinType.LEFTJOIN, (Expression)cat.mate.as((Path)catMate))), (Object)md.getJoins());
        Assert.assertEquals(Collections.singletonList(catMate.name.asc()), (Object)md.getOrderBy());
    }

    @Test
    public void orderBy_nonRoot_twice() {
        QDepartment department = QDepartment.department;
        QCompany departmentCompany = new QCompany("department_company");
        QEmployee departmentCompanyCeo = new QEmployee("department_company_ceo");
        this.mixin.from((Expression)department);
        this.mixin.orderBy(new OrderSpecifier[]{department.company.ceo.firstName.asc(), department.company.ceo.lastName.asc()});
        QueryMetadata md = this.mixin.getMetadata();
        Assert.assertEquals(Arrays.asList(new JoinExpression(JoinType.DEFAULT, (Expression)department), new JoinExpression(JoinType.LEFTJOIN, (Expression)department.company.as((Path)departmentCompany)), new JoinExpression(JoinType.LEFTJOIN, (Expression)departmentCompany.ceo.as((Path)departmentCompanyCeo))), (Object)md.getJoins());
        Assert.assertEquals(Arrays.asList(departmentCompanyCeo.firstName.asc(), departmentCompanyCeo.lastName.asc()), (Object)md.getOrderBy());
    }

    @Test
    public void orderBy_where() {
        QCat cat = QCat.cat;
        this.mixin.from((Expression)cat);
        this.mixin.where((Predicate)cat.mate.name.isNotNull());
        this.mixin.orderBy(cat.mate.name.asc());
        QueryMetadata md = this.mixin.getMetadata();
        Assert.assertEquals(Collections.singletonList(new JoinExpression(JoinType.DEFAULT, (Expression)cat)), (Object)md.getJoins());
        Assert.assertEquals(Collections.singletonList(cat.mate.name.asc()), (Object)md.getOrderBy());
    }

    @Test
    public void orderBy_groupBy() {
        QCat cat = QCat.cat;
        this.mixin.from((Expression)cat);
        this.mixin.groupBy((Expression)cat.mate.name);
        this.mixin.orderBy(cat.mate.name.asc());
        QueryMetadata md = this.mixin.getMetadata();
        Assert.assertEquals(Collections.singletonList(new JoinExpression(JoinType.DEFAULT, (Expression)cat)), (Object)md.getJoins());
        Assert.assertEquals(Collections.singletonList(cat.mate.name.asc()), (Object)md.getOrderBy());
    }

    @Test
    public void orderBy_operation() {
        QCat cat = QCat.cat;
        QCat catMate = new QCat("cat_mate");
        this.mixin.from((Expression)cat);
        this.mixin.orderBy(cat.mate.name.lower().asc());
        QueryMetadata md = this.mixin.getMetadata();
        Assert.assertEquals(Arrays.asList(new JoinExpression(JoinType.DEFAULT, (Expression)cat), new JoinExpression(JoinType.LEFTJOIN, (Expression)cat.mate.as((Path)catMate))), (Object)md.getJoins());
        Assert.assertEquals(Collections.singletonList(catMate.name.lower().asc()), (Object)md.getOrderBy());
    }

    @Test
    public void orderBy_long() {
        QCat cat = QCat.cat;
        QCat catMate = new QCat("cat_mate");
        QCat catMateMate = new QCat("cat_mate_mate");
        this.mixin.from((Expression)cat);
        this.mixin.orderBy(cat.mate.mate.name.asc());
        QueryMetadata md = this.mixin.getMetadata();
        Assert.assertEquals(Arrays.asList(new JoinExpression(JoinType.DEFAULT, (Expression)cat), new JoinExpression(JoinType.LEFTJOIN, (Expression)cat.mate.as((Path)catMate)), new JoinExpression(JoinType.LEFTJOIN, (Expression)catMate.mate.as((Path)catMateMate))), (Object)md.getJoins());
        Assert.assertEquals(Collections.singletonList(catMateMate.name.asc()), (Object)md.getOrderBy());
    }

    @Test
    public void orderBy_reuse() {
        QCat cat = QCat.cat;
        QCat mate = new QCat("mate");
        this.mixin.from((Expression)cat);
        this.mixin.leftJoin((Expression)cat.mate, (Path)mate);
        this.mixin.orderBy(cat.mate.name.asc());
        QueryMetadata md = this.mixin.getMetadata();
        Assert.assertEquals(Arrays.asList(new JoinExpression(JoinType.DEFAULT, (Expression)cat), new JoinExpression(JoinType.LEFTJOIN, (Expression)cat.mate.as((Path)mate))), (Object)md.getJoins());
        Assert.assertEquals(Collections.singletonList(mate.name.asc()), (Object)md.getOrderBy());
    }

    @Test
    public void orderBy_long_reuse() {
        QCat cat = QCat.cat;
        QCat mate = new QCat("mate");
        QCat mateMate = new QCat("mate_mate");
        this.mixin.from((Expression)cat);
        this.mixin.leftJoin((Expression)cat.mate, (Path)mate);
        this.mixin.orderBy(cat.mate.mate.name.asc());
        QueryMetadata md = this.mixin.getMetadata();
        Assert.assertEquals(Arrays.asList(new JoinExpression(JoinType.DEFAULT, (Expression)cat), new JoinExpression(JoinType.LEFTJOIN, (Expression)cat.mate.as((Path)mate)), new JoinExpression(JoinType.LEFTJOIN, (Expression)mate.mate.as((Path)mateMate))), (Object)md.getJoins());
        Assert.assertEquals(Collections.singletonList(mateMate.name.asc()), (Object)md.getOrderBy());
    }

    @Test
    public void orderBy_any() {
        QCat cat = QCat.cat;
        QCat catKittens = new QCat("cat_kittens");
        this.mixin.from((Expression)cat);
        this.mixin.orderBy(((QCat)cat.kittens.any()).name.asc());
        QueryMetadata md = this.mixin.getMetadata();
        Assert.assertEquals(Arrays.asList(new JoinExpression(JoinType.DEFAULT, (Expression)cat), new JoinExpression(JoinType.LEFTJOIN, (Expression)cat.kittens.as((EntityPath)catKittens))), (Object)md.getJoins());
        Assert.assertEquals(Collections.singletonList(catKittens.name.asc()), (Object)md.getOrderBy());
    }

    @Test
    public void orderBy_embeddable() {
        QBookVersion bookVersion = QBookVersion.bookVersion;
        this.mixin.from((Expression)bookVersion);
        this.mixin.orderBy(bookVersion.definition.name.asc());
        QueryMetadata md = this.mixin.getMetadata();
        Assert.assertEquals(Collections.singletonList(new JoinExpression(JoinType.DEFAULT, (Expression)bookVersion)), (Object)md.getJoins());
        Assert.assertEquals(Collections.singletonList(bookVersion.definition.name.asc()), (Object)md.getOrderBy());
    }

    @Test
    public void orderBy_embeddable2() {
        QArticle article = QArticle.article;
        QArticle articleContentArticle = new QArticle("article_content_article");
        this.mixin.from((Expression)article);
        this.mixin.orderBy(article.content.article.name.asc());
        QueryMetadata md = this.mixin.getMetadata();
        Assert.assertEquals(Arrays.asList(new JoinExpression(JoinType.DEFAULT, (Expression)article), new JoinExpression(JoinType.LEFTJOIN, (Expression)article.content.article.as((Path)articleContentArticle))), (Object)md.getJoins());
        Assert.assertEquals(Collections.singletonList(articleContentArticle.name.asc()), (Object)md.getOrderBy());
    }

    @Test
    public void orderBy_embeddable_collection() {
        QBookVersion bookVersion = QBookVersion.bookVersion;
        QBookMark bookMark = new QBookMark("bookVersion_definition_bookMarks");
        this.mixin.from((Expression)bookVersion);
        this.mixin.orderBy(((QBookMark)bookVersion.definition.bookMarks.any()).comment.asc());
        QueryMetadata md = this.mixin.getMetadata();
        Assert.assertEquals(Collections.singletonList(new JoinExpression(JoinType.DEFAULT, (Expression)bookVersion)), (Object)md.getJoins());
        Assert.assertEquals(Collections.singletonList(Expressions.stringPath(bookVersion.definition.bookMarks, (String)"comment").asc()), (Object)md.getOrderBy());
    }

    @Test
    public void orderBy_nullsLast() {
        QCat cat = QCat.cat;
        this.mixin.from((Expression)cat);
        this.mixin.orderBy(cat.mate.name.asc().nullsLast());
        Assert.assertEquals((Object)OrderSpecifier.NullHandling.NullsLast, (Object)((OrderSpecifier)this.mixin.getMetadata().getOrderBy().get(0)).getNullHandling());
    }
}

