/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.HQLTemplates;
import com.querydsl.jpa.JPATest;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.domain.QCat;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.testutil.JPATestRunner;
import javax.persistence.EntityManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JPATestRunner.class)
public class JPAQueryMutability2Test
implements JPATest {
    private EntityManager entityManager;
    private final Operator customOperator = new Operator(){

        public String name() {
            return "custom";
        }

        public String toString() {
            return this.name();
        }

        public Class<?> getType() {
            return Object.class;
        }
    };
    private final JPQLTemplates customTemplates = new HQLTemplates(){
        {
            this.add(JPAQueryMutability2Test.this.customOperator, "sign({0})");
        }
    };

    protected JPAQuery<?> query() {
        return new JPAQuery(this.entityManager);
    }

    protected JPAQuery<?> query(JPQLTemplates templates) {
        return new JPAQuery(this.entityManager, templates);
    }

    @Override
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Test
    public void test() {
        QCat cat = QCat.cat;
        JPAQuery query = (JPAQuery)this.query().from((EntityPath)cat);
        query.fetchCount();
        ((JPAQuery)query.distinct()).fetchCount();
        query.select((Expression)cat).iterate();
        query.select(new Expression[]{cat, cat}).iterate();
        ((JPAQuery)query.distinct()).select((Expression)cat).iterate();
        ((JPAQuery)query.distinct()).select(new Expression[]{cat, cat}).iterate();
        query.select((Expression)cat).fetch();
        query.select(new Expression[]{cat, cat}).fetch();
        ((JPAQuery)query.distinct()).select((Expression)cat).fetch();
        ((JPAQuery)query.distinct()).select(new Expression[]{cat, cat}).fetch();
        query.select((Expression)cat).fetchResults();
        ((JPAQuery)query.distinct()).select((Expression)cat).fetchResults();
    }

    @Test
    public void clone_() {
        QCat cat = QCat.cat;
        JPAQuery query = (JPAQuery)((JPAQuery)this.query().from((EntityPath)cat)).where((Predicate)cat.name.isNotNull());
        JPAQuery query2 = query.clone(this.entityManager);
        Assert.assertEquals((Object)query.getMetadata().getJoins(), (Object)query2.getMetadata().getJoins());
        Assert.assertEquals((Object)query.getMetadata().getWhere(), (Object)query2.getMetadata().getWhere());
        query2.select((Expression)cat).fetch();
    }

    @Test
    public void clone_custom_templates() {
        QCat cat = QCat.cat;
        JPAQuery query = (JPAQuery)this.query().from((EntityPath)cat);
        query.clone(this.entityManager, this.customTemplates).select((Expression)Expressions.numberOperation(Integer.class, (Operator)this.customOperator, (Expression[])new Expression[]{cat.floatProperty})).fetchOne();
    }

    @Test
    public void clone_keep_templates() {
        QCat cat = QCat.cat;
        JPAQuery query = (JPAQuery)this.query(this.customTemplates).from((EntityPath)cat);
        ((JPAQuery)query.clone()).select((Expression)Expressions.numberOperation(Integer.class, (Operator)this.customOperator, (Expression[])new Expression[]{cat.floatProperty})).fetchOne();
    }

    @Test(expected=IllegalArgumentException.class)
    public void clone_lose_templates() {
        QCat cat = QCat.cat;
        JPAQuery query = (JPAQuery)this.query(this.customTemplates).from((EntityPath)cat);
        query.clone(this.entityManager).select((Expression)Expressions.numberOperation(Integer.class, (Operator)this.customOperator, (Expression[])new Expression[]{cat.floatProperty})).fetchOne();
    }
}

