/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.Target;
import com.querydsl.core.testutil.ExcludeIn;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.jpa.AbstractSQLTest;
import com.querydsl.jpa.JPAProviderRule;
import com.querydsl.jpa.JPATest;
import com.querydsl.jpa.Mode;
import com.querydsl.jpa.TargetRule;
import com.querydsl.jpa.domain.Cat;
import com.querydsl.jpa.domain.Color;
import com.querydsl.jpa.domain.QCat;
import com.querydsl.jpa.domain.sql.SAnimal;
import com.querydsl.jpa.sql.JPASQLQuery;
import com.querydsl.jpa.testutil.JPATestRunner;
import com.querydsl.sql.SQLTemplates;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;

@RunWith(value=JPATestRunner.class)
public class JPASQLBase
extends AbstractSQLTest
implements JPATest {
    @Rule
    @ClassRule
    public static TestRule targetRule = new TargetRule();
    @Rule
    @ClassRule
    public static TestRule hibernateOnly = new JPAProviderRule();
    private final SQLTemplates templates = Mode.getSQLTemplates();
    private EntityManager entityManager;
    private final SAnimal cat = new SAnimal("cat");
    private final QCat catEntity = QCat.cat;

    protected JPASQLQuery<?> query() {
        return new JPASQLQuery(this.entityManager, this.templates);
    }

    @Override
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Before
    public void setUp() {
        if (((JPASQLQuery)this.query().from((Expression)this.cat)).fetchCount() == 0L) {
            this.entityManager.persist((Object)new Cat("Beck", 1, Color.BLACK));
            this.entityManager.persist((Object)new Cat("Kate", 2, Color.BLACK));
            this.entityManager.persist((Object)new Cat("Kitty", 3, Color.BLACK));
            this.entityManager.persist((Object)new Cat("Bobby", 4, Color.BLACK));
            this.entityManager.persist((Object)new Cat("Harold", 5, Color.BLACK));
            this.entityManager.persist((Object)new Cat("Tim", 6, Color.BLACK));
            this.entityManager.flush();
        }
    }

    private <T> void insertEntitiesForTest(List<T> entities) {
        for (T entity : entities) {
            this.entityManager.persist(entity);
        }
        this.entityManager.flush();
    }

    private <T> void removeEntitiesForTest(List<T> entities) {
        for (T entity : entities) {
            this.entityManager.remove(entity);
        }
        this.entityManager.flush();
    }

    @Test
    public void entityQueries_createQuery() {
        Query query = ((JPASQLQuery)this.query().from((Expression)this.cat)).select((Expression)this.catEntity).createQuery();
        Assert.assertEquals((long)6L, (long)query.getResultList().size());
    }

    @Test
    @ExcludeIn(value={Target.MYSQL})
    public void entityQueries_createQuery2() {
        SAnimal cat = new SAnimal("CAT");
        Query query = ((JPASQLQuery)this.query().from((Expression)cat)).select((Expression)this.catEntity).createQuery();
        Assert.assertEquals((long)6L, (long)query.getResultList().size());
    }

    @Test
    public void should_fetch_results_with_factory_expression() {
        long expectedTotalResultCount = 6L;
        HashMap<String, StringPath> bindings = new HashMap<String, StringPath>();
        bindings.put("name", this.cat.name);
        long actualTotalResultCount = ((JPASQLQuery)this.query().from((Expression)this.cat)).select((Expression)Projections.bean(Cat.class, bindings)).fetchResults().getTotal();
        Assert.assertEquals((long)6L, (long)actualTotalResultCount);
    }

    @Test
    public void should_get_grouped_list_by_using_fetch_results() {
        long expectedCatColorKindCount = 1L;
        long actualCatColorKindCount = ((JPASQLQuery)((JPASQLQuery)this.query().from((Expression)this.cat)).select(this.catEntity.color).groupBy(this.catEntity.color)).fetchResults().getTotal();
        Assert.assertEquals((long)1L, (long)actualCatColorKindCount);
    }

    @Test
    public void should_get_black_cat_count_by_using_group_by_and_having() {
        long expectedTabbyCatCount = 2L;
        Cat tabbyColorCatFoo = new Cat("Foo", 7, Color.TABBY);
        Cat tabbyColorCatBar = new Cat("Bar", 8, Color.TABBY);
        this.insertEntitiesForTest(Arrays.asList(tabbyColorCatFoo, tabbyColorCatBar));
        long actualTabbyCatCount = (Long)((JPASQLQuery)((JPASQLQuery)((JPASQLQuery)this.query().from((Expression)this.cat)).select((Expression)this.catEntity.name.count()).groupBy(this.catEntity.color)).having((Predicate)this.catEntity.name.count().eq((Object)2L))).fetchOne();
        this.removeEntitiesForTest(Arrays.asList(tabbyColorCatFoo, tabbyColorCatBar));
        Assert.assertEquals((long)2L, (long)actualTabbyCatCount);
    }
}

