/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.JoinType;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.domain.QAnimal;
import com.querydsl.core.domain.QCat;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.BeanPath;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.jpa.HQLTemplates;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.JPQLSerializer;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.OpenJPATemplates;
import com.querydsl.jpa.domain.JobFunction;
import com.querydsl.jpa.domain.Location;
import com.querydsl.jpa.domain.QDomesticCat;
import com.querydsl.jpa.domain.QEmployee;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class JPQLSerializerTest {
    @Test
    public void and_or() {
        QCat cat = QCat.cat;
        BooleanExpression pred = cat.id.eq((Object)1).and((Predicate)cat.name.eq((Object)"Kitty").or((Predicate)cat.name.eq((Object)"Boris")));
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        serializer.handle((Expression)pred);
        Assert.assertEquals((Object)"cat.id = ?1 and (cat.name = ?2 or cat.name = ?3)", (Object)serializer.toString());
        Assert.assertEquals((Object)"cat.id = 1 && (cat.name = Kitty || cat.name = Boris)", (Object)pred.toString());
    }

    @Test
    public void case1() {
        QCat cat = QCat.cat;
        JPQLSerializer serializer = new JPQLSerializer(JPQLTemplates.DEFAULT);
        Expression expr = Expressions.cases().when((Predicate)cat.toes.eq((Object)2)).then((Number)2).when((Predicate)cat.toes.eq((Object)3)).then((Object)3).otherwise((Object)4);
        serializer.handle(expr);
        Assert.assertEquals((Object)"case when (cat.toes = ?1) then ?2 when (cat.toes = ?3) then ?4 else ?5 end", (Object)serializer.toString());
    }

    @Test
    public void case1_hibernate() {
        QCat cat = QCat.cat;
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        Expression expr = Expressions.cases().when((Predicate)cat.toes.eq((Object)2)).then((Number)2).when((Predicate)cat.toes.eq((Object)3)).then((Object)3).otherwise((Object)4);
        serializer.handle(expr);
        Assert.assertEquals((Object)"case when (cat.toes = ?1) then ?2 when (cat.toes = ?3) then ?4 else 4 end", (Object)serializer.toString());
    }

    @Test
    public void case2() {
        QCat cat = QCat.cat;
        JPQLSerializer serializer = new JPQLSerializer(JPQLTemplates.DEFAULT);
        Expression expr = Expressions.cases().when((Predicate)cat.toes.eq((Object)2)).then(cat.id.multiply((Number)2)).when((Predicate)cat.toes.eq((Object)3)).then((Expression)cat.id.multiply((Number)3)).otherwise((Object)4);
        serializer.handle(expr);
        Assert.assertEquals((Object)"case when (cat.toes = ?1) then (cat.id * ?2) when (cat.toes = ?3) then (cat.id * ?4) else ?5 end", (Object)serializer.toString());
    }

    @Test
    public void case2_hibernate() {
        QCat cat = QCat.cat;
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        Expression expr = Expressions.cases().when((Predicate)cat.toes.eq((Object)2)).then(cat.id.multiply((Number)2)).when((Predicate)cat.toes.eq((Object)3)).then((Expression)cat.id.multiply((Number)3)).otherwise((Object)4);
        serializer.handle(expr);
        Assert.assertEquals((Object)"case when (cat.toes = ?1) then (cat.id * ?2) when (cat.toes = ?3) then (cat.id * ?4) else 4 end", (Object)serializer.toString());
    }

    @Test
    public void count() {
        QCat cat = QCat.cat;
        DefaultQueryMetadata md = new DefaultQueryMetadata();
        md.addJoin(JoinType.DEFAULT, (Expression)cat);
        md.setProjection((Expression)cat.mate.countDistinct());
        JPQLSerializer serializer1 = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        serializer1.serialize((QueryMetadata)md, true, null);
        Assert.assertEquals((Object)"select count(count(distinct cat.mate))\nfrom Cat cat", (Object)serializer1.toString());
        JPQLSerializer serializer2 = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        serializer2.serialize((QueryMetadata)md, false, null);
        Assert.assertEquals((Object)"select count(distinct cat.mate)\nfrom Cat cat", (Object)serializer2.toString());
    }

    @Test
    public void fromWithCustomEntityName() {
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        EntityPathBase entityPath = new EntityPathBase(Location.class, "entity");
        DefaultQueryMetadata md = new DefaultQueryMetadata();
        md.addJoin(JoinType.DEFAULT, (Expression)entityPath);
        serializer.serialize((QueryMetadata)md, false, null);
        Assert.assertEquals((Object)"select entity\nfrom Location2 entity", (Object)serializer.toString());
    }

    @Test
    public void join_with() {
        QCat cat = QCat.cat;
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        DefaultQueryMetadata md = new DefaultQueryMetadata();
        md.addJoin(JoinType.DEFAULT, (Expression)cat);
        md.addJoin(JoinType.INNERJOIN, (Expression)cat.mate);
        md.addJoinCondition((Predicate)cat.mate.alive);
        serializer.serialize((QueryMetadata)md, false, null);
        Assert.assertEquals((Object)"select cat\nfrom Cat cat\n  inner join cat.mate with cat.mate.alive", (Object)serializer.toString());
    }

    @Test
    public void normalizeNumericArgs() {
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        NumberPath doublePath = Expressions.numberPath(Double.class, (String)"doublePath");
        serializer.handle((Expression)doublePath.add((Number)1));
        serializer.handle((Expression)doublePath.between((Number)Float.valueOf(1.0f), (Number)1L));
        serializer.handle((Expression)doublePath.lt((Number)1));
        for (Object constant : serializer.getConstants()) {
            Assert.assertEquals(Double.class, constant.getClass());
        }
    }

    @Test
    public void delete_clause_uses_dELETE_fROM() {
        QEmployee employee = QEmployee.employee;
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        DefaultQueryMetadata md = new DefaultQueryMetadata();
        md.addJoin(JoinType.DEFAULT, (Expression)employee);
        md.addWhere((Predicate)employee.lastName.isNull());
        serializer.serializeForDelete((QueryMetadata)md);
        Assert.assertEquals((Object)"delete from Employee employee\nwhere employee.lastName is null", (Object)serializer.toString());
    }

    @Test
    public void delete_with_subQuery() {
        QCat parent = QCat.cat;
        QCat child = new QCat("kitten");
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        DefaultQueryMetadata md = new DefaultQueryMetadata();
        md.addJoin(JoinType.DEFAULT, (Expression)child);
        md.addWhere((Predicate)child.id.eq((Object)1).and((Predicate)((JPQLQuery)JPAExpressions.selectOne().from(new EntityPath[]{parent}).where(new Predicate[]{parent.id.eq((Object)2), child.in((CollectionExpression)parent.kittens)})).exists()));
        serializer.serializeForDelete((QueryMetadata)md);
        Assert.assertEquals((Object)"delete from Cat kitten\nwhere kitten.id = ?1 and exists (select 1\nfrom Cat cat\nwhere cat.id = ?2 and kitten member of cat.kittens)", (Object)serializer.toString());
    }

    @Test
    public void in() {
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        serializer.handle((Expression)Expressions.numberPath(Integer.class, (String)"id").in(Arrays.asList(1, 2)));
        Assert.assertEquals((Object)"id in (?1)", (Object)serializer.toString());
    }

    @Test
    public void not_in() {
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        serializer.handle((Expression)Expressions.numberPath(Integer.class, (String)"id").notIn(Arrays.asList(1, 2)));
        Assert.assertEquals((Object)"id not in (?1)", (Object)serializer.toString());
    }

    @Test
    public void like() {
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        serializer.handle((Expression)Expressions.stringPath((String)"str").contains("abc!"));
        Assert.assertEquals((Object)"str like ?1 escape '!'", (Object)serializer.toString());
        Assert.assertEquals((Object)"%abc!!%", (Object)serializer.getConstants().get(0).toString());
    }

    @Test
    public void stringContainsIc() {
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        serializer.handle((Expression)Expressions.stringPath((String)"str").containsIgnoreCase("ABc!"));
        Assert.assertEquals((Object)"lower(str) like ?1 escape '!'", (Object)serializer.toString());
        Assert.assertEquals((Object)"%abc!!%", (Object)serializer.getConstants().get(0).toString());
    }

    @Test
    public void substring() {
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        QCat cat = QCat.cat;
        serializer.handle((Expression)cat.name.substring((Expression)cat.name.length().subtract((Number)1), 1));
        Assert.assertEquals((Object)"substring(cat.name,length(cat.name) + ?1,?2 - (length(cat.name) - ?3))", (Object)serializer.toString());
    }

    @Test
    public void nullsFirst() {
        QCat cat = QCat.cat;
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        DefaultQueryMetadata md = new DefaultQueryMetadata();
        md.addJoin(JoinType.DEFAULT, (Expression)cat);
        md.addOrderBy(cat.name.asc().nullsFirst());
        serializer.serialize((QueryMetadata)md, false, null);
        Assert.assertEquals((Object)"select cat\nfrom Cat cat\norder by cat.name asc nulls first", (Object)serializer.toString());
    }

    @Test
    public void nullsLast() {
        QCat cat = QCat.cat;
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        DefaultQueryMetadata md = new DefaultQueryMetadata();
        md.addJoin(JoinType.DEFAULT, (Expression)cat);
        md.addOrderBy(cat.name.asc().nullsLast());
        serializer.serialize((QueryMetadata)md, false, null);
        Assert.assertEquals((Object)"select cat\nfrom Cat cat\norder by cat.name asc nulls last", (Object)serializer.toString());
    }

    @Test
    public void treat() {
        QCat cat = QCat.cat;
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        DefaultQueryMetadata md = new DefaultQueryMetadata();
        md.addJoin(JoinType.DEFAULT, (Expression)cat);
        md.addJoin(JoinType.JOIN, (Expression)cat.mate.as((Path)QDomesticCat.domesticCat));
        md.setProjection((Expression)QDomesticCat.domesticCat);
        serializer.serialize((QueryMetadata)md, false, null);
        Assert.assertEquals((Object)"select domesticCat\nfrom Cat cat\n  inner join treat(cat.mate as DomesticCat) as domesticCat", (Object)serializer.toString());
    }

    @Test
    public void treated_path() {
        QAnimal animal = QAnimal.animal;
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        DefaultQueryMetadata md = new DefaultQueryMetadata();
        md.addJoin(JoinType.DEFAULT, (Expression)animal);
        md.addWhere((Predicate)((QCat)JPAExpressions.treat((BeanPath)animal, QCat.class)).breed.eq((Object)1));
        md.setProjection((Expression)animal);
        serializer.serialize((QueryMetadata)md, false, null);
        Assert.assertEquals((Object)"select animal\nfrom Animal animal\nwhere treat(animal as Cat).breed = ?1", (Object)serializer.toString());
    }

    @Test
    public void openJPA_variables() {
        QCat cat = QCat.cat;
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)OpenJPATemplates.DEFAULT);
        DefaultQueryMetadata md = new DefaultQueryMetadata();
        md.addJoin(JoinType.DEFAULT, (Expression)cat);
        md.addJoin(JoinType.INNERJOIN, (Expression)cat.mate);
        md.addJoinCondition((Predicate)cat.mate.alive);
        serializer.serialize((QueryMetadata)md, false, null);
        Assert.assertEquals((Object)"select cat_\nfrom Cat cat_\n  inner join cat_.mate on cat_.mate.alive", (Object)serializer.toString());
    }

    @Test
    public void visitLiteral_boolean() {
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        serializer.visitLiteral((Object)Boolean.TRUE);
        Assert.assertEquals((Object)"true", (Object)serializer.toString());
    }

    @Test
    public void visitLiteral_number() {
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        serializer.visitLiteral((Object)1.543);
        Assert.assertEquals((Object)"1.543", (Object)serializer.toString());
    }

    @Test
    public void visitLiteral_string() {
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        serializer.visitLiteral((Object)"abc''def");
        Assert.assertEquals((Object)"'abc''''def'", (Object)serializer.toString());
    }

    @Test
    public void visitLiteral_enum() {
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        serializer.visitLiteral((Object)JobFunction.MANAGER);
        Assert.assertEquals((Object)"com.querydsl.jpa.domain.JobFunction.MANAGER", (Object)serializer.toString());
    }

    @Test
    public void substring_indexOf() {
        QCat cat = QCat.cat;
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT);
        cat.name.substring((Expression)cat.name.indexOf("")).accept((Visitor)serializer, null);
        Assert.assertEquals((Object)"substring(cat.name,locate(?1,cat.name)-1 + ?2)", (Object)serializer.toString());
    }
}

