/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.JoinType;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.jpa.NativeSQLSerializer;
import com.querydsl.jpa.domain.sql.SAnimal;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.MySQLTemplates;
import com.querydsl.sql.SQLTemplates;
import javax.persistence.Column;
import org.junit.Assert;
import org.junit.Test;

public class NativeSQLSerializerTest {
    @Test
    public void in() {
        Configuration conf = new Configuration((SQLTemplates)new MySQLTemplates());
        NativeSQLSerializer serializer = new NativeSQLSerializer(conf, true);
        DefaultQueryMetadata md = new DefaultQueryMetadata();
        SAnimal cat = SAnimal.animal_;
        md.addJoin(JoinType.DEFAULT, (Expression)cat);
        md.addWhere((Predicate)cat.name.in((Object[])new String[]{"X", "Y"}));
        md.setProjection(cat.id);
        serializer.serialize((QueryMetadata)md, false);
        Assert.assertEquals((Object)"select animal_.id\nfrom animal_ animal_\nwhere animal_.name in (?1, ?2)", (Object)serializer.toString());
    }

    @Test
    public void path_column() {
        PathBuilder entity = new PathBuilder(Entity.class, "entity");
        Configuration conf = new Configuration((SQLTemplates)new MySQLTemplates());
        NativeSQLSerializer serializer = new NativeSQLSerializer(conf, true);
        serializer.handle((Expression)entity.get("name"));
        Assert.assertEquals((Object)"entity.name", (Object)serializer.toString());
    }

    @Test
    public void path_column2() {
        PathBuilder entity = new PathBuilder(Entity.class, "entity");
        Configuration conf = new Configuration((SQLTemplates)new MySQLTemplates());
        NativeSQLSerializer serializer = new NativeSQLSerializer(conf, true);
        serializer.handle((Expression)entity.get("firstName"));
        Assert.assertEquals((Object)"entity.first_name", (Object)serializer.toString());
    }

    public static class Entity {
        @Column
        private String name;
        @Column(name="first_name")
        private String firstName;
    }
}

