/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.apt.hibernate.HibernateAnnotationProcessor;
import com.querydsl.apt.jpa.JPAAnnotationProcessor;
import com.querydsl.codegen.CodegenModule;
import com.querydsl.codegen.utils.CodeWriter;
import com.querydsl.core.types.Expression;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Scanner;
import javax.persistence.Entity;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PackageVerification {
    @Test
    public void verify_package() throws Exception {
        String version = System.getProperty("version");
        this.verify(new File("target/querydsl-jpa-" + version + "-apt-hibernate-one-jar.jar"), true);
        this.verify(new File("target/querydsl-jpa-" + version + "-apt-one-jar.jar"), false);
    }

    private void verify(File oneJar, boolean hibernateDeps) throws Exception {
        Class<JPAAnnotationProcessor> processor;
        Assert.assertTrue((String)(oneJar.getPath() + " doesn't exist"), (boolean)oneJar.exists());
        URLClassLoader oneJarClassLoader = new URLClassLoader(new URL[]{oneJar.toURI().toURL()});
        oneJarClassLoader.loadClass(Expression.class.getName());
        oneJarClassLoader.loadClass(CodeWriter.class.getName());
        oneJarClassLoader.loadClass(CodegenModule.class.getName()).newInstance();
        oneJarClassLoader.loadClass(Entity.class.getName());
        if (hibernateDeps) {
            oneJarClassLoader.loadClass(Type.class.getName());
            processor = HibernateAnnotationProcessor.class;
        } else {
            processor = JPAAnnotationProcessor.class;
        }
        Class<?> cl = oneJarClassLoader.loadClass(processor.getName());
        cl.newInstance();
        String resourceKey = "META-INF/services/javax.annotation.processing.Processor";
        Assert.assertEquals((Object)processor.getName(), (Object)new Scanner(oneJarClassLoader.findResource(resourceKey).openStream()).nextLine());
    }
}

