/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.querydsl.core.Target;
import com.querydsl.core.alias.Alias;
import com.querydsl.core.testutil.ExcludeIn;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.DateExpression;
import com.querydsl.core.types.dsl.DatePath;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.jpa.AbstractQueryTest;
import com.querydsl.jpa.Constants;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.NoBatooJPA;
import com.querydsl.jpa.NoEclipseLink;
import com.querydsl.jpa.NoOpenJPA;
import com.querydsl.jpa.QueryHelper;
import com.querydsl.jpa.domain.Cat;
import com.querydsl.jpa.domain.Catalog;
import com.querydsl.jpa.domain.Color;
import com.querydsl.jpa.domain.Customer;
import com.querydsl.jpa.domain.DomesticCat;
import com.querydsl.jpa.domain.Payment;
import com.querydsl.jpa.domain.Product;
import com.querydsl.jpa.domain.QFamily;
import com.querydsl.jpa.domain.QFooDTO;
import com.querydsl.jpa.domain.QItem;
import com.querydsl.jpa.domain.QProduct;
import java.util.Date;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ParsingTest
extends AbstractQueryTest {
    @Test
    @Ignore
    public void arrayExpr() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.ord)).where((Predicate)Constants.ord.items((int)0).id.eq((Object)1234L))).parse();
    }

    @Test
    public void basic() throws RecognitionException, TokenStreamException {
        ((QueryHelper)this.query().from(new EntityPath[]{Constants.cat, Constants.fatcat})).select((Expression<?>[])new Expression[]{Constants.cat.name, Constants.fatcat.name}).parse();
    }

    @Test
    @ExcludeIn(value={Target.SQLSERVER})
    public void beforeAndAfter() throws RecognitionException, TokenStreamException {
        DatePath<Date> ed = Constants.catalog.effectiveDate;
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.catalog)).where(new Predicate[]{ed.gt((Expression)DateExpression.currentDate()), ed.goe((Expression)DateExpression.currentDate()), ed.lt((Expression)DateExpression.currentDate()), ed.loe((Expression)DateExpression.currentDate())})).select(Constants.catalog).parse();
    }

    @Test
    @ExcludeIn(value={Target.ORACLE})
    public void complexConstructor() throws Exception {
        ((QueryHelper)this.query().from((EntityPath)Constants.bar)).select(new QFooDTO((Expression<Long>)Constants.bar.count())).parse();
    }

    @Test
    public void docoExamples910() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).groupBy((Expression)Constants.cat.color)).select((Expression<?>[])new Expression[]{Constants.cat.color, Constants.cat.weight.sum(), Constants.cat.count()}).parse();
    }

    @Test
    public void docoExamples910_2() throws Exception {
        ((QueryHelper)((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).groupBy((Expression)Constants.cat.color)).having((Predicate)Constants.cat.color.in((Object[])new Color[]{Color.TABBY, Color.BLACK}))).select((Expression<?>[])new Expression[]{Constants.cat.color, Constants.cat.weight.sum(), Constants.cat.count()}).parse();
    }

    @Test
    @Ignore
    public void docoExamples910_3() throws Exception {
        ((QueryHelper)((QueryHelper)((QueryHelper)((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).join((CollectionExpression)Constants.cat.kittens, (Path)Constants.kitten)).groupBy((Expression)Constants.cat)).having((Predicate)Constants.kitten.weight.avg().gt((Number)100.0))).orderBy(new OrderSpecifier[]{Constants.kitten.count().asc(), Constants.kitten.weight.sum().desc()})).select(Constants.cat).parse();
    }

    @Test
    public void docoExamples911() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.fatcat)).where((Predicate)Constants.fatcat.weight.gt((Expression)JPAExpressions.select((Expression)Constants.cat.weight.avg()).from(new EntityPath[]{Constants.cat})))).parse();
    }

    @Test
    public void docoExamples911_2() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.name.eqAny((SubQueryExpression)JPAExpressions.select((Expression)Constants.name.nickName).from(new EntityPath[]{Constants.name})))).parse();
    }

    @Test
    public void docoExamples911_3() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)((JPQLQuery)JPAExpressions.select((Expression)Constants.mate).from(new EntityPath[]{Constants.mate}).where(new Predicate[]{Constants.mate.mate.eq((Expression)Constants.cat)})).notExists())).parse();
    }

    @Test
    public void docoExamples911_4() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)((JPQLQuery)JPAExpressions.selectFrom((EntityPath)Constants.mate).where(new Predicate[]{Constants.mate.mate.eq((Expression)Constants.cat)})).exists())).parse();
    }

    @Test
    public void docoExamples911_5() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.name.notIn((SubQueryExpression)JPAExpressions.select((Expression)Constants.name.nickName).from(new EntityPath[]{Constants.name})))).parse();
    }

    @Test
    public void docoExamples912() throws Exception {
        ((QueryHelper)((QueryHelper)((QueryHelper)((QueryHelper)((QueryHelper)((QueryHelper)((QueryHelper)((QueryHelper)((QueryHelper)this.query().from(new EntityPath[]{Constants.ord, Constants.cust})).join((CollectionExpression)Constants.ord.lineItems, (Path)Constants.item)).join((EntityPath)Constants.item.product, (Path)Constants.product)).from((EntityPath)Constants.catalog)).join((CollectionExpression)Constants.catalog.prices, (Path)Constants.price)).where((Predicate)Constants.ord.paid.not().and((Predicate)Constants.ord.customer.eq((Expression)Constants.cust)).and((Predicate)Constants.price.product.eq((Expression)Constants.product)).and((Predicate)Constants.catalog.effectiveDate.gt((Expression)DateExpression.currentDate())).and((Predicate)Constants.catalog.effectiveDate.gtAny((SubQueryExpression)JPAExpressions.select(Constants.catalog.effectiveDate).from(new EntityPath[]{Constants.catalog}).where(new Predicate[]{Constants.catalog.effectiveDate.lt((Expression)DateExpression.currentDate())}))))).groupBy((Expression)Constants.ord)).having((Predicate)Constants.price.amount.sum().gt((Number)0L))).orderBy(Constants.price.amount.sum().desc())).select((Expression<?>[])new Expression[]{Constants.ord.id, Constants.price.amount.sum(), Constants.item.count()});
        Customer c1 = new Customer();
        Catalog c2 = new Catalog();
        ((QueryHelper)((QueryHelper)((QueryHelper)((QueryHelper)((QueryHelper)((QueryHelper)((QueryHelper)((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.ord)).join((CollectionExpression)Constants.ord.lineItems, (Path)Constants.item)).join((EntityPath)Constants.item.product, (Path)Constants.product)).from((EntityPath)Constants.catalog)).join((CollectionExpression)Constants.catalog.prices, (Path)Constants.price)).where((Predicate)Constants.ord.paid.not().and((Predicate)Constants.ord.customer.eq(c1)).and((Predicate)Constants.price.product.eq((Expression)Constants.product)).and((Predicate)Constants.catalog.eq(c2)))).groupBy((Expression)Constants.ord)).having((Predicate)Constants.price.amount.sum().gt((Number)0L))).orderBy(Constants.price.amount.sum().desc())).select((Expression<?>[])new Expression[]{Constants.ord.id, Constants.price.amount.sum(), Constants.item.count()});
    }

    @Test
    public void docoExamples92() throws Exception {
        ((QueryHelper)this.query().from((EntityPath)Constants.cat)).parse();
    }

    @Test
    public void docoExamples92_2() throws Exception {
        ((QueryHelper)this.query().from((EntityPath)Constants.cat)).parse();
    }

    @Test
    public void docoExamples92_3() throws Exception {
        ((QueryHelper)this.query().from(new EntityPath[]{Constants.form, Constants.param})).parse();
    }

    @Test
    public void docoExamples93() throws Exception {
        ((QueryHelper)((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).innerJoin((EntityPath)Constants.cat.mate, (Path)Constants.mate)).leftJoin((CollectionExpression)Constants.cat.kittens, (Path)Constants.kitten)).parse();
    }

    @Test
    public void docoExamples93_2() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).leftJoin((CollectionExpression)Constants.cat.mate.kittens, (Path)Constants.kitten)).parse();
    }

    @Test
    public void docoExamples93_3() throws Exception {
        ((QueryHelper)((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).join((EntityPath)Constants.cat.mate, (Path)Constants.mate)).leftJoin((CollectionExpression)Constants.cat.kittens, (Path)Constants.kitten)).parse();
    }

    @Test
    public void docoExamples93_4() throws Exception {
        ((QueryHelper)((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).innerJoin((EntityPath)Constants.cat.mate, (Path)Constants.mate)).leftJoin((CollectionExpression)Constants.cat.kittens, (Path)Constants.kitten)).parse();
    }

    @Test
    public void docoExamples93_viaAlias() throws Exception {
        Cat c = (Cat)Alias.alias(Cat.class, (String)"cat");
        Cat k = (Cat)Alias.alias(Cat.class, (String)"kittens");
        Cat m = (Cat)Alias.alias(Cat.class, (String)"mate");
        ((QueryHelper)((QueryHelper)((QueryHelper)this.query().from((EntityPath)Alias.$((Object)c))).innerJoin((EntityPath)Alias.$((Object)c.getMate()), (Path)Alias.$((Object)m))).leftJoin((CollectionExpression)Alias.$(c.getKittens()), (Path)Alias.$((Object)k))).parse();
    }

    @Test
    public void docoExamples93_viaAlias2() throws Exception {
        Cat c = (Cat)Alias.alias(Cat.class, (String)"cat");
        Cat k = (Cat)Alias.alias(Cat.class, (String)"kittens");
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Alias.$((Object)c))).leftJoin((CollectionExpression)Alias.$(c.getMate().getKittens()), (Path)Alias.$((Object)k))).parse();
    }

    @Test
    public void docoExamples93_viaAlias3() throws Exception {
        Cat c = (Cat)Alias.alias(Cat.class, (String)"cat");
        Cat k = (Cat)Alias.alias(Cat.class, (String)"kittens");
        Cat m = (Cat)Alias.alias(Cat.class, (String)"mate");
        ((QueryHelper)((QueryHelper)((QueryHelper)this.query().from((EntityPath)Alias.$((Object)c))).innerJoin((EntityPath)Alias.$((Object)c.getMate()), (Path)Alias.$((Object)m))).leftJoin((CollectionExpression)Alias.$(c.getKittens()), (Path)Alias.$((Object)k))).parse();
    }

    @Test
    public void docoExamples93_viaAlias4() throws Exception {
        Cat c = (Cat)Alias.alias(Cat.class, (String)"cat");
        Cat k = (Cat)Alias.alias(Cat.class, (String)"kittens");
        Cat m = (Cat)Alias.alias(Cat.class, (String)"mate");
        ((QueryHelper)((QueryHelper)((QueryHelper)this.query().from((EntityPath)Alias.$((Object)c))).innerJoin((EntityPath)Alias.$((Object)c.getMate()), (Path)Alias.$((Object)m))).leftJoin((CollectionExpression)Alias.$(c.getKittens()), (Path)Alias.$((Object)k))).parse();
    }

    @Test
    public void docoExamples94() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).innerJoin((EntityPath)Constants.cat.mate, (Path)Constants.mate)).select(Constants.cat.mate).parse();
    }

    @Test
    public void docoExamples94_2() throws Exception {
        ((QueryHelper)this.query().from((EntityPath)Constants.cat)).select(Constants.cat.mate).parse();
    }

    @Test
    @NoOpenJPA
    @NoBatooJPA
    public void docoExamples94_3() throws Exception {
        ((QueryHelper)this.query().from((EntityPath)Constants.cat)).select(Constants.cat.kittens).parse();
    }

    @Test
    public void docoExamples94_4() throws Exception {
        ((QueryHelper)this.query().from((EntityPath)Constants.cust)).select(Constants.cust.name.firstName).parse();
    }

    @Test
    public void docoExamples94_5() throws Exception {
        ((QueryHelper)((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.mother)).innerJoin((EntityPath)Constants.mother.mate, (Path)Constants.mate)).leftJoin((CollectionExpression)Constants.mother.kittens, (Path)Constants.offspr)).select((Expression<?>[])new Expression[]{Constants.mother, Constants.offspr, Constants.mate}).parse();
    }

    @Test
    public void docoExamples94_6() throws Exception {
        ((QueryHelper)((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.mother)).innerJoin((EntityPath)Constants.mother.mate, (Path)Constants.mate)).leftJoin((CollectionExpression)Constants.mother.kittens, (Path)Constants.kitten)).select(new QFamily((Expression<? extends Cat>)Constants.mother, (Expression<? extends Cat>)Constants.mate, (Expression<? extends Cat>)Constants.kitten)).parse();
    }

    @Test
    public void docoExamples95() throws Exception {
        ((QueryHelper)this.query().from((EntityPath)Constants.cat)).select((Expression<?>[])new Expression[]{Constants.cat.weight.avg(), Constants.cat.weight.sum(), Constants.cat.weight.max(), Constants.cat.count()}).parse();
    }

    @Test
    public void docoExamples96() throws Exception {
        ((QueryHelper)this.query().from((EntityPath)Constants.cat)).parse();
    }

    @Test
    public void docoExamples96_2() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from(new EntityPath[]{Constants.m, Constants.n})).where((Predicate)Constants.n.name.eq((Expression)Constants.m.name))).parse();
    }

    @Test
    @ExcludeIn(value={Target.ORACLE})
    public void docoExamples97() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from(new EntityPath[]{Constants.foo, Constants.bar})).where((Predicate)Constants.foo.startDate.eq(Constants.bar.date))).select(Constants.foo).parse();
    }

    @Test
    public void docoExamples97_2() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.mate.name.isNotNull())).parse();
    }

    @Test
    public void docoExamples97_3() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from(new EntityPath[]{Constants.cat, Constants.rival})).where((Predicate)Constants.cat.mate.eq((Expression)Constants.rival.mate))).parse();
    }

    @Test
    public void docoExamples97_4() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from(new EntityPath[]{Constants.cat, Constants.mate})).where((Predicate)Constants.cat.mate.eq((Expression)Constants.mate))).select((Expression<?>[])new Expression[]{Constants.cat, Constants.mate}).parse();
    }

    @Test
    public void docoExamples97_5() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.id.eq((Object)123))).parse();
    }

    @Test
    public void docoExamples97_6() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.mate.id.eq((Object)69))).parse();
    }

    @Test
    public void docoExamples97_7() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.person)).where(new Predicate[]{Constants.person.pid.country.eq((Object)"AU"), Constants.person.pid.medicareNumber.eq((Object)123456)})).parse();
    }

    @Test
    public void docoExamples97_8() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.account)).where((Predicate)Constants.account.owner.pid.medicareNumber.eq((Object)123456))).parse();
    }

    @Test
    public void docoExamples97_9() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.instanceOf(DomesticCat.class))).parse();
    }

    @Test
    @Ignore
    public void docoExamples97_10() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from(new EntityPath[]{Constants.log, Constants.payment})).where(new Predicate[]{Constants.log.item.instanceOf(Payment.class), Constants.log.item.id.eq(Constants.payment.id)})).parse();
    }

    @Test
    public void docoExamples97_10_2() throws Exception {
        ((QueryHelper)((QueryHelper)((QueryHelper)this.query().from(new EntityPath[]{Constants.log, Constants.payment})).innerJoin((EntityPath)Constants.log.item, (Path)Constants.item)).where(new Predicate[]{Constants.item.instanceOf(Payment.class), Constants.item.id.eq(Constants.payment.id)})).parse();
    }

    @Test
    public void docoExamples98_1() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.name.between((Comparable)((Object)"A"), (Comparable)((Object)"B")))).parse();
    }

    @Test
    public void docoExamples98_2() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.name.in((Object[])new String[]{"Foo", "Bar", "Baz"}))).parse();
    }

    @Test
    public void docoExamples98_3() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.name.notBetween((Comparable)((Object)"A"), (Comparable)((Object)"B")))).parse();
    }

    @Test
    public void docoExamples98_4() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.name.notIn((Object[])new String[]{"Foo", "Bar", "Baz"}))).parse();
    }

    @Test
    public void docoExamples98_5() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.kittens.size().gt((Number)0))).parse();
    }

    @Test
    public void docoExamples98_6() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from(new EntityPath[]{Constants.mother, Constants.kit})).select(Constants.mother).where((Predicate)Constants.kit.in((CollectionExpression)Constants.mother.kittens))).parse();
    }

    @Test
    @NoEclipseLink
    public void docoExamples98_7() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from(new EntityPath[]{Constants.list, Constants.p})).select(Constants.p).where((Predicate)Constants.p.name.eqAny(Constants.list.names))).parse();
    }

    @Test
    public void docoExamples98_8() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.kittens.isNotEmpty())).parse();
    }

    @Test
    public void docoExamples98_9() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from(new EntityPath[]{Constants.person, Constants.calendar})).select(Constants.person).where(new Predicate[]{Constants.calendar.holidays("national holiday").eq(Constants.person.birthDay), Constants.person.nationality.calendar.eq((Expression)Constants.calendar)})).parse();
    }

    @Test
    @ExcludeIn(value={Target.DERBY, Target.HSQLDB, Target.ORACLE})
    public void docoExamples98_10() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from(new EntityPath[]{Constants.item, Constants.ord})).select(Constants.item).where(new Predicate[]{Constants.ord.items((Expression<Integer>)Constants.ord.deliveredItemIndices(0)).eq((Expression)Constants.item), Constants.ord.id.eq((Object)1L)})).parse();
    }

    @Test
    @NoEclipseLink
    @ExcludeIn(value={Target.DERBY, Target.HSQLDB, Target.H2, Target.MYSQL, Target.ORACLE, Target.POSTGRESQL})
    @Ignore
    public void docoExamples98_11() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from(new EntityPath[]{Constants.item, Constants.ord})).select(Constants.item).where((Predicate)Constants.ord.items((Expression<Integer>)Constants.ord.items.size().subtract((Number)1)).eq((Expression)Constants.item))).parse();
    }

    @Test
    @NoEclipseLink
    @NoOpenJPA
    @NoBatooJPA
    @ExcludeIn(value={Target.DERBY, Target.HSQLDB, Target.ORACLE})
    public void docoExamples98_12() throws Exception {
        ((QueryHelper)((QueryHelper)((QueryHelper)this.query().from(new EntityPath[]{Constants.prod, Constants.store})).innerJoin((CollectionExpression)Constants.store.customers, (Path)Constants.cust)).select(Constants.cust).where(new Predicate[]{Constants.prod.name.eq((Object)"widget"), Constants.store.location.name.in((Object[])new String[]{"Melbourne", "Sydney"}), Constants.prod.eqAll((CollectionExpression)Constants.cust.currentOrder.lineItems)})).parse();
    }

    @Test
    public void docoExamples98() throws Exception {
        Constants.prod.eq(new Product());
        Constants.prod.eq((Expression)new QProduct("p"));
        Constants.prod.eq((Expression)new QItem("p"));
    }

    @Test
    public void docoExamples99() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).orderBy(new OrderSpecifier[]{Constants.cat.name.asc(), Constants.cat.weight.desc(), Constants.cat.birthdate.asc()})).parse();
    }

    @Test
    public void doubleLiteral() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.weight.lt((Number)3))).parse();
    }

    @Test
    public void doubleLiteral2() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.weight.gt((Number)3141))).parse();
    }

    @Test
    @NoOpenJPA
    public void fetch() throws RecognitionException, TokenStreamException {
        ((QueryHelper)((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).innerJoin((EntityPath)Constants.cat.mate, (Path)Constants.mate)).fetchJoin()).parse();
    }

    @Test
    @NoOpenJPA
    public void fetch2() throws RecognitionException, TokenStreamException {
        ((QueryHelper)((QueryHelper)((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).innerJoin((EntityPath)Constants.cat.mate, (Path)Constants.mate)).fetchJoin()).fetchJoin()).parse();
    }

    @Test
    public void in() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.foo)).where((Predicate)Constants.foo.bar.in((Object[])new String[]{"a", "b", "c"}))).parse();
    }

    @Test
    public void notIn() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.foo)).where((Predicate)Constants.foo.bar.notIn((Object[])new String[]{"a", "b", "c"}))).parse();
    }

    @Test
    @NoEclipseLink
    @NoOpenJPA
    public void joinFlags1() throws RecognitionException, TokenStreamException {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).fetchAll()).parse();
    }

    @Test
    @NoEclipseLink
    @NoOpenJPA
    @NoBatooJPA
    public void joinFlags2() throws RecognitionException, TokenStreamException {
        ((QueryHelper)((QueryHelper)((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).fetchAll()).from((EntityPath)Constants.cat1)).fetchAll()).parse();
    }

    @Test
    @NoEclipseLink
    @NoOpenJPA
    @NoBatooJPA
    public void joinFlags3() throws RecognitionException, TokenStreamException {
        ((QueryHelper)((QueryHelper)((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).fetchAll()).from((EntityPath)Constants.cat1)).fetchAll()).parse();
    }

    @Test
    public void joins() throws RecognitionException, TokenStreamException {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).join((EntityPath)Constants.cat.mate, (Path)Constants.mate)).select(Constants.cat).parse();
    }

    @Test
    public void innerJoin() throws RecognitionException, TokenStreamException {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).innerJoin((EntityPath)Constants.cat.mate, (Path)Constants.mate)).select(Constants.cat).parse();
    }

    @Test
    public void leftJoin() throws RecognitionException, TokenStreamException {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).leftJoin((EntityPath)Constants.cat.mate, (Path)Constants.mate)).select(Constants.cat).parse();
    }

    @Test
    @NoOpenJPA
    @NoBatooJPA
    public void joins2() throws RecognitionException, TokenStreamException {
        ((QueryHelper)((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).join((EntityPath)Constants.cat.mate, (Path)Constants.mate)).on((Predicate)Constants.mate.name.eq((Object)"Bob"))).parse();
    }

    @Test
    public void multipleFromClasses() throws Exception {
        ((QueryHelper)this.query().from(new EntityPath[]{Constants.qat, Constants.foo})).parse();
    }

    @Test
    public void serialization() {
        QueryHelper<?> query = this.query();
        query.from((EntityPath)Constants.cat);
        Assert.assertEquals((Object)"select cat\nfrom Cat cat", (Object)query.toString());
        query.from((EntityPath)Constants.fatcat);
        Assert.assertEquals((Object)"select cat\nfrom Cat cat, Cat fatcat", (Object)query.toString());
    }

    @Test
    @NoEclipseLink
    @NoOpenJPA
    @ExcludeIn(value={Target.MYSQL})
    public void casts_byte() throws Exception {
        NumberPath<Double> bw = Constants.cat.bodyWeight;
        ((QueryHelper)this.query().from((EntityPath)Constants.cat)).select(bw.byteValue()).parse();
    }

    @Test
    @NoOpenJPA
    public void casts_double() throws Exception {
        NumberPath<Double> bw = Constants.cat.bodyWeight;
        ((QueryHelper)this.query().from((EntityPath)Constants.cat)).select(bw.doubleValue()).parse();
    }

    @Test
    @NoOpenJPA
    @ExcludeIn(value={Target.MYSQL})
    public void casts_float() throws Exception {
        NumberPath<Double> bw = Constants.cat.bodyWeight;
        ((QueryHelper)this.query().from((EntityPath)Constants.cat)).select(bw.floatValue()).parse();
    }

    @Test
    @NoOpenJPA
    @ExcludeIn(value={Target.MYSQL})
    public void casts_int() throws Exception {
        NumberPath<Double> bw = Constants.cat.bodyWeight;
        ((QueryHelper)this.query().from((EntityPath)Constants.cat)).select(bw.intValue()).parse();
    }

    @Test
    @NoOpenJPA
    @ExcludeIn(value={Target.DERBY, Target.HSQLDB, Target.MYSQL})
    public void casts_long() throws Exception {
        NumberPath<Double> bw = Constants.cat.bodyWeight;
        ((QueryHelper)this.query().from((EntityPath)Constants.cat)).select(bw.longValue()).parse();
    }

    @Test
    @NoEclipseLink
    @NoOpenJPA
    @ExcludeIn(value={Target.MYSQL})
    public void casts_short() throws Exception {
        NumberPath<Double> bw = Constants.cat.bodyWeight;
        ((QueryHelper)this.query().from((EntityPath)Constants.cat)).select(bw.shortValue()).parse();
    }

    @Test
    @NoOpenJPA
    @ExcludeIn(value={Target.DERBY, Target.HSQLDB, Target.MYSQL})
    public void casts_string() throws Exception {
        NumberPath<Double> bw = Constants.cat.bodyWeight;
        ((QueryHelper)this.query().from((EntityPath)Constants.cat)).select(bw.stringValue()).parse();
    }

    @Test
    @NoEclipseLink
    @NoOpenJPA
    @ExcludeIn(value={Target.MYSQL})
    public void casts_2() throws Exception {
        NumberPath<Double> bw = Constants.cat.bodyWeight;
        ((QueryHelper)this.query().from((EntityPath)Constants.cat)).select(bw.castToNum(Byte.class)).parse();
    }

    @Test
    @Ignore
    public void groupBy() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.qat)).groupBy((Expression)Constants.qat.breed)).parse();
    }

    @Test
    @Ignore
    public void groupBy_2() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.qat)).groupBy(new Expression[]{Constants.qat.breed, Constants.qat.eyecolor})).parse();
    }

    @Test
    public void not() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.kittens.size().lt((Number)1).not())).parse();
    }

    @Test
    public void not_2() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.kittens.size().gt((Number)1).not())).parse();
    }

    @Test
    public void not_3() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.kittens.size().goe((Number)1).not())).parse();
    }

    @Test
    public void not_4() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.kittens.size().loe((Number)1).not())).parse();
    }

    @Test
    public void not_5() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.name.between((Comparable)((Object)"A"), (Comparable)((Object)"B")).not())).parse();
    }

    @Test
    public void not_6() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.name.notBetween((Comparable)((Object)"A"), (Comparable)((Object)"B")).not())).parse();
    }

    @Test
    public void not_7() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.kittens.size().loe((Number)1).not().not())).parse();
    }

    @Test
    public void not_8() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.kittens.size().loe((Number)1).not().not().not())).parse();
    }

    @Test
    @Ignore
    public void orderBy() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.qat)).orderBy(Constants.qat.toes.avg().asc())).parse();
    }

    @Test
    @NoOpenJPA
    public void orderBy_2() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.an)).orderBy(Constants.an.bodyWeight.sqrt().divide((Number)2.0).asc())).parse();
    }

    @Test
    public void select1() throws Exception {
        ((QueryHelper)this.query().from((EntityPath)Constants.qat)).select(Constants.qat.weight.avg()).parse();
    }

    @Test
    @Ignore
    public void sum() throws RecognitionException, TokenStreamException {
        ((QueryHelper)this.query().from((EntityPath)Constants.cat)).select(Constants.cat.kittens.size().sum()).parse();
    }

    @Test
    @Ignore
    public void sum_2() throws RecognitionException, TokenStreamException {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.kittens.size().sum().gt((Number)0))).select(Constants.cat).parse();
    }

    @Test
    public void sum_3() throws RecognitionException, TokenStreamException {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.kittens.isEmpty())).select(Constants.cat).parse();
    }

    @Test
    public void sum_4() throws RecognitionException, TokenStreamException {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.cat)).where((Predicate)Constants.cat.kittens.isNotEmpty())).select(Constants.cat).parse();
    }

    @Test
    public void where() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.qat)).where((Predicate)Constants.qat.name.in((Object[])new String[]{"crater", "bean", "fluffy"}))).parse();
    }

    @Test
    public void where_2() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.qat)).where((Predicate)Constants.qat.name.notIn((Object[])new String[]{"crater", "bean", "fluffy"}))).parse();
    }

    @Test
    public void where_3() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.an)).where((Predicate)Constants.an.bodyWeight.sqrt().gt((Number)10.0))).parse();
    }

    @Test
    public void where_4() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.an)).where((Predicate)Constants.an.bodyWeight.sqrt().divide((Number)2.0).gt((Number)10.0))).parse();
    }

    @Test
    public void where_5() throws Exception {
        ((QueryHelper)((QueryHelper)this.query().from((EntityPath)Constants.an)).where(new Predicate[]{Constants.an.bodyWeight.gt((Number)10), Constants.an.bodyWeight.lt((Number)100).or((Predicate)Constants.an.bodyWeight.isNull())})).parse();
    }
}

