/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.domain.QCat;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberOperation;
import com.querydsl.core.types.dsl.StringOperation;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.jpa.AbstractQueryTest;
import com.querydsl.jpa.Constants;
import org.junit.Test;

public class StringOperationsTest
extends AbstractQueryTest {
    @Test
    public void stringConcatenations() {
        StringOperationsTest.assertToString("concat(cat.name,kitten.name)", Constants.cat.name.concat((Expression)Constants.kitten.name));
    }

    @Test
    public void stringConversionOperations() {
        StringOperationsTest.assertToString("str(cat.bodyWeight)", Constants.cat.bodyWeight.stringValue());
    }

    @Test
    public void stringOperationsInFunctionalWay() {
        StringOperationsTest.assertToString("concat(cat.name,cust.name.firstName)", Constants.cat.name.concat((Expression)Constants.cust.name.firstName));
        StringOperationsTest.assertToString("lower(cat.name)", Constants.cat.name.lower());
    }

    @Test
    public void indexOf() {
        StringPath path = QCat.cat.name;
        Expression startIndex = Expressions.constant((Object)0);
        NumberOperation endIndex = Expressions.numberOperation(Integer.class, (Operator)Ops.INDEX_OF, (Expression[])new Expression[]{path, Expressions.constant((Object)"x")});
        StringOperation substr = Expressions.stringOperation((Operator)Ops.SUBSTR_2ARGS, (Expression[])new Expression[]{path, startIndex, endIndex});
        StringOperationsTest.assertToString("substring(cat.name,1,locate(?1,cat.name)-1 - ?2)", substr);
    }

    @Test
    public void indexOf2() {
        StringPath str = QCat.cat.name;
        StringOperationsTest.assertToString("substring(cat.name,1,locate(?1,cat.name)-1 - ?2)", str.substring(0, (Expression)str.indexOf("x")));
    }

    @Test
    public void indexOf3() {
        StringOperationsTest.assertToString("substring(cat.name,2,1)", QCat.cat.name.substring(1, 2));
    }
}

