/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.jpa.AbstractQueryTest;
import com.querydsl.jpa.Constants;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.domain.QCat;
import com.querydsl.jpa.domain.QEmployee;
import com.querydsl.jpa.domain.QUser;
import org.junit.Assert;
import org.junit.Test;

public class SubQueryTest
extends AbstractQueryTest {
    @Test
    public void single_source() {
        JPQLQuery query = JPAExpressions.selectFrom((EntityPath)Constants.cat);
        Assert.assertEquals((Object)"select cat\nfrom Cat cat", (Object)query.toString());
    }

    @Test
    public void multiple_sources() {
        JPQLQuery query = JPAExpressions.select((Expression)Constants.cat).from(new EntityPath[]{Constants.cat, Constants.fatcat});
        Assert.assertEquals((Object)"select cat\nfrom Cat cat, Cat fatcat", (Object)query.toString());
    }

    @Test
    public void in() {
        Constants.cat.in((SubQueryExpression)JPAExpressions.selectFrom((EntityPath)Constants.cat));
    }

    @Test
    public void innerJoin() {
        Assert.assertEquals((Object)"select cat\nfrom Cat cat\n  inner join cat.mate", (Object)JPAExpressions.selectFrom((EntityPath)Constants.cat).innerJoin((EntityPath)Constants.cat.mate).toString());
    }

    @Test
    public void innerJoin2() {
        QEmployee employee = QEmployee.employee;
        QUser user = QUser.user;
        Assert.assertEquals((Object)"select employee\nfrom Employee employee\n  inner join employee.user as user", (Object)JPAExpressions.selectFrom((EntityPath)employee).innerJoin((EntityPath)employee.user, (Path)user).toString());
    }

    @Test
    public void leftJoin() {
        Assert.assertEquals((Object)"select cat\nfrom Cat cat\n  left join cat.mate", (Object)JPAExpressions.selectFrom((EntityPath)Constants.cat).leftJoin((EntityPath)Constants.cat.mate).toString());
    }

    @Test
    public void join() {
        Assert.assertEquals((Object)"select cat\nfrom Cat cat\n  inner join cat.mate", (Object)JPAExpressions.selectFrom((EntityPath)Constants.cat).join((EntityPath)Constants.cat.mate).toString());
    }

    @Test
    public void uniqueProjection() {
        SubQueryTest.assertToString("(select cat from Cat cat)", JPAExpressions.selectFrom((EntityPath)Constants.cat));
    }

    @Test
    public void listProjection() {
        SubQueryTest.assertToString("(select cat from Cat cat)", JPAExpressions.selectFrom((EntityPath)Constants.cat));
    }

    @Test
    public void listContains() {
        SubQueryTest.assertToString("cat in (select cat from Cat cat)", Constants.cat.in((SubQueryExpression)JPAExpressions.selectFrom((EntityPath)Constants.cat)));
    }

    @Test
    public void exists() {
        SubQueryTest.assertToString("exists (select 1 from Cat cat)", JPAExpressions.selectOne().from(new EntityPath[]{Constants.cat}).exists());
    }

    @Test
    public void exists_where() {
        SubQueryTest.assertToString("exists (select 1 from Cat cat where cat.weight < ?1)", ((JPQLQuery)JPAExpressions.selectFrom((EntityPath)Constants.cat).where(new Predicate[]{Constants.cat.weight.lt((Number)1)})).exists());
    }

    @Test
    public void exists_via_unique() {
        SubQueryTest.assertToString("exists (select 1 from Cat cat where cat.weight < ?1)", ((JPQLQuery)JPAExpressions.selectOne().from(new EntityPath[]{Constants.cat}).where(new Predicate[]{Constants.cat.weight.lt((Number)1)})).exists());
    }

    @Test
    public void notExists() {
        SubQueryTest.assertToString("not exists (select 1 from Cat cat)", JPAExpressions.selectOne().from(new EntityPath[]{Constants.cat}).notExists());
    }

    @Test
    public void notExists_where() {
        SubQueryTest.assertToString("not exists (select 1 from Cat cat where cat.weight < ?1)", ((JPQLQuery)JPAExpressions.selectOne().from(new EntityPath[]{Constants.cat}).where(new Predicate[]{Constants.cat.weight.lt((Number)1)})).notExists());
    }

    @Test
    public void notExists_via_unique() {
        SubQueryTest.assertToString("not exists (select 1 from Cat cat where cat.weight < ?1)", ((JPQLQuery)JPAExpressions.selectOne().from(new EntityPath[]{Constants.cat}).where(new Predicate[]{Constants.cat.weight.lt((Number)1)})).notExists());
    }

    @Test
    public void count() {
        SubQueryTest.assertToString("(select count(cat) from Cat cat)", JPAExpressions.select((Expression)Constants.cat.count()).from(new EntityPath[]{Constants.cat}));
    }

    @Test
    public void count_via_list() {
        SubQueryTest.assertToString("(select count(cat) from Cat cat)", JPAExpressions.select((Expression)Constants.cat.count()).from(new EntityPath[]{Constants.cat}));
    }

    @Test
    public void count_name() {
        SubQueryTest.assertToString("(select count(cat.name) from Cat cat)", JPAExpressions.select((Expression)Constants.cat.name.count()).from(new EntityPath[]{Constants.cat}));
    }

    @Test
    public void count_multiple_sources() {
        com.querydsl.core.domain.QCat other = new com.querydsl.core.domain.QCat("other");
        SubQueryTest.assertToString("(select count(cat) from Cat cat, Cat other)", JPAExpressions.select((Expression)Constants.cat.count()).from(new EntityPath[]{Constants.cat, other}));
    }

    @Test
    public void count_multiple_sources_via_list() {
        com.querydsl.core.domain.QCat other = new com.querydsl.core.domain.QCat("other");
        SubQueryTest.assertToString("(select count(cat) from Cat cat, Cat other)", JPAExpressions.select((Expression)Constants.cat.count()).from(new EntityPath[]{Constants.cat, other}));
    }

    @Test
    public void indexed_access() {
        SubQueryTest.assertMatches("\\(select count\\(cat\\) from Cat cat   left join cat.kittens as cat_kittens_\\w+ with index\\(cat_kittens_\\w+\\) = \\?1 where cat_kittens_\\w+.name = \\?2\\)", (Expression)JPAExpressions.select((Expression)Constants.cat.count()).from(new EntityPath[]{Constants.cat}).where(new Predicate[]{((QCat)Constants.cat.kittens.get((int)0)).name.eq((Object)"Kate")}));
    }

    @Test
    public void indexed_access_without_constant() {
        SubQueryTest.assertMatches("\\(select count\\(cat\\) from Cat cat   left join cat.kittens as cat_kittens_\\w+ with index\\(cat_kittens_\\w+\\) = cat.id where cat_kittens_\\w+.name = \\?1\\)", (Expression)JPAExpressions.select((Expression)Constants.cat.count()).from(new EntityPath[]{Constants.cat}).where(new Predicate[]{((QCat)Constants.cat.kittens.get(Constants.cat.id)).name.eq((Object)"Kate")}));
    }

    @Test
    public void indexOf() {
        SubQueryTest.assertToString("(select count(cat) from Cat cat where locate(?1,cat.name)-1 = ?2)", (Expression)JPAExpressions.select((Expression)Constants.cat.count()).from(new EntityPath[]{Constants.cat}).where(new Predicate[]{Constants.cat.name.indexOf("a").eq((Object)1)}));
    }
}

