/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.domain;

import com.querydsl.jpa.domain.Animal;
import com.querydsl.jpa.domain.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;

@Entity
@DiscriminatorValue(value="C")
public class Cat
extends Animal {
    private int breed;
    private Color eyecolor;
    @OneToMany
    @JoinTable(name="kittens", joinColumns={@JoinColumn(name="cat_id")}, inverseJoinColumns={@JoinColumn(name="kitten_id")})
    @OrderColumn(name="ind")
    private List<Cat> kittens = new ArrayList<Cat>();
    @OneToMany
    @JoinTable(name="kittens_set", joinColumns={@JoinColumn(name="cat_id")}, inverseJoinColumns={@JoinColumn(name="kitten_id")})
    private Set<Cat> kittensSet;
    @ManyToOne
    private Cat mate;

    public Cat() {
    }

    public Cat(int id) {
        this.setId(id);
    }

    public Cat(String name, int id) {
        this.setId(id);
        this.setName(name);
    }

    public Cat(String name, int id, Color color) {
        this.setId(id);
        this.setName(name);
        this.setColor(color);
    }

    public Cat(String name, int id, List<Cat> k) {
        this.setId(id);
        this.setName(name);
        this.kittens.addAll(k);
    }

    public Cat(String name, int id, double bodyWeight) {
        this(name, id);
        this.setBodyWeight(bodyWeight);
        this.setFloatProperty((float)bodyWeight);
    }

    public int getBreed() {
        return this.breed;
    }

    public Color getEyecolor() {
        return this.eyecolor;
    }

    public List<Cat> getKittens() {
        return this.kittens;
    }

    public Cat getMate() {
        return this.mate;
    }

    public void addKitten(Cat kitten) {
        this.kittens.add(kitten);
    }

    public Set<Cat> getKittensSet() {
        return this.kittensSet;
    }

    public void setKittensSet(Set<Cat> kittensSet) {
        this.kittensSet = kittensSet;
    }

    public void setMate(Cat mate) {
        this.mate = mate;
    }
}

