/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.maven;

import com.mysema.codegen.model.SimpleType;
import com.querydsl.codegen.BeanSerializer;
import com.querydsl.codegen.Serializer;
import com.querydsl.maven.NumericMapping;
import com.querydsl.maven.RenameMapping;
import com.querydsl.maven.TypeMapping;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.codegen.DefaultNamingStrategy;
import com.querydsl.sql.codegen.MetaDataExporter;
import com.querydsl.sql.codegen.NamingStrategy;
import com.querydsl.sql.types.Type;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Comparator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class AbstractMetaDataExportMojo
extends AbstractMojo {
    private MavenProject project;
    private String jdbcDriver;
    private String jdbcUrl;
    private String jdbcUser;
    private String jdbcPassword;
    private String namePrefix;
    private String nameSuffix;
    private String beanPrefix;
    private String beanSuffix;
    private String packageName;
    private String beanPackageName;
    private String schemaPattern;
    private String tableNamePattern;
    private String targetFolder;
    private String namingStrategyClass;
    private String beanSerializerClass;
    private String serializerClass;
    private boolean exportBeans;
    private String[] beanInterfaces;
    private boolean beanAddToString;
    private boolean beanAddFullConstructor;
    private boolean beanPrintSupertype;
    private boolean innerClassesForKeys;
    private boolean validationAnnotations;
    private boolean columnAnnotations;
    private String[] customTypes;
    private TypeMapping[] typeMappings;
    private NumericMapping[] numericMappings;
    private RenameMapping[] renameMappings;
    private boolean createScalaSources;
    private boolean schemaToPackage;
    private boolean lowerCase;
    private boolean exportTables;
    private boolean exportViews;
    private boolean exportAll;
    private boolean exportPrimaryKeys;
    private boolean exportForeignKeys;
    private String columnComparatorClass;
    private boolean spatial;
    private String tableTypesToExport;
    private String[] imports;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isForTest()) {
            this.project.addTestCompileSourceRoot(this.targetFolder);
        } else {
            this.project.addCompileSourceRoot(this.targetFolder);
        }
        try {
            String sourceEncoding;
            Configuration configuration = new Configuration(SQLTemplates.DEFAULT);
            Object namingStrategy = this.namingStrategyClass != null ? (NamingStrategy)Class.forName(this.namingStrategyClass).newInstance() : new DefaultNamingStrategy();
            if (this.createScalaSources) {
                if (this.serializerClass == null) {
                    this.serializerClass = "com.querydsl.scala.sql.ScalaMetaDataSerializer";
                }
                if (this.exportBeans && this.beanSerializerClass == null) {
                    this.beanSerializerClass = "com.querydsl.scala.ScalaBeanSerializer";
                }
            }
            MetaDataExporter exporter = new MetaDataExporter();
            if (this.namePrefix != null) {
                exporter.setNamePrefix(this.namePrefix);
            }
            if (this.nameSuffix != null) {
                exporter.setNameSuffix(this.nameSuffix);
            }
            if (this.beanPrefix != null) {
                exporter.setBeanPrefix(this.beanPrefix);
            }
            if (this.beanSuffix != null) {
                exporter.setBeanSuffix(this.beanSuffix);
            }
            exporter.setCreateScalaSources(this.createScalaSources);
            exporter.setPackageName(this.packageName);
            exporter.setBeanPackageName(this.beanPackageName);
            exporter.setInnerClassesForKeys(this.innerClassesForKeys);
            exporter.setTargetFolder(new File(this.targetFolder));
            exporter.setNamingStrategy((NamingStrategy)namingStrategy);
            exporter.setSchemaPattern(this.schemaPattern);
            exporter.setTableNamePattern(this.tableNamePattern);
            exporter.setColumnAnnotations(this.columnAnnotations);
            exporter.setValidationAnnotations(this.validationAnnotations);
            exporter.setSchemaToPackage(this.schemaToPackage);
            exporter.setLowerCase(this.lowerCase);
            exporter.setExportTables(this.exportTables);
            exporter.setExportViews(this.exportViews);
            exporter.setExportAll(this.exportAll);
            exporter.setTableTypesToExport(this.tableTypesToExport);
            exporter.setExportPrimaryKeys(this.exportPrimaryKeys);
            exporter.setExportForeignKeys(this.exportForeignKeys);
            exporter.setSpatial(this.spatial);
            if (this.imports != null && this.imports.length > 0) {
                exporter.setImports(this.imports);
            }
            if (this.serializerClass != null) {
                try {
                    exporter.setSerializerClass(Class.forName(this.serializerClass));
                }
                catch (ClassNotFoundException e) {
                    this.getLog().error((Throwable)e);
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            if (this.exportBeans) {
                if (this.beanSerializerClass != null) {
                    exporter.setBeanSerializerClass(Class.forName(this.beanSerializerClass));
                } else {
                    BeanSerializer serializer = new BeanSerializer();
                    if (this.beanInterfaces != null) {
                        for (String string : this.beanInterfaces) {
                            int sepIndex = string.lastIndexOf(46);
                            if (sepIndex < 0) {
                                serializer.addInterface((com.mysema.codegen.model.Type)new SimpleType(string));
                                continue;
                            }
                            String packageName = string.substring(0, sepIndex);
                            String simpleName = string.substring(sepIndex + 1);
                            serializer.addInterface((com.mysema.codegen.model.Type)new SimpleType(string, packageName, simpleName, new com.mysema.codegen.model.Type[0]));
                        }
                    }
                    serializer.setAddFullConstructor(this.beanAddFullConstructor);
                    serializer.setAddToString(this.beanAddToString);
                    serializer.setPrintSupertype(this.beanPrintSupertype);
                    exporter.setBeanSerializer((Serializer)serializer);
                }
            }
            if ((sourceEncoding = (String)this.project.getProperties().get("project.build.sourceEncoding")) != null) {
                exporter.setSourceEncoding(sourceEncoding);
            }
            if (this.customTypes != null) {
                for (String string : this.customTypes) {
                    configuration.register((Type)Class.forName(string).newInstance());
                }
            }
            if (this.typeMappings != null) {
                for (TypeMapping typeMapping : this.typeMappings) {
                    typeMapping.apply(configuration);
                }
            }
            if (this.numericMappings != null) {
                for (NumericMapping numericMapping : this.numericMappings) {
                    numericMapping.apply(configuration);
                }
            }
            if (this.renameMappings != null) {
                for (RenameMapping renameMapping : this.renameMappings) {
                    renameMapping.apply(configuration);
                }
            }
            if (this.columnComparatorClass != null) {
                try {
                    exporter.setColumnComparatorClass(Class.forName(this.columnComparatorClass).asSubclass(Comparator.class));
                }
                catch (ClassNotFoundException e) {
                    this.getLog().error((Throwable)e);
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            exporter.setConfiguration(configuration);
            Class.forName(this.jdbcDriver);
            Connection conn = DriverManager.getConnection(this.jdbcUrl, this.jdbcUser, this.jdbcPassword);
            try {
                exporter.export(conn.getMetaData());
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (SQLException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected boolean isForTest() {
        return false;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    public void setBeanInterfaces(String[] beanInterfaces) {
        this.beanInterfaces = beanInterfaces;
    }

    public void setBeanPrefix(String beanPrefix) {
        this.beanPrefix = beanPrefix;
    }

    public void setBeanSuffix(String beanSuffix) {
        this.beanSuffix = beanSuffix;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setBeanPackageName(String beanPackageName) {
        this.beanPackageName = beanPackageName;
    }

    public void setSchemaPattern(String schemaPattern) {
        this.schemaPattern = schemaPattern;
    }

    public void setTableNamePattern(String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    public void setNamingStrategyClass(String namingStrategyClass) {
        this.namingStrategyClass = namingStrategyClass;
    }

    public void setBeanSerializerClass(String beanSerializerClass) {
        this.beanSerializerClass = beanSerializerClass;
    }

    public void setSerializerClass(String serializerClass) {
        this.serializerClass = serializerClass;
    }

    public void setExportBeans(boolean exportBeans) {
        this.exportBeans = exportBeans;
    }

    public void setInnerClassesForKeys(boolean innerClassesForKeys) {
        this.innerClassesForKeys = innerClassesForKeys;
    }

    public void setValidationAnnotations(boolean validationAnnotations) {
        this.validationAnnotations = validationAnnotations;
    }

    public void setColumnAnnotations(boolean columnAnnotations) {
        this.columnAnnotations = columnAnnotations;
    }

    public void setCustomTypes(String[] customTypes) {
        this.customTypes = customTypes;
    }

    public void setCreateScalaSources(boolean createScalaSources) {
        this.createScalaSources = createScalaSources;
    }

    public void setSchemaToPackage(boolean schemaToPackage) {
        this.schemaToPackage = schemaToPackage;
    }

    public void setLowerCase(boolean lowerCase) {
        this.lowerCase = lowerCase;
    }

    public void setTypeMappings(TypeMapping[] typeMappings) {
        this.typeMappings = typeMappings;
    }

    public void setNumericMappings(NumericMapping[] numericMappings) {
        this.numericMappings = numericMappings;
    }

    public void setRenameMappings(RenameMapping[] renameMappings) {
        this.renameMappings = renameMappings;
    }

    public void setImports(String[] imports) {
        this.imports = imports;
    }
}

