/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.maven;

import com.querydsl.codegen.BeanSerializer;
import com.querydsl.codegen.Serializer;
import com.querydsl.codegen.utils.model.SimpleType;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.core.util.StringUtils;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.codegen.DefaultNamingStrategy;
import com.querydsl.sql.codegen.MetaDataExporter;
import com.querydsl.sql.codegen.NamingStrategy;
import com.querydsl.sql.codegen.support.NumericMapping;
import com.querydsl.sql.codegen.support.RenameMapping;
import com.querydsl.sql.codegen.support.TypeMapping;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.authentication.AuthenticationInfo;

public class AbstractMetaDataExportMojo
extends AbstractMojo {
    private MavenProject project;
    private WagonManager wagonManager;
    private String server;
    private String jdbcDriver;
    private String jdbcUrl;
    private String jdbcUser;
    private String jdbcPassword;
    private String namePrefix;
    private String nameSuffix;
    private String beanPrefix;
    private String beanSuffix;
    private String packageName;
    private String beanPackageName;
    private String schemaPattern;
    private String catalogPattern;
    private String tableNamePattern;
    private String targetFolder;
    private String beansTargetFolder;
    private String namingStrategyClass;
    private String beanSerializerClass;
    private String serializerClass;
    private boolean exportBeans;
    private String[] beanInterfaces;
    private boolean beanAddToString;
    private boolean beanAddFullConstructor;
    private boolean beanPrintSupertype;
    private boolean innerClassesForKeys;
    private boolean validationAnnotations;
    private boolean columnAnnotations;
    private String[] customTypes;
    private TypeMapping[] typeMappings;
    private NumericMapping[] numericMappings;
    private RenameMapping[] renameMappings;
    private boolean createScalaSources;
    private boolean schemaToPackage;
    private boolean lowerCase;
    private boolean exportTables;
    private boolean exportViews;
    private boolean exportAll;
    private boolean exportPrimaryKeys;
    private boolean exportForeignKeys;
    private boolean exportDirectForeignKeys;
    private boolean exportInverseForeignKeys;
    private String columnComparatorClass;
    private boolean spatial;
    private String tableTypesToExport;
    private String[] imports;
    private boolean skip;
    private String generatedAnnotationClass;
    private static final Pattern BLANK_VALUE_PATTERN = Pattern.compile("(^|,)BLANK(,|$)", 2);
    private static final String BLANK_VALUE_REPLACEMENT = "$1$2";

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isForTest()) {
            this.project.addTestCompileSourceRoot(this.targetFolder);
        } else {
            this.project.addCompileSourceRoot(this.targetFolder);
        }
        if (this.skip) {
            return;
        }
        try {
            String password;
            String user;
            String sourceEncoding;
            Configuration configuration = new Configuration(SQLTemplates.DEFAULT);
            Object namingStrategy = this.namingStrategyClass != null ? (NamingStrategy)Class.forName(this.namingStrategyClass).newInstance() : new DefaultNamingStrategy();
            if (this.createScalaSources) {
                if (this.serializerClass == null) {
                    this.serializerClass = "com.querydsl.scala.sql.ScalaMetaDataSerializer";
                }
                if (this.exportBeans && this.beanSerializerClass == null) {
                    this.beanSerializerClass = "com.querydsl.scala.ScalaBeanSerializer";
                }
            }
            MetaDataExporter exporter = new MetaDataExporter();
            exporter.setNamePrefix(AbstractMetaDataExportMojo.emptyIfSetToBlank(this.namePrefix));
            exporter.setNameSuffix(StringUtils.nullToEmpty((String)this.nameSuffix));
            exporter.setBeanPrefix(StringUtils.nullToEmpty((String)this.beanPrefix));
            exporter.setBeanSuffix(StringUtils.nullToEmpty((String)this.beanSuffix));
            if (this.beansTargetFolder != null) {
                exporter.setBeansTargetFolder(new File(this.beansTargetFolder));
            }
            exporter.setCreateScalaSources(this.createScalaSources);
            exporter.setPackageName(this.packageName);
            exporter.setBeanPackageName(this.beanPackageName);
            exporter.setInnerClassesForKeys(this.innerClassesForKeys);
            exporter.setTargetFolder(new File(this.targetFolder));
            exporter.setNamingStrategy((NamingStrategy)namingStrategy);
            exporter.setCatalogPattern(this.catalogPattern);
            exporter.setSchemaPattern(AbstractMetaDataExportMojo.processBlankValues(this.schemaPattern));
            exporter.setTableNamePattern(this.tableNamePattern);
            exporter.setColumnAnnotations(this.columnAnnotations);
            exporter.setValidationAnnotations(this.validationAnnotations);
            exporter.setSchemaToPackage(this.schemaToPackage);
            exporter.setLowerCase(this.lowerCase);
            exporter.setExportTables(this.exportTables);
            exporter.setExportViews(this.exportViews);
            exporter.setExportAll(this.exportAll);
            exporter.setTableTypesToExport(this.tableTypesToExport);
            exporter.setExportPrimaryKeys(this.exportPrimaryKeys);
            exporter.setExportForeignKeys(this.exportForeignKeys);
            exporter.setExportDirectForeignKeys(this.exportDirectForeignKeys);
            exporter.setExportInverseForeignKeys(this.exportInverseForeignKeys);
            exporter.setSpatial(this.spatial);
            exporter.setGeneratedAnnotationClass(this.generatedAnnotationClass);
            if (this.imports != null && this.imports.length > 0) {
                exporter.setImports(this.imports);
            }
            if (this.serializerClass != null) {
                try {
                    exporter.setSerializerClass(Class.forName(this.serializerClass));
                }
                catch (ClassNotFoundException e) {
                    this.getLog().error((Throwable)e);
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            if (this.exportBeans) {
                if (this.beanSerializerClass != null) {
                    exporter.setBeanSerializerClass(Class.forName(this.beanSerializerClass));
                } else {
                    BeanSerializer serializer = new BeanSerializer();
                    if (this.beanInterfaces != null) {
                        for (String string : this.beanInterfaces) {
                            int sepIndex = string.lastIndexOf(46);
                            if (sepIndex < 0) {
                                serializer.addInterface((Type)new SimpleType(string));
                                continue;
                            }
                            String packageName = string.substring(0, sepIndex);
                            String simpleName = string.substring(sepIndex + 1);
                            serializer.addInterface((Type)new SimpleType(string, packageName, simpleName, new Type[0]));
                        }
                    }
                    serializer.setAddFullConstructor(this.beanAddFullConstructor);
                    serializer.setAddToString(this.beanAddToString);
                    serializer.setPrintSupertype(this.beanPrintSupertype);
                    exporter.setBeanSerializer((Serializer)serializer);
                }
            }
            if ((sourceEncoding = (String)this.project.getProperties().get("project.build.sourceEncoding")) != null) {
                exporter.setSourceEncoding(sourceEncoding);
            }
            if (this.customTypes != null) {
                for (String string : this.customTypes) {
                    configuration.register((com.querydsl.sql.types.Type)Class.forName(string).newInstance());
                }
            }
            if (this.typeMappings != null) {
                for (String string : this.typeMappings) {
                    string.apply(configuration);
                }
            }
            if (this.numericMappings != null) {
                for (String string : this.numericMappings) {
                    string.apply(configuration);
                }
            }
            if (this.renameMappings != null) {
                for (String string : this.renameMappings) {
                    string.apply(configuration);
                }
            }
            if (this.columnComparatorClass != null) {
                try {
                    exporter.setColumnComparatorClass(Class.forName(this.columnComparatorClass).asSubclass(Comparator.class));
                }
                catch (ClassNotFoundException e) {
                    this.getLog().error((Throwable)e);
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            exporter.setConfiguration(configuration);
            Class.forName(this.jdbcDriver);
            if (this.server == null) {
                user = this.jdbcUser;
                password = this.jdbcPassword;
            } else {
                AuthenticationInfo info = this.wagonManager.getAuthenticationInfo(this.server);
                if (info == null) {
                    throw new MojoExecutionException("No authentication info for server " + this.server);
                }
                user = info.getUserName();
                if (user == null) {
                    throw new MojoExecutionException("Missing username from server " + this.server);
                }
                password = info.getPassword();
                if (password == null) {
                    throw new MojoExecutionException("Missing password from server " + this.server);
                }
            }
            try (Connection conn = DriverManager.getConnection(this.jdbcUrl, user, password);){
                exporter.export(conn.getMetaData());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected boolean isForTest() {
        return false;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    public void setBeanInterfaces(String[] beanInterfaces) {
        this.beanInterfaces = beanInterfaces;
    }

    public void setBeanPrefix(String beanPrefix) {
        this.beanPrefix = beanPrefix;
    }

    public void setBeanSuffix(String beanSuffix) {
        this.beanSuffix = beanSuffix;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setBeanPackageName(String beanPackageName) {
        this.beanPackageName = beanPackageName;
    }

    public void setCatalogPattern(String catalogPattern) {
        this.catalogPattern = catalogPattern;
    }

    public void setSchemaPattern(String schemaPattern) {
        this.schemaPattern = schemaPattern;
    }

    public void setTableNamePattern(String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    public void setNamingStrategyClass(String namingStrategyClass) {
        this.namingStrategyClass = namingStrategyClass;
    }

    public void setBeanSerializerClass(String beanSerializerClass) {
        this.beanSerializerClass = beanSerializerClass;
    }

    public void setSerializerClass(String serializerClass) {
        this.serializerClass = serializerClass;
    }

    public void setExportBeans(boolean exportBeans) {
        this.exportBeans = exportBeans;
    }

    public void setInnerClassesForKeys(boolean innerClassesForKeys) {
        this.innerClassesForKeys = innerClassesForKeys;
    }

    public void setValidationAnnotations(boolean validationAnnotations) {
        this.validationAnnotations = validationAnnotations;
    }

    public void setColumnAnnotations(boolean columnAnnotations) {
        this.columnAnnotations = columnAnnotations;
    }

    public void setCustomTypes(String[] customTypes) {
        this.customTypes = customTypes;
    }

    public void setCreateScalaSources(boolean createScalaSources) {
        this.createScalaSources = createScalaSources;
    }

    public void setSchemaToPackage(boolean schemaToPackage) {
        this.schemaToPackage = schemaToPackage;
    }

    public void setLowerCase(boolean lowerCase) {
        this.lowerCase = lowerCase;
    }

    public void setTypeMappings(TypeMapping[] typeMappings) {
        this.typeMappings = typeMappings;
    }

    public void setNumericMappings(NumericMapping[] numericMappings) {
        this.numericMappings = numericMappings;
    }

    public void setRenameMappings(RenameMapping[] renameMappings) {
        this.renameMappings = renameMappings;
    }

    public void setImports(String[] imports) {
        this.imports = imports;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setGeneratedAnnotationClass(String generatedAnnotationClass) {
        this.generatedAnnotationClass = generatedAnnotationClass;
    }

    private static String emptyIfSetToBlank(String value) {
        boolean setToBlank = value == null || value.equalsIgnoreCase("BLANK");
        return setToBlank ? "" : value;
    }

    private static String processBlankValues(String value) {
        if (value == null) {
            return null;
        }
        return BLANK_VALUE_PATTERN.matcher(value).replaceAll(BLANK_VALUE_REPLACEMENT);
    }
}

