/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.mongodb;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.Fetchable;
import com.querydsl.core.JoinExpression;
import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.QueryResults;
import com.querydsl.core.SimpleQuery;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.CollectionPathBase;
import com.querydsl.mongodb.AnyEmbeddedBuilder;
import com.querydsl.mongodb.JoinBuilder;
import com.querydsl.mongodb.MongodbSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public abstract class AbstractMongodbQuery<K, Q extends AbstractMongodbQuery<K, Q>>
implements SimpleQuery<Q>,
Fetchable<K> {
    private final MongodbSerializer serializer;
    private final QueryMixin<Q> queryMixin;
    private final DBCollection collection;
    private final Function<DBObject, K> transformer;
    private ReadPreference readPreference;

    public AbstractMongodbQuery(DBCollection collection, Function<DBObject, K> transformer, MongodbSerializer serializer) {
        AbstractMongodbQuery query = this;
        this.queryMixin = new QueryMixin((Object)query, (QueryMetadata)new DefaultQueryMetadata(), false);
        this.transformer = transformer;
        this.collection = collection;
        this.serializer = serializer;
    }

    public <T> JoinBuilder<Q, K, T> join(Path<T> ref, Path<T> target) {
        return new JoinBuilder(this.queryMixin, ref, target);
    }

    public <T> JoinBuilder<Q, K, T> join(CollectionPathBase<?, T, ?> ref, Path<T> target) {
        return new JoinBuilder(this.queryMixin, (Path<?>)ref, target);
    }

    public <T> AnyEmbeddedBuilder<Q, K> anyEmbedded(Path<? extends Collection<T>> collection, Path<T> target) {
        return new AnyEmbeddedBuilder(this.queryMixin, collection);
    }

    protected abstract DBCollection getCollection(Class<?> var1);

    @Nullable
    protected Predicate createFilter(QueryMetadata metadata) {
        Predicate filter = !metadata.getJoins().isEmpty() ? ExpressionUtils.allOf((Predicate[])new Predicate[]{metadata.getWhere(), this.createJoinFilter(metadata)}) : metadata.getWhere();
        return filter;
    }

    @Nullable
    protected Predicate createJoinFilter(QueryMetadata metadata) {
        HashMultimap predicates = HashMultimap.create();
        List joins = metadata.getJoins();
        for (int i = joins.size() - 1; i >= 0; --i) {
            JoinExpression join = (JoinExpression)joins.get(i);
            Path source = (Path)((Operation)join.getTarget()).getArg(0);
            Path target = (Path)((Operation)join.getTarget()).getArg(1);
            Collection extraFilters = predicates.get((Object)target.getRoot());
            Predicate filter = ExpressionUtils.allOf((Predicate[])new Predicate[]{join.getCondition(), this.allOf(extraFilters)});
            List<Object> ids = this.getIds(target.getType(), filter);
            if (ids.isEmpty()) {
                throw new NoResults();
            }
            Path path = ExpressionUtils.path(String.class, (Path)source, (String)"$id");
            predicates.put((Object)source.getRoot(), (Object)ExpressionUtils.in((Expression)path, ids));
        }
        Path source = (Path)((Operation)((JoinExpression)joins.get(0)).getTarget()).getArg(0);
        return this.allOf(predicates.get((Object)source.getRoot()));
    }

    private Predicate allOf(Collection<Predicate> predicates) {
        return predicates != null ? ExpressionUtils.allOf(predicates) : null;
    }

    protected List<Object> getIds(Class<?> targetType, Predicate condition) {
        DBCollection collection = this.getCollection(targetType);
        DBCursor cursor = this.createCursor(collection, condition, null, QueryModifiers.EMPTY, Collections.<OrderSpecifier<?>>emptyList());
        if (cursor.hasNext()) {
            ArrayList<Object> ids = new ArrayList<Object>(cursor.count());
            for (DBObject obj : cursor) {
                ids.add(obj.get("_id"));
            }
            return ids;
        }
        return Collections.emptyList();
    }

    public Q distinct() {
        return (Q)((AbstractMongodbQuery)this.queryMixin.distinct());
    }

    public Q where(Predicate e) {
        return (Q)((AbstractMongodbQuery)this.queryMixin.where(e));
    }

    public Q where(Predicate ... e) {
        return (Q)((AbstractMongodbQuery)this.queryMixin.where(e));
    }

    public Q limit(long limit) {
        return (Q)((AbstractMongodbQuery)this.queryMixin.limit(limit));
    }

    public Q offset(long offset) {
        return (Q)((AbstractMongodbQuery)this.queryMixin.offset(offset));
    }

    public Q restrict(QueryModifiers modifiers) {
        return (Q)((AbstractMongodbQuery)this.queryMixin.restrict(modifiers));
    }

    public Q orderBy(OrderSpecifier<?> o) {
        return (Q)((AbstractMongodbQuery)this.queryMixin.orderBy(o));
    }

    public Q orderBy(OrderSpecifier<?> ... o) {
        return (Q)((AbstractMongodbQuery)this.queryMixin.orderBy(o));
    }

    public <T> Q set(ParamExpression<T> param, T value) {
        return (Q)((AbstractMongodbQuery)this.queryMixin.set(param, value));
    }

    public CloseableIterator<K> iterate(Path<?> ... paths) {
        this.queryMixin.setProjection(paths);
        return this.iterate();
    }

    public CloseableIterator<K> iterate() {
        final DBCursor cursor = this.createCursor();
        return new CloseableIterator<K>(){

            public boolean hasNext() {
                return cursor.hasNext();
            }

            public K next() {
                return AbstractMongodbQuery.this.transformer.apply((Object)cursor.next());
            }

            public void remove() {
            }

            public void close() {
            }
        };
    }

    public List<K> fetch(Path<?> ... paths) {
        this.queryMixin.setProjection(paths);
        return this.fetch();
    }

    public List<K> fetch() {
        try {
            DBCursor cursor = this.createCursor();
            ArrayList<Object> results = new ArrayList<Object>();
            for (DBObject dbObject : cursor) {
                results.add(this.transformer.apply((Object)dbObject));
            }
            return results;
        }
        catch (NoResults ex) {
            return Collections.emptyList();
        }
    }

    protected DBCursor createCursor() {
        QueryMetadata metadata = this.queryMixin.getMetadata();
        Predicate filter = this.createFilter(metadata);
        return this.createCursor(this.collection, filter, metadata.getProjection(), metadata.getModifiers(), metadata.getOrderBy());
    }

    protected DBCursor createCursor(DBCollection collection, @Nullable Predicate where, Expression<?> projection, QueryModifiers modifiers, List<OrderSpecifier<?>> orderBy) {
        DBCursor cursor = collection.find(this.createQuery(where), this.createProjection(projection));
        Integer limit = modifiers.getLimitAsInteger();
        Integer offset = modifiers.getOffsetAsInteger();
        if (limit != null) {
            cursor.limit(limit.intValue());
        }
        if (offset != null) {
            cursor.skip(offset.intValue());
        }
        if (orderBy.size() > 0) {
            cursor.sort(this.serializer.toSort(orderBy));
        }
        if (this.readPreference != null) {
            cursor.setReadPreference(this.readPreference);
        }
        return cursor;
    }

    private DBObject createProjection(Expression<?> projection) {
        if (projection instanceof FactoryExpression) {
            BasicDBObject obj = new BasicDBObject();
            for (Object expr : ((FactoryExpression)projection).getArgs()) {
                if (!(expr instanceof Expression)) continue;
                obj.put((String)this.serializer.handle((Expression)expr), (Object)1);
            }
            return obj;
        }
        return null;
    }

    public K fetchFirst(Path<?> ... paths) {
        this.queryMixin.setProjection(paths);
        return this.fetchFirst();
    }

    public K fetchFirst() {
        try {
            DBCursor c = this.createCursor().limit(1);
            if (c.hasNext()) {
                return (K)this.transformer.apply((Object)c.next());
            }
            return null;
        }
        catch (NoResults ex) {
            return null;
        }
    }

    public K fetchOne(Path<?> ... paths) {
        this.queryMixin.setProjection(paths);
        return this.fetchOne();
    }

    public K fetchOne() {
        try {
            DBCursor c;
            Long limit = this.queryMixin.getMetadata().getModifiers().getLimit();
            if (limit == null) {
                limit = 2L;
            }
            if ((c = this.createCursor().limit(limit.intValue())).hasNext()) {
                Object rv = this.transformer.apply((Object)c.next());
                if (c.hasNext()) {
                    throw new NonUniqueResultException();
                }
                return (K)rv;
            }
            return null;
        }
        catch (NoResults ex) {
            return null;
        }
    }

    public QueryResults<K> fetchResults(Path<?> ... paths) {
        this.queryMixin.setProjection(paths);
        return this.fetchResults();
    }

    public QueryResults<K> fetchResults() {
        try {
            long total = this.fetchCount();
            if (total > 0L) {
                return new QueryResults(this.fetch(), this.queryMixin.getMetadata().getModifiers(), total);
            }
            return QueryResults.emptyResults();
        }
        catch (NoResults ex) {
            return QueryResults.emptyResults();
        }
    }

    public long fetchCount() {
        try {
            Predicate filter = this.createFilter(this.queryMixin.getMetadata());
            return this.collection.count(this.createQuery(filter));
        }
        catch (NoResults ex) {
            return 0L;
        }
    }

    private DBObject createQuery(@Nullable Predicate predicate) {
        if (predicate != null) {
            return (DBObject)this.serializer.handle((Expression<?>)predicate);
        }
        return new BasicDBObject();
    }

    public void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    public DBObject asDBObject() {
        return this.createQuery(this.queryMixin.getMetadata().getWhere());
    }

    public String toString() {
        return this.asDBObject().toString();
    }

    private static class NoResults
    extends RuntimeException {
        private NoResults() {
        }
    }
}

