/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.spatial;

import com.querydsl.sql.spatial.JGeometryConverter;
import com.querydsl.sql.types.AbstractType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;
import org.geolatte.geom.Geometry;

class JGeometryType
extends AbstractType<Geometry> {
    public static final JGeometryType DEFAULT = new JGeometryType();

    public JGeometryType() {
        super(1111);
    }

    public Class<Geometry> getReturnedClass() {
        return Geometry.class;
    }

    @Nullable
    public Geometry getValue(ResultSet rs, int startIndex) throws SQLException {
        byte[] bytes = rs.getBytes(startIndex);
        if (bytes != null) {
            try {
                JGeometry geometry = JGeometry.load((byte[])bytes);
                return JGeometryConverter.convert(geometry);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        return null;
    }

    public void setValue(PreparedStatement st, int startIndex, Geometry value) throws SQLException {
        try {
            JGeometry geo = JGeometryConverter.convert(value);
            STRUCT struct = JGeometry.store((Connection)st.getConnection(), (JGeometry)geo);
            st.setObject(startIndex, struct);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }
}

