/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.google.common.collect.ImmutableList;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.QueryFlag;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.QueryResults;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.ParamNotSetException;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.Wildcard;
import com.querydsl.core.util.ResultSetAdapter;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.ProjectableSQLQuery;
import com.querydsl.sql.SQLListener;
import com.querydsl.sql.SQLListenerContext;
import com.querydsl.sql.SQLListenerContextImpl;
import com.querydsl.sql.SQLListeners;
import com.querydsl.sql.SQLOps;
import com.querydsl.sql.SQLResultIterator;
import com.querydsl.sql.SQLSerializer;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractSQLQuery<T, Q extends AbstractSQLQuery<T, Q>>
extends ProjectableSQLQuery<T, Q> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSQLQuery.class);
    private static final QueryFlag rowCountFlag = new QueryFlag(QueryFlag.Position.AFTER_PROJECTION, ", count(*) over() ");
    @Nullable
    private final Connection conn;
    protected SQLListeners listeners;
    protected boolean useLiterals;
    private boolean getLastCell;
    private Object lastCell;

    public AbstractSQLQuery(@Nullable Connection conn, Configuration configuration) {
        this(conn, configuration, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractSQLQuery(@Nullable Connection conn, Configuration configuration, QueryMetadata metadata) {
        super(new QueryMixin(metadata, false), configuration);
        this.conn = conn;
        this.listeners = new SQLListeners(configuration.getListeners());
        this.useLiterals = configuration.getUseLiterals();
    }

    public SimpleExpression<T> as(String alias) {
        return Expressions.as((Expression)this, (String)alias);
    }

    public SimpleExpression<T> as(Path<?> alias) {
        return Expressions.as((Expression)this, alias);
    }

    public void addListener(SQLListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public long fetchCount() {
        try {
            return this.unsafeCount();
        }
        catch (SQLException e) {
            String error = "Caught " + e.getClass().getName();
            logger.error(error, (Throwable)e);
            throw this.configuration.translate(e);
        }
    }

    public Q forUpdate() {
        return (Q)((AbstractSQLQuery)this.addFlag(SQLOps.FOR_UPDATE_FLAG));
    }

    @Override
    protected SQLSerializer createSerializer() {
        SQLSerializer serializer = new SQLSerializer(this.configuration);
        serializer.setUseLiterals(this.useLiterals);
        return serializer;
    }

    @Nullable
    private <T> T get(ResultSet rs, Expression<?> expr, int i, Class<T> type) throws SQLException {
        return this.configuration.get(rs, expr instanceof Path ? (Path)expr : null, i, type);
    }

    private void set(PreparedStatement stmt, Path<?> path, int i, Object value) throws SQLException {
        this.configuration.set(stmt, path, i, value);
    }

    protected SQLListenerContextImpl startContext(Connection connection, QueryMetadata metadata) {
        SQLListenerContextImpl context = new SQLListenerContextImpl(metadata, connection);
        this.listeners.start(context);
        return context;
    }

    protected void onException(SQLListenerContextImpl context, Exception e) {
        context.setException(e);
        this.listeners.exception(context);
    }

    protected void endContext(SQLListenerContext context) {
        this.listeners.end(context);
    }

    public ResultSet getResults(Expression<?> ... exprs) {
        this.queryMixin.setProjection(exprs);
        SQLListenerContextImpl context = this.startContext(this.conn, this.queryMixin.getMetadata());
        String queryString = null;
        Object constants = ImmutableList.of();
        try {
            this.listeners.preRender(context);
            SQLSerializer serializer = this.serialize(false);
            queryString = serializer.toString();
            this.logQuery(queryString, serializer.getConstants());
            context.addSQL(queryString);
            this.listeners.rendered(context);
            this.listeners.notifyQuery(this.queryMixin.getMetadata());
            constants = serializer.getConstants();
            this.listeners.prePrepare(context);
            final PreparedStatement stmt = this.conn.prepareStatement(queryString);
            this.setParameters(stmt, (List<?>)constants, serializer.getConstantPaths(), this.getMetadata().getParams());
            context.addPreparedStatement(stmt);
            this.listeners.prepared(context);
            this.listeners.preExecute(context);
            ResultSet rs = stmt.executeQuery();
            this.listeners.executed(context);
            ResultSetAdapter resultSetAdapter = new ResultSetAdapter(rs){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws SQLException {
                    try {
                        super.close();
                    }
                    finally {
                        stmt.close();
                    }
                }
            };
            return resultSetAdapter;
        }
        catch (SQLException e) {
            this.onException(context, e);
            throw this.configuration.translate(queryString, (List<Object>)constants, e);
        }
        finally {
            this.reset();
            this.endContext(context);
        }
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    public CloseableIterator<T> iterate() {
        Expression expr = this.queryMixin.getMetadata().getProjection();
        return this.iterateSingle(this.queryMixin.getMetadata(), expr);
    }

    private CloseableIterator<T> iterateSingle(QueryMetadata metadata, final @Nullable Expression<T> expr) {
        SQLListenerContextImpl context = this.startContext(this.conn, this.queryMixin.getMetadata());
        String queryString = null;
        Object constants = ImmutableList.of();
        try {
            this.listeners.preRender(context);
            SQLSerializer serializer = this.serialize(false);
            queryString = serializer.toString();
            this.logQuery(queryString, serializer.getConstants());
            context.addSQL(queryString);
            this.listeners.rendered(context);
            this.listeners.notifyQuery(this.queryMixin.getMetadata());
            constants = serializer.getConstants();
            this.listeners.prePrepare(context);
            PreparedStatement stmt = this.conn.prepareStatement(queryString);
            this.setParameters(stmt, (List<?>)constants, serializer.getConstantPaths(), metadata.getParams());
            context.addPreparedStatement(stmt);
            this.listeners.prepared(context);
            this.listeners.preExecute(context);
            ResultSet rs = stmt.executeQuery();
            this.listeners.executed(context);
            if (expr == null) {
                SQLResultIterator sQLResultIterator = new SQLResultIterator<T>(this.configuration, stmt, rs){

                    @Override
                    public T produceNext(ResultSet rs) throws Exception {
                        return rs.getObject(1);
                    }
                };
                return sQLResultIterator;
            }
            if (expr instanceof FactoryExpression) {
                SQLResultIterator sQLResultIterator = new SQLResultIterator<T>(this.configuration, stmt, rs){

                    @Override
                    public T produceNext(ResultSet rs) throws Exception {
                        return AbstractSQLQuery.this.newInstance((FactoryExpression)expr, rs, 0);
                    }
                };
                return sQLResultIterator;
            }
            if (expr.equals((Object)Wildcard.all)) {
                SQLResultIterator sQLResultIterator = new SQLResultIterator<T>(this.configuration, stmt, rs){

                    @Override
                    public T produceNext(ResultSet rs) throws Exception {
                        Object[] rv = new Object[rs.getMetaData().getColumnCount()];
                        for (int i = 0; i < rv.length; ++i) {
                            rv[i] = rs.getObject(i + 1);
                        }
                        return rv;
                    }
                };
                return sQLResultIterator;
            }
            SQLResultIterator sQLResultIterator = new SQLResultIterator<T>(this.configuration, stmt, rs){

                @Override
                public T produceNext(ResultSet rs) throws Exception {
                    return AbstractSQLQuery.this.get(rs, expr, 1, expr.getType());
                }
            };
            return sQLResultIterator;
        }
        catch (SQLException e) {
            this.onException(context, e);
            throw this.configuration.translate(queryString, (List<Object>)constants, e);
        }
        finally {
            this.endContext(context);
            this.reset();
        }
    }

    /*
     * Exception decompiling
     */
    public List<T> fetch() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QueryResults<T> fetchResults() {
        Expression expr = this.queryMixin.getMetadata().getProjection();
        QueryModifiers originalModifiers = this.queryMixin.getMetadata().getModifiers();
        try {
            if (this.configuration.getTemplates().isCountViaAnalytics() && this.queryMixin.getMetadata().getGroupBy().isEmpty()) {
                long total;
                List<T> results;
                try {
                    this.queryMixin.addFlag(rowCountFlag);
                    this.getLastCell = true;
                    results = this.fetch();
                }
                finally {
                    this.queryMixin.removeFlag(rowCountFlag);
                }
                if (!results.isEmpty()) {
                    if (!(this.lastCell instanceof Number)) throw new IllegalStateException("Unsupported lastCell instance " + this.lastCell);
                    total = ((Number)this.lastCell).longValue();
                } else {
                    total = this.fetchCount();
                }
                QueryResults queryResults = new QueryResults(results, originalModifiers, total);
                return queryResults;
            }
            this.queryMixin.setProjection(expr);
            long total = this.fetchCount();
            if (total > 0L) {
                QueryResults queryResults = new QueryResults(this.fetch(), originalModifiers, total);
                return queryResults;
            }
            QueryResults queryResults = QueryResults.emptyResults();
            return queryResults;
        }
        finally {
            this.getLastCell = false;
            this.reset();
        }
    }

    private <RT> RT newInstance(FactoryExpression<RT> c, ResultSet rs, int offset) throws InstantiationException, IllegalAccessException, InvocationTargetException, SQLException {
        Object[] args = new Object[c.getArgs().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.get(rs, (Expression)c.getArgs().get(i), offset + i + 1, ((Expression)c.getArgs().get(i)).getType());
        }
        return (RT)c.newInstance(args);
    }

    private void reset() {
        this.queryMixin.getMetadata().reset();
        this.cleanupMDC();
    }

    protected void setParameters(PreparedStatement stmt, List<?> objects, List<Path<?>> constantPaths, Map<ParamExpression<?>, ?> params) {
        if (objects.size() != constantPaths.size()) {
            throw new IllegalArgumentException("Expected " + objects.size() + " paths, but got " + constantPaths.size());
        }
        for (int i = 0; i < objects.size(); ++i) {
            Object o = objects.get(i);
            try {
                if (o instanceof ParamExpression) {
                    if (!params.containsKey(o)) {
                        throw new ParamNotSetException((ParamExpression)o);
                    }
                    o = params.get(o);
                }
                this.set(stmt, constantPaths.get(i), i + 1, o);
                continue;
            }
            catch (SQLException e) {
                throw this.configuration.translate(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long unsafeCount() throws SQLException {
        SQLListenerContextImpl context = this.startContext(this.conn, this.getMetadata());
        String queryString = null;
        Object constants = ImmutableList.of();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.listeners.preRender(context);
            SQLSerializer serializer = this.serialize(true);
            queryString = serializer.toString();
            this.logQuery(queryString, serializer.getConstants());
            context.addSQL(queryString);
            this.listeners.rendered(context);
            constants = serializer.getConstants();
            this.listeners.prePrepare(context);
            stmt = this.conn.prepareStatement(queryString);
            this.setParameters((PreparedStatement)stmt, (List<?>)constants, serializer.getConstantPaths(), this.getMetadata().getParams());
            context.addPreparedStatement((PreparedStatement)stmt);
            this.listeners.prepared(context);
            this.listeners.preExecute(context);
            rs = stmt.executeQuery();
            boolean hasResult = rs.next();
            this.listeners.executed(context);
            if (hasResult) {
                long l = rs.getLong(1);
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (SQLException e) {
            this.onException(context, e);
            throw this.configuration.translate(queryString, (List<Object>)constants, e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            this.endContext(context);
            this.cleanupMDC();
        }
    }

    protected void logQuery(String queryString, Collection<Object> parameters) {
        String normalizedQuery = queryString.replace('\n', ' ');
        MDC.put((String)"querydsl.query", (String)normalizedQuery);
        MDC.put((String)"querydsl.parameters", (String)String.valueOf(parameters));
        if (logger.isDebugEnabled()) {
            logger.debug(normalizedQuery);
        }
    }

    protected void cleanupMDC() {
        MDC.remove((String)"querydsl.query");
        MDC.remove((String)"querydsl.parameters");
    }

    public void setUseLiterals(boolean useLiterals) {
        this.useLiterals = useLiterals;
    }

    @Override
    protected void clone(Q query) {
        super.clone(query);
        this.useLiterals = ((AbstractSQLQuery)query).useLiterals;
        this.listeners = new SQLListeners(((AbstractSQLQuery)query).listeners);
    }

    @Override
    public Q clone() {
        return this.clone(this.conn);
    }

    public abstract Q clone(Connection var1);
}

