/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLCommonQuery;
import com.querydsl.sql.SQLCommonQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLMergeClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.sql.Connection;
import javax.inject.Provider;

public abstract class AbstractSQLQueryFactory<Q extends SQLCommonQuery<?>>
implements SQLCommonQueryFactory<Q, SQLDeleteClause, SQLUpdateClause, SQLInsertClause, SQLMergeClause> {
    protected final Configuration configuration;
    protected final Provider<Connection> connection;

    public AbstractSQLQueryFactory(Configuration configuration, Provider<Connection> connection) {
        this.configuration = configuration;
        this.connection = connection;
    }

    @Override
    public final SQLDeleteClause delete(RelationalPath<?> path) {
        return new SQLDeleteClause((Connection)this.connection.get(), this.configuration, path);
    }

    @Override
    public final Q from(Expression<?> from) {
        return this.query().from(from);
    }

    @Override
    public final Q from(Expression<?> ... args) {
        return this.query().from(args);
    }

    @Override
    public final Q from(SubQueryExpression<?> subQuery, Path<?> alias) {
        return this.query().from(subQuery, alias);
    }

    @Override
    public final SQLInsertClause insert(RelationalPath<?> path) {
        return new SQLInsertClause((Connection)this.connection.get(), this.configuration, path);
    }

    @Override
    public final SQLMergeClause merge(RelationalPath<?> path) {
        return new SQLMergeClause((Connection)this.connection.get(), this.configuration, path);
    }

    @Override
    public final SQLUpdateClause update(RelationalPath<?> path) {
        return new SQLUpdateClause((Connection)this.connection.get(), this.configuration, path);
    }

    public final Configuration getConfiguration() {
        return this.configuration;
    }

    public final Connection getConnection() {
        return (Connection)this.connection.get();
    }
}

