/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.dml;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.JoinType;
import com.querydsl.core.QueryFlag;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.dml.DeleteClause;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.ValidatingVisitor;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLBindings;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BridgeMethodsAdded
public abstract class AbstractSQLDeleteClause<C extends AbstractSQLDeleteClause<C>>
extends AbstractSQLClause<C>
implements DeleteClause<C> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractSQLDeleteClause.class);
    protected static final ValidatingVisitor validatingVisitor = new ValidatingVisitor("Undeclared path '%s'. A delete operation can only reference a single table. Consider this alternative: DELETE ... WHERE EXISTS (subquery)");
    protected final RelationalPath<?> entity;
    protected final List<QueryMetadata> batches = new ArrayList<QueryMetadata>();
    protected DefaultQueryMetadata metadata = new DefaultQueryMetadata();
    protected transient String queryString;
    protected transient List<Object> constants;

    public AbstractSQLDeleteClause(Connection connection, Configuration configuration, RelationalPath<?> entity) {
        super(configuration, connection);
        this.entity = entity;
        this.metadata.addJoin(JoinType.DEFAULT, entity);
        this.metadata.setValidatingVisitor(validatingVisitor);
    }

    public AbstractSQLDeleteClause(Provider<Connection> connection, Configuration configuration, RelationalPath<?> entity) {
        super(configuration, connection);
        this.entity = entity;
        this.metadata.addJoin(JoinType.DEFAULT, entity);
        this.metadata.setValidatingVisitor(validatingVisitor);
    }

    @WithBridgeMethods(value={SQLDeleteClause.class})
    public C addFlag(QueryFlag.Position position, String flag) {
        this.metadata.addFlag(new QueryFlag(position, flag));
        return (C)this;
    }

    @WithBridgeMethods(value={SQLDeleteClause.class})
    public C addFlag(QueryFlag.Position position, Expression<?> flag) {
        this.metadata.addFlag(new QueryFlag(position, flag));
        return (C)this;
    }

    @WithBridgeMethods(value={SQLDeleteClause.class})
    public C addBatch() {
        this.batches.add((QueryMetadata)this.metadata);
        this.metadata = new DefaultQueryMetadata();
        this.metadata.addJoin(JoinType.DEFAULT, this.entity);
        this.metadata.setValidatingVisitor(validatingVisitor);
        return (C)this;
    }

    @Override
    public void clear() {
        this.batches.clear();
        this.metadata = new DefaultQueryMetadata();
        this.metadata.addJoin(JoinType.DEFAULT, this.entity);
        this.metadata.setValidatingVisitor(validatingVisitor);
    }

    protected PreparedStatement createStatement() throws SQLException {
        this.listeners.preRender(this.context);
        SQLSerializer serializer = this.createSerializer();
        serializer.serializeDelete((QueryMetadata)this.metadata, this.entity);
        this.queryString = serializer.toString();
        this.constants = serializer.getConstants();
        this.logQuery(logger, this.queryString, this.constants);
        this.context.addSQL(this.createBindings((QueryMetadata)this.metadata, serializer));
        this.listeners.rendered(this.context);
        this.listeners.prePrepare(this.context);
        PreparedStatement stmt = this.connection().prepareStatement(this.queryString);
        this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), this.metadata.getParams());
        this.context.addPreparedStatement(stmt);
        this.listeners.prepared(this.context);
        return stmt;
    }

    protected Collection<PreparedStatement> createStatements() throws SQLException {
        boolean addBatches = !this.configuration.getUseLiterals();
        this.listeners.preRender(this.context);
        SQLSerializer serializer = this.createSerializer();
        serializer.serializeDelete(this.batches.get(0), this.entity);
        this.queryString = serializer.toString();
        this.constants = serializer.getConstants();
        this.logQuery(logger, this.queryString, this.constants);
        this.context.addSQL(this.createBindings((QueryMetadata)this.metadata, serializer));
        this.listeners.rendered(this.context);
        HashMap stmts = Maps.newHashMap();
        this.listeners.prePrepare(this.context);
        PreparedStatement stmt = this.connection().prepareStatement(this.queryString);
        this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), this.metadata.getParams());
        if (addBatches) {
            stmt.addBatch();
        }
        stmts.put(this.queryString, stmt);
        this.context.addPreparedStatement(stmt);
        this.listeners.prepared(this.context);
        for (int i = 1; i < this.batches.size(); ++i) {
            this.listeners.preRender(this.context);
            serializer = this.createSerializer();
            serializer.serializeDelete(this.batches.get(i), this.entity);
            this.context.addSQL(this.createBindings((QueryMetadata)this.metadata, serializer));
            this.listeners.rendered(this.context);
            stmt = (PreparedStatement)stmts.get(serializer.toString());
            if (stmt == null) {
                this.listeners.prePrepare(this.context);
                stmt = this.connection().prepareStatement(serializer.toString());
                stmts.put(serializer.toString(), stmt);
                this.context.addPreparedStatement(stmt);
                this.listeners.prepared(this.context);
            }
            this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), this.metadata.getParams());
            if (!addBatches) continue;
            stmt.addBatch();
        }
        return stmts.values();
    }

    public long execute() {
        this.context = this.startContext(this.connection(), (QueryMetadata)this.metadata, this.entity);
        PreparedStatement stmt = null;
        Collection<PreparedStatement> stmts = null;
        try {
            if (this.batches.isEmpty()) {
                stmt = this.createStatement();
                this.listeners.notifyDelete(this.entity, (QueryMetadata)this.metadata);
                this.listeners.preExecute(this.context);
                int rc = stmt.executeUpdate();
                this.listeners.executed(this.context);
                long l = rc;
                return l;
            }
            stmts = this.createStatements();
            this.listeners.notifyDeletes(this.entity, this.batches);
            this.listeners.preExecute(this.context);
            long rc = this.executeBatch(stmts);
            this.listeners.executed(this.context);
            long l = rc;
            return l;
        }
        catch (SQLException e) {
            this.onException(this.context, e);
            throw this.configuration.translate(this.queryString, this.constants, e);
        }
        finally {
            if (stmt != null) {
                this.close(stmt);
            }
            if (stmts != null) {
                this.close(stmts);
            }
            this.reset();
            this.endContext(this.context);
        }
    }

    @Override
    public List<SQLBindings> getSQL() {
        if (this.batches.isEmpty()) {
            SQLSerializer serializer = this.createSerializer();
            serializer.serializeDelete((QueryMetadata)this.metadata, this.entity);
            return ImmutableList.of((Object)this.createBindings((QueryMetadata)this.metadata, serializer));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (QueryMetadata metadata : this.batches) {
            SQLSerializer serializer = this.createSerializer();
            serializer.serializeDelete(metadata, this.entity);
            builder.add((Object)this.createBindings(metadata, serializer));
        }
        return builder.build();
    }

    @WithBridgeMethods(value={SQLDeleteClause.class})
    public C where(Predicate p) {
        this.metadata.addWhere(p);
        return (C)this;
    }

    @WithBridgeMethods(value={SQLDeleteClause.class})
    public C where(Predicate ... o) {
        for (Predicate p : o) {
            this.metadata.addWhere(p);
        }
        return (C)this;
    }

    @WithBridgeMethods(value={SQLDeleteClause.class})
    public C limit(@Nonnegative long limit) {
        this.metadata.setModifiers(QueryModifiers.limit((long)limit));
        return (C)this;
    }

    @Override
    public int getBatchCount() {
        return this.batches.size();
    }

    public String toString() {
        SQLSerializer serializer = this.createSerializer();
        serializer.serializeDelete((QueryMetadata)this.metadata, this.entity);
        return serializer.toString();
    }
}

