/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.Target;
import com.querydsl.core.dml.DMLClause;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.Connections;
import com.querydsl.sql.ExtendedSQLQuery;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLListener;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SkipForQuotedRule;
import com.querydsl.sql.TargetRule;
import com.querydsl.sql.TestLoggingListener;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLMergeClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import com.querydsl.sql.mysql.MySQLReplaceClause;
import com.querydsl.sql.teradata.TeradataQuery;
import com.querydsl.sql.types.Type;
import com.querydsl.sql.types.XMLAsStringType;
import java.sql.Connection;
import java.util.List;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;

public abstract class AbstractBaseTest {
    protected static final Logger logger = Logger.getLogger(AbstractBaseTest.class.getName());
    protected Connection connection = Connections.getConnection();
    protected Target target = Connections.getTarget();
    protected Configuration configuration = Connections.getConfiguration();
    @Nullable
    protected String expectedQuery;
    @Rule
    public MethodRule skipForQuotedRule = new SkipForQuotedRule(this.configuration);
    @Rule
    @ClassRule
    public static TestRule targetRule = new TargetRule();

    public AbstractBaseTest() {
        if (this.target == Target.POSTGRESQL || this.target == Target.ORACLE) {
            this.configuration.register("XML_TEST", "COL", (Type)new XMLAsStringType());
        }
    }

    protected <T> void add(List<T> list, T arg, Target ... exclusions) {
        if (exclusions.length > 0) {
            for (Target t : exclusions) {
                if (!t.equals((Object)this.target)) continue;
                return;
            }
        }
        list.add(arg);
    }

    protected SQLUpdateClause update(RelationalPath<?> e) {
        SQLUpdateClause sqlUpdateClause = new SQLUpdateClause(this.connection, this.configuration, e);
        sqlUpdateClause.addListener((SQLListener)new TestLoggingListener());
        return sqlUpdateClause;
    }

    protected SQLInsertClause insert(RelationalPath<?> e) {
        SQLInsertClause sqlInsertClause = new SQLInsertClause(this.connection, this.configuration, e);
        sqlInsertClause.addListener((SQLListener)new TestLoggingListener());
        return sqlInsertClause;
    }

    protected SQLInsertClause insert(RelationalPath<?> e, SQLQuery<?> sq) {
        SQLInsertClause sqlInsertClause = new SQLInsertClause(this.connection, this.configuration, e, sq);
        sqlInsertClause.addListener((SQLListener)new TestLoggingListener());
        return sqlInsertClause;
    }

    protected SQLDeleteClause delete(RelationalPath<?> e) {
        SQLDeleteClause sqlDeleteClause = new SQLDeleteClause(this.connection, this.configuration, e);
        sqlDeleteClause.addListener((SQLListener)new TestLoggingListener());
        return sqlDeleteClause;
    }

    protected SQLMergeClause merge(RelationalPath<?> e) {
        SQLMergeClause sqlMergeClause = new SQLMergeClause(this.connection, this.configuration, e);
        sqlMergeClause.addListener((SQLListener)new TestLoggingListener());
        return sqlMergeClause;
    }

    protected ExtendedSQLQuery<?> extQuery() {
        ExtendedSQLQuery extendedSQLQuery = new ExtendedSQLQuery(this.connection, this.configuration);
        extendedSQLQuery.addListener((SQLListener)new TestLoggingListener());
        return extendedSQLQuery;
    }

    protected SQLInsertClause mysqlReplace(RelationalPath<?> path) {
        MySQLReplaceClause mySQLReplaceClause = new MySQLReplaceClause(this.connection, this.configuration, path);
        mySQLReplaceClause.addListener((SQLListener)new TestLoggingListener());
        return mySQLReplaceClause;
    }

    protected SQLQuery<?> query() {
        TestQuery testQuery = new TestQuery(this.connection, this.configuration);
        testQuery.addListener((SQLListener)new TestLoggingListener());
        return testQuery;
    }

    protected TeradataQuery<?> teradataQuery() {
        TeradataQuery teradataQuery = new TeradataQuery(this.connection, this.configuration);
        teradataQuery.addListener((SQLListener)new TestLoggingListener());
        return teradataQuery;
    }

    protected TestQuery<?> testQuery() {
        TestQuery testQuery = new TestQuery(this.connection, this.configuration, (QueryMetadata)new DefaultQueryMetadata());
        testQuery.addListener((SQLListener)new TestLoggingListener());
        return testQuery;
    }

    protected long execute(DMLClause<?> ... clauses) {
        long execute = 0L;
        for (DMLClause<?> clause : clauses) {
            execute += clause.execute();
        }
        return execute;
    }

    protected final class TestQuery<T>
    extends SQLQuery<T> {
        private TestQuery(Connection conn, Configuration configuration) {
            super(conn, configuration);
        }

        private TestQuery(Connection conn, Configuration configuration, QueryMetadata metadata) {
            super(conn, configuration, metadata);
        }

        protected SQLSerializer serialize(boolean countRow) {
            SQLSerializer serializer = super.serialize(countRow);
            String rv = serializer.toString();
            if (AbstractBaseTest.this.expectedQuery != null) {
                Assert.assertEquals((Object)AbstractBaseTest.this.expectedQuery, (Object)rv.replace('\n', ' '));
                AbstractBaseTest.this.expectedQuery = null;
            }
            logger.fine(rv);
            return serializer;
        }

        public TestQuery<T> clone(Connection conn) {
            TestQuery<T> q = new TestQuery<T>(conn, this.getConfiguration(), this.getMetadata().clone());
            q.union = this.union;
            q.unionAll = this.unionAll;
            q.firstUnionSubQuery = this.firstUnionSubQuery;
            return q;
        }
    }
}

