/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.Templates;
import com.querydsl.core.types.TemplatesTestUtils;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.Union;
import com.querydsl.sql.domain.QSurvey;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractSQLTemplatesTest {
    protected static final QSurvey survey1 = new QSurvey("survey1");
    protected static final QSurvey survey2 = new QSurvey("survey2");
    private SQLTemplates templates;
    protected SQLQuery<?> query;

    protected abstract SQLTemplates createTemplates();

    @Before
    public void setUp() {
        this.templates = this.createTemplates();
        this.templates.newLineToSingleSpace();
        this.query = new SQLQuery(new Configuration(this.templates));
    }

    @Test
    public void noFrom() {
        this.query.getMetadata().setProjection((Expression)Expressions.ONE);
        if (this.templates.getDummyTable() == null) {
            Assert.assertEquals((Object)"select 1", (Object)this.query.toString());
        } else {
            Assert.assertEquals((Object)("select 1 from " + this.templates.getDummyTable()), (Object)this.query.toString());
        }
    }

    @Test
    public void union() {
        NumberExpression one = Expressions.ONE;
        NumberExpression two = Expressions.TWO;
        NumberExpression three = Expressions.THREE;
        SimplePath col1 = Expressions.path(Integer.class, (String)"col1");
        Union union = this.query.union(new SubQueryExpression[]{SQLExpressions.select((Expression)one.as((Path)col1)), SQLExpressions.select((Expression)two), SQLExpressions.select((Expression)three)});
        if (this.templates.getDummyTable() == null) {
            if (this.templates.isUnionsWrapped()) {
                Assert.assertEquals((Object)"(select 1 as col1)\nunion\n(select 2)\nunion\n(select 3)", (Object)union.toString());
            } else {
                Assert.assertEquals((Object)"select 1 as col1)\nunion\nselect 2\nunion\nselect 3", (Object)union.toString());
            }
        } else {
            String dummyTable = this.templates.getDummyTable();
            if (this.templates.isUnionsWrapped()) {
                Assert.assertEquals((Object)("(select 1 as col1 from " + dummyTable + ")\nunion\n(select 2 from " + dummyTable + ")\nunion\n(select 3 from " + dummyTable + ")"), (Object)union.toString());
            } else {
                Assert.assertEquals((Object)("select 1 as col1 from " + dummyTable + "\nunion\nselect 2 from " + dummyTable + "\nunion\nselect 3 from " + dummyTable), (Object)union.toString());
            }
        }
    }

    @Test
    public void innerJoin() {
        ((SQLQuery)this.query.from((Expression)survey1)).innerJoin((EntityPath)survey2);
        Assert.assertEquals((Object)"from SURVEY survey1 inner join SURVEY survey2", (Object)this.query.toString());
    }

    protected int getPrecedence(Operator ... ops) {
        int precedence = this.templates.getPrecedence(ops[0]);
        for (int i = 1; i < ops.length; ++i) {
            Assert.assertEquals((String)ops[i].name(), (long)precedence, (long)this.templates.getPrecedence(ops[i]));
        }
        return precedence;
    }

    @Test
    public void generic_precedence() {
        TemplatesTestUtils.testPrecedence((Templates)this.templates);
    }

    @Test
    public void arithmetic() {
        NumberPath one = Expressions.numberPath(Integer.class, (String)"one");
        NumberPath two = Expressions.numberPath(Integer.class, (String)"two");
        this.assertSerialized((Expression<?>)one.add((Expression)two), "one + two");
        this.assertSerialized((Expression<?>)one.add((Expression)two).multiply((Number)1), "(one + two) * ?");
        this.assertSerialized((Expression<?>)one.add((Expression)two).divide((Number)1), "(one + two) / ?");
        this.assertSerialized((Expression<?>)one.add((Expression)two).add((Number)1), "one + two + ?");
        this.assertSerialized((Expression<?>)one.add((Expression)two.multiply((Number)1)), "one + two * ?");
        this.assertSerialized((Expression<?>)one.add((Expression)two.divide((Number)1)), "one + two / ?");
        this.assertSerialized((Expression<?>)one.add((Expression)two.add((Number)1)), "one + (two + ?)");
        this.assertSerialized((Expression<?>)one.subtract((Expression)two), "one - two");
        this.assertSerialized((Expression<?>)one.subtract((Expression)two).multiply((Number)1), "(one - two) * ?");
        this.assertSerialized((Expression<?>)one.subtract((Expression)two).divide((Number)1), "(one - two) / ?");
        this.assertSerialized((Expression<?>)one.subtract((Expression)two).add((Number)1), "one - two + ?");
        this.assertSerialized((Expression<?>)one.subtract((Expression)two.multiply((Number)1)), "one - two * ?");
        this.assertSerialized((Expression<?>)one.subtract((Expression)two.divide((Number)1)), "one - two / ?");
        this.assertSerialized((Expression<?>)one.subtract((Expression)two.add((Number)1)), "one - (two + ?)");
        this.assertSerialized((Expression<?>)one.multiply((Expression)two), "one * two");
        this.assertSerialized((Expression<?>)one.multiply((Expression)two).multiply((Number)1), "one * two * ?");
        this.assertSerialized((Expression<?>)one.multiply((Expression)two).divide((Number)1), "one * two / ?");
        this.assertSerialized((Expression<?>)one.multiply((Expression)two).add((Number)1), "one * two + ?");
        this.assertSerialized((Expression<?>)one.multiply((Expression)two.multiply((Number)1)), "one * (two * ?)");
        this.assertSerialized((Expression<?>)one.multiply((Expression)two.divide((Number)1)), "one * (two / ?)");
        this.assertSerialized((Expression<?>)one.multiply((Expression)two.add((Number)1)), "one * (two + ?)");
    }

    @Test
    public void booleanTemplate() {
        this.assertSerialized((Expression<?>)Expressions.booleanPath((String)"b").eq((Expression)Expressions.TRUE), "b = 1");
        this.assertSerialized((Expression<?>)Expressions.booleanPath((String)"b").eq((Expression)Expressions.FALSE), "b = 0");
        this.query.setUseLiterals(true);
        this.query.where((Predicate)Expressions.booleanPath((String)"b").eq(Boolean.valueOf(true)));
        Assert.assertTrue((String)this.query.toString(), (boolean)this.query.toString().endsWith("where b = 1"));
    }

    protected void assertSerialized(Expression<?> expr, String serialized) {
        SQLSerializer serializer = new SQLSerializer(new Configuration(this.templates));
        serializer.handle(expr);
        Assert.assertEquals((Object)serialized, (Object)serializer.toString());
    }

    @Test
    public void in() {
        CollectionExpression ints = Expressions.collectionOperation(Integer.class, (Operator)Ops.LIST, (Expression[])new Expression[]{Expressions.collectionOperation(Integer.class, (Operator)Ops.LIST, (Expression[])new Expression[]{Expressions.ONE, Expressions.TWO}), Expressions.THREE});
        ((SQLQuery)this.query.from((Expression)survey1)).where((Predicate)AbstractSQLTemplatesTest.survey1.id.in(ints));
        this.query.getMetadata().setProjection((Expression)AbstractSQLTemplatesTest.survey1.name);
        Assert.assertEquals((Object)"select survey1.NAME from SURVEY survey1 where survey1.ID in (1, 2, 3)", (Object)this.query.toString());
    }
}

