/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.Target;
import com.querydsl.core.testutil.ExcludeIn;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.AbstractBaseTest;
import com.querydsl.sql.ExtendedSQLQuery;
import com.querydsl.sql.OtherEmployee;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.BeanMapper;
import com.querydsl.sql.dml.Mapper;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import com.querydsl.sql.domain.Employee;
import com.querydsl.sql.domain.QEmployee;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@ExcludeIn(value={Target.CUBRID, Target.DB2, Target.DERBY, Target.ORACLE, Target.SQLSERVER, Target.POSTGRESQL, Target.SQLITE, Target.TERADATA})
public class BeanPopulationBase
extends AbstractBaseTest {
    private final QEmployee e = new QEmployee("e");

    @After
    public void tearDown() {
        ((SQLDeleteClause)this.delete((RelationalPath<?>)this.e).where((Predicate)this.e.firstname.eq((Object)"John"))).execute();
    }

    @Test
    public void custom_projection() {
        Employee employee = new Employee();
        employee.setFirstname("John");
        Integer id = (Integer)((SQLInsertClause)this.insert((RelationalPath<?>)this.e).populate((Object)employee)).executeWithKey(this.e.id);
        employee.setId(id);
        employee.setLastname("S");
        Assert.assertEquals((long)1L, (long)((SQLUpdateClause)((SQLUpdateClause)this.update((RelationalPath<?>)this.e).populate((Object)employee)).where((Predicate)this.e.id.eq((Object)employee.getId()))).execute());
        Employee smith = ((ExtendedSQLQuery)((ExtendedSQLQuery)((ExtendedSQLQuery)this.extQuery().from((Expression)this.e)).where((Predicate)this.e.lastname.eq((Object)"S"))).limit(1L)).uniqueResult(Employee.class, new Expression[]{this.e.lastname, this.e.firstname});
        Assert.assertEquals((Object)"John", (Object)smith.getFirstname());
        Assert.assertEquals((Object)"S", (Object)smith.getLastname());
        smith = ((ExtendedSQLQuery)((ExtendedSQLQuery)((ExtendedSQLQuery)this.extQuery().from((Expression)this.e)).where((Predicate)this.e.lastname.eq((Object)"S"))).limit(1L)).uniqueResult(Employee.class, new Expression[]{this.e.lastname.as("lastname"), this.e.firstname.as("firstname")});
        Assert.assertEquals((Object)"John", (Object)smith.getFirstname());
        Assert.assertEquals((Object)"S", (Object)smith.getLastname());
        OtherEmployee other = ((ExtendedSQLQuery)((ExtendedSQLQuery)((ExtendedSQLQuery)this.extQuery().from((Expression)this.e)).where((Predicate)this.e.lastname.eq((Object)"S"))).limit(1L)).uniqueResult(OtherEmployee.class, new Expression[]{this.e.lastname, this.e.firstname});
        Assert.assertEquals((Object)"John", (Object)other.getFirstname());
        Assert.assertEquals((Object)"S", (Object)other.getLastname());
        Assert.assertEquals((long)1L, (long)((SQLDeleteClause)this.delete((RelationalPath<?>)this.e).where((Predicate)this.e.id.eq((Object)employee.getId()))).execute());
    }

    @Test
    public void insert_update_query_and_delete() {
        Employee employee = new Employee();
        employee.setFirstname("John");
        Integer id = (Integer)((SQLInsertClause)this.insert((RelationalPath<?>)this.e).populate((Object)employee)).executeWithKey(this.e.id);
        Assert.assertNotNull((Object)id);
        employee.setId(id);
        employee.setLastname("S");
        Assert.assertEquals((long)1L, (long)((SQLUpdateClause)((SQLUpdateClause)this.update((RelationalPath<?>)this.e).populate((Object)employee)).where((Predicate)this.e.id.eq((Object)employee.getId()))).execute());
        Employee smith = (Employee)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)this.e)).where((Predicate)this.e.lastname.eq((Object)"S"))).limit(1L)).select((Expression)this.e).fetchFirst();
        Assert.assertEquals((Object)"John", (Object)smith.getFirstname());
        Assert.assertEquals((long)1L, (long)((SQLDeleteClause)this.delete((RelationalPath<?>)this.e).where((Predicate)this.e.id.eq((Object)employee.getId()))).execute());
    }

    @Test
    public void populate_with_beanMapper() {
        Employee employee = new Employee();
        employee.setFirstname("John");
        ((SQLInsertClause)this.insert((RelationalPath<?>)this.e).populate((Object)employee, (Mapper)new BeanMapper())).execute();
    }
}

