/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.domain.QEmployee;
import org.junit.Assert;
import org.junit.Test;

public class ColumnMetadataTest {
    @Test
    public void defaultColumn() {
        ColumnMetadata column = ColumnMetadata.named((String)"Person");
        Assert.assertEquals((Object)"Person", (Object)column.getName());
        Assert.assertFalse((boolean)column.hasJdbcType());
        Assert.assertFalse((boolean)column.hasSize());
        Assert.assertTrue((boolean)column.isNullable());
    }

    @Test
    public void fullyConfigured() {
        ColumnMetadata column = ColumnMetadata.named((String)"Person").withSize(10).notNull().ofType(-5);
        Assert.assertEquals((Object)"Person", (Object)column.getName());
        Assert.assertTrue((boolean)column.hasJdbcType());
        Assert.assertEquals((long)-5L, (long)column.getJdbcType());
        Assert.assertTrue((boolean)column.hasSize());
        Assert.assertEquals((long)10L, (long)column.getSize());
        Assert.assertFalse((boolean)column.isNullable());
    }

    @Test
    public void extractFromRelationalPath() {
        ColumnMetadata column = ColumnMetadata.getColumnMetadata(QEmployee.employee.id);
        Assert.assertEquals((Object)"ID", (Object)column.getName());
    }

    @Test
    public void fallBackToDefaultWhenMissing() {
        ColumnMetadata column = ColumnMetadata.getColumnMetadata(QEmployee.employee.salary);
        Assert.assertEquals((Object)"SALARY", (Object)column.getName());
    }
}

