/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.alias.Gender;
import com.querydsl.core.types.Path;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.EncryptedString;
import com.querydsl.sql.H2Templates;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.SchemaAndTable;
import com.querydsl.sql.domain.QSurvey;
import com.querydsl.sql.namemapping.ChainedNameMapping;
import com.querydsl.sql.namemapping.ChangeLetterCaseNameMapping;
import com.querydsl.sql.namemapping.NameMapping;
import com.querydsl.sql.namemapping.PreConfiguredNameMapping;
import com.querydsl.sql.types.EnumByNameType;
import com.querydsl.sql.types.InputStreamType;
import com.querydsl.sql.types.Null;
import com.querydsl.sql.types.StringType;
import com.querydsl.sql.types.Type;
import com.querydsl.sql.types.UtilDateType;
import java.io.InputStream;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Locale;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurationTest {
    @Test
    public void various() {
        Configuration configuration = new Configuration((SQLTemplates)new H2Templates());
        configuration.register((Type)new UtilDateType());
        configuration.register("person", "secureId", (Type)new EncryptedString());
        configuration.register("person", "gender", (Type)new EnumByNameType(Gender.class));
        configuration.register((Type)new StringType());
        Assert.assertEquals(Gender.class, (Object)configuration.getJavaType(12, null, 0, 0, "person", "gender"));
    }

    @Test
    public void custom_type() {
        Configuration configuration = new Configuration((SQLTemplates)new H2Templates());
        configuration.register((Type)new InputStreamType());
        Assert.assertEquals(InputStream.class, (Object)configuration.getJavaType(2004, null, 0, 0, "", ""));
    }

    @Test
    public void set_null() throws SQLException {
        Configuration configuration = new Configuration((SQLTemplates)new H2Templates());
        configuration.register("SURVEY", "NAME", (Type)new EncryptedString());
        PreparedStatement stmt = (PreparedStatement)EasyMock.createNiceMock(PreparedStatement.class);
        configuration.set(stmt, (Path)QSurvey.survey.name, 0, (Object)Null.DEFAULT);
    }

    @Test
    public void get_schema() {
        Configuration configuration = new Configuration((SQLTemplates)new H2Templates());
        configuration.registerSchemaOverride("public", "pub");
        configuration.registerTableOverride("employee", "emp");
        configuration.registerTableOverride("public", "employee", "employees");
        Assert.assertEquals((Object)"pub", (Object)configuration.getOverride(new SchemaAndTable("public", "")).getSchema());
        Assert.assertEquals((Object)"emp", (Object)configuration.getOverride(new SchemaAndTable("", "employee")).getTable());
        Assert.assertEquals((Object)"employees", (Object)configuration.getOverride(new SchemaAndTable("public", "employee")).getTable());
        configuration.setDynamicNameMapping((NameMapping)new PreConfiguredNameMapping());
        SchemaAndTable notOverriddenSchemaAndTable = new SchemaAndTable("notoverridden", "notoverridden");
        Assert.assertEquals((Object)notOverriddenSchemaAndTable, (Object)configuration.getOverride(notOverriddenSchemaAndTable));
        configuration.setDynamicNameMapping((NameMapping)new ChangeLetterCaseNameMapping(ChangeLetterCaseNameMapping.LetterCase.UPPER, Locale.ENGLISH));
        String notDirectOverriden = "notDirectOverriden";
        Assert.assertEquals((Object)notDirectOverriden.toUpperCase(Locale.ENGLISH), (Object)configuration.getOverride(new SchemaAndTable("public", notDirectOverriden)).getTable());
    }

    @Test
    public void columnOverride() {
        Configuration configuration = new Configuration((SQLTemplates)new H2Templates());
        Assert.assertEquals((Object)"notoverriddencolumn", (Object)configuration.getColumnOverride(new SchemaAndTable("myschema", "mytable"), "notoverriddencolumn"));
        configuration.setDynamicNameMapping((NameMapping)new PreConfiguredNameMapping());
        Assert.assertEquals((Object)"notoverriddencolumn", (Object)configuration.getColumnOverride(new SchemaAndTable("myschema", "mytable"), "notoverriddencolumn"));
        configuration.setDynamicNameMapping((NameMapping)new ChangeLetterCaseNameMapping(ChangeLetterCaseNameMapping.LetterCase.LOWER, Locale.ENGLISH));
        configuration.registerColumnOverride("mytable", "oldcolumn", "newcolumn");
        configuration.registerColumnOverride("mytable", "oldcolumn2", "newcolumn2");
        Assert.assertEquals((Object)"newcolumn", (Object)configuration.getColumnOverride(new SchemaAndTable("myschema", "mytable"), "oldcolumn"));
        Assert.assertEquals((Object)"newcolumn2", (Object)configuration.getColumnOverride(new SchemaAndTable("myschema", "mytable"), "oldcolumn2"));
        configuration.registerColumnOverride("myschema", "mytable", "oldcolumn", "newcolumnwithschema");
        configuration.registerColumnOverride("myschema", "mytable", "oldcolumn2", "newcolumnwithschema2");
        Assert.assertEquals((Object)"newcolumnwithschema2", (Object)configuration.getColumnOverride(new SchemaAndTable("myschema", "mytable"), "oldcolumn2"));
        Assert.assertEquals((Object)"notoverriddencolumn", (Object)configuration.getColumnOverride(new SchemaAndTable("myschema", "mytable"), "notoverriddencolumn"));
        Assert.assertEquals((Object)"lower", (Object)configuration.getColumnOverride(new SchemaAndTable("myschema", "mytable"), "LOWER"));
    }

    @Test(expected=NullPointerException.class)
    public void npeWithNullParameterOfChainedNameMappingConstructor() {
        new ChainedNameMapping((NameMapping[])null);
    }

    @Test(expected=NullPointerException.class)
    public void npeWithNullElementInParameterOfChainedNameMappingConstructor() {
        new ChainedNameMapping(new NameMapping[]{null});
    }

    @Test
    public void numericOverriden() {
        Configuration configuration = new Configuration((SQLTemplates)new H2Templates());
        configuration.registerNumeric(19, 0, BigInteger.class);
        Assert.assertEquals((Object)configuration.getJavaType(2, "", 19, 0, "", ""), BigInteger.class);
    }

    @Test
    public void numericOverriden2() {
        Configuration configuration = new Configuration((SQLTemplates)new H2Templates());
        configuration.registerNumeric(18, 19, 0, 0, BigInteger.class);
        Assert.assertEquals((Object)configuration.getJavaType(2, "", 18, 0, "", ""), BigInteger.class);
        Assert.assertEquals((Object)configuration.getJavaType(2, "", 19, 0, "", ""), BigInteger.class);
    }
}

