/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.Target;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.Constants;
import com.querydsl.sql.DB2Templates;
import com.querydsl.sql.DerbyTemplates;
import com.querydsl.sql.FirebirdTemplates;
import com.querydsl.sql.H2Templates;
import com.querydsl.sql.HSQLDBTemplates;
import com.querydsl.sql.OracleTemplates;
import com.querydsl.sql.PostgreSQLTemplates;
import com.querydsl.sql.SQLServerTemplates;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.TeradataTemplates;
import com.querydsl.sql.ddl.CreateTableClause;
import com.querydsl.sql.ddl.DropTableClause;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.util.HashMap;
import java.util.Map;

public final class Connections {
    public static final int TEST_ROW_COUNT = 100;
    private static ThreadLocal<Connection> connHolder = new ThreadLocal();
    private static ThreadLocal<Target> targetHolder = new ThreadLocal();
    private static ThreadLocal<Configuration> configurationHolder = new ThreadLocal();
    private static final String CREATE_TABLE_DATETEST = "create table DATE_TEST(DATE_TEST date)";
    private static final String CREATE_TABLE_SURVEY = "create table SURVEY(ID int auto_increment, NAME varchar(30), NAME2 varchar(30))";
    private static final String CREATE_TABLE_TEST = "create table TEST(NAME varchar(255))";
    private static final String CREATE_TABLE_TIMETEST = "create table TIME_TEST(TIME_TEST time)";
    private static final String INSERT_INTO_EMPLOYEE = "insert into EMPLOYEE (ID, FIRSTNAME, LASTNAME, SALARY, DATEFIELD, TIMEFIELD, SUPERIOR_ID) values (?,?,?,?,?,?,?)";
    private static final String INSERT_INTO_TEST_VALUES = "insert into TEST values(?)";
    private static ThreadLocal<Statement> stmtHolder = new ThreadLocal();
    private static boolean db2Inited;
    private static boolean derbyInited;
    private static boolean sqlServerInited;
    private static boolean h2Inited;
    private static boolean hsqlInited;
    private static boolean mysqlInited;
    private static boolean cubridInited;
    private static boolean oracleInited;
    private static boolean postgresqlInited;
    private static boolean sqliteInited;
    private static boolean teradataInited;
    private static boolean firebirdInited;

    public static void close() throws SQLException {
        if (stmtHolder.get() != null) {
            stmtHolder.get().close();
        }
        if (connHolder.get() != null) {
            connHolder.get().close();
        }
    }

    public static Connection getConnection() {
        return connHolder.get();
    }

    public static Target getTarget() {
        return targetHolder.get();
    }

    public static Configuration getConfiguration() {
        return configurationHolder.get();
    }

    public static void initConfiguration(SQLTemplates templates) {
        configurationHolder.set(new Configuration(templates));
    }

    private static Connection getDB2() throws SQLException, ClassNotFoundException {
        Class.forName("com.ibm.db2.jcc.DB2Driver");
        String url = "jdbc:db2://localhost:50000/sample";
        return DriverManager.getConnection(url, "db2inst1", "a3sd!fDj");
    }

    private static Connection getDerby() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        String url = "jdbc:derby:target/demoDB;create=true";
        return DriverManager.getConnection(url, "", "");
    }

    private static Connection getFirebird() throws SQLException, ClassNotFoundException {
        Class.forName("org.firebirdsql.jdbc.FBDriver");
        String url = "jdbc:firebirdsql:localhost/3050:/firebird/data/querydsl.fdb";
        return DriverManager.getConnection(url, "sysdba", "masterkey");
    }

    private static Connection getHSQL() throws SQLException, ClassNotFoundException {
        Class.forName("org.hsqldb.jdbcDriver");
        String url = "jdbc:hsqldb:target/tutorial";
        return DriverManager.getConnection(url, "sa", "");
    }

    public static Connection getH2() throws SQLException, ClassNotFoundException {
        Class.forName("org.h2.Driver");
        String url = "jdbc:h2:./target/h2-test;LOCK_MODE=0;AUTO_SERVER=TRUE";
        return DriverManager.getConnection(url, "sa", "");
    }

    private static Connection getMySQL() throws SQLException, ClassNotFoundException {
        Class.forName("com.mysql.jdbc.Driver");
        String url = "jdbc:mysql://localhost:3306/querydsl?useLegacyDatetimeCode=false";
        return DriverManager.getConnection(url, "querydsl", "querydsl");
    }

    private static Connection getOracle() throws SQLException, ClassNotFoundException {
        Class.forName("oracle.jdbc.driver.OracleDriver");
        String url = "jdbc:oracle:thin:@localhost:1521:xe";
        return DriverManager.getConnection(url, "querydsl", "querydsl");
    }

    private static Connection getPostgreSQL() throws ClassNotFoundException, SQLException {
        Class.forName("org.postgresql.Driver");
        String url = "jdbc:postgresql://localhost:5433/querydsl";
        return DriverManager.getConnection(url, "querydsl", "querydsl");
    }

    private static Connection getSQLServer() throws ClassNotFoundException, SQLException {
        Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        String url = "jdbc:sqlserver://localhost:1433;databaseName=tempdb;sendTimeAsDatetime=false;trustServerCertificate=true";
        return DriverManager.getConnection(url, "sa", "Password1!");
    }

    private static Connection getCubrid() throws ClassNotFoundException, SQLException {
        Class.forName("cubrid.jdbc.driver.CUBRIDDriver");
        String url = "jdbc:cubrid:localhost:30000:demodb:public::";
        return DriverManager.getConnection(url);
    }

    private static Connection getSQLite() throws SQLException, ClassNotFoundException {
        Class.forName("org.sqlite.JDBC");
        return DriverManager.getConnection("jdbc:sqlite:target/sample.db");
    }

    private static Connection getTeradata() throws SQLException, ClassNotFoundException {
        Class.forName("com.teradata.jdbc.TeraDriver");
        return DriverManager.getConnection("jdbc:teradata://teradata/dbc", "querydsl", "querydsl");
    }

    private static CreateTableClause createTable(SQLTemplates templates, String table) {
        return new CreateTableClause(connHolder.get(), new Configuration(templates), table);
    }

    public static void dropTable(SQLTemplates templates, String table) throws SQLException {
        new DropTableClause(connHolder.get(), new Configuration(templates), table).execute();
    }

    public static void dropType(Statement stmt, String type) throws SQLException {
        block2: {
            try {
                stmt.execute("drop type " + type);
            }
            catch (SQLException e) {
                if (e.getMessage().contains("does not exist")) break block2;
                throw e;
            }
        }
    }

    public static Statement getStatement() {
        return stmtHolder.get();
    }

    private static void createEmployeeTable(SQLTemplates templates) {
        Connections.createTable(templates, "EMPLOYEE").column("ID", Integer.class).notNull().column("FIRSTNAME", String.class).size(50).column("LASTNAME", String.class).size(50).column("SALARY", Double.class).column("DATEFIELD", Date.class).column("TIMEFIELD", Time.class).column("SUPERIOR_ID", Integer.class).primaryKey("PK_EMPLOYEE", "ID").foreignKey("FK_SUPERIOR", "SUPERIOR_ID").references("EMPLOYEE", "ID").execute();
    }

    public static Map<Integer, String> getSpatialData() {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        m.put(1, "POINT (2 2)");
        m.put(2, "POINT (8 7)");
        m.put(3, "POINT (1 9)");
        m.put(4, "POINT (9 2)");
        m.put(5, "POINT (4 4)");
        m.put(6, "LINESTRING (30 10, 10 30)");
        m.put(7, "LINESTRING (30 10, 10 30, 40 40)");
        m.put(8, "POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10), (20 30, 35 35, 30 20, 20 30))");
        m.put(9, "POLYGON ((35 10, 45 45, 15 40, 10 20, 35 10), (20 30, 35 35, 30 20, 20 30))");
        m.put(11, "MULTIPOINT (10 40, 40 30)");
        m.put(11, "MULTIPOINT (10 40, 40 30, 20 20, 30 10)");
        m.put(12, "MULTILINESTRING ((10 10, 20 20, 10 40), (40 40, 30 30, 40 20, 30 10))");
        m.put(13, "MULTILINESTRING ((10 10, 20 20, 10 40))");
        m.put(14, "MULTIPOLYGON (((30 20, 45 40, 10 40, 30 20)), ((15 5, 40 10, 10 20, 5 10, 15 5)))");
        m.put(15, "MULTIPOLYGON (((40 40, 20 45, 45 30, 40 40)), ((20 35, 10 30, 10 10, 30 5, 45 20, 20 35), (30 20, 20 15, 20 25, 30 20)))");
        return m;
    }

    public static void initCubrid() throws SQLException, ClassNotFoundException {
        targetHolder.set(Target.CUBRID);
        Connection c = Connections.getCubrid();
        connHolder.set(c);
        Statement stmt = c.createStatement();
        stmtHolder.set(stmt);
        if (cubridInited) {
            return;
        }
        stmt.execute("drop table if exists SURVEY");
        stmt.execute("create table SURVEY(ID int auto_increment(16693,2), NAME varchar(30),NAME2 varchar(30),constraint suryey_pk primary key(ID))");
        stmt.execute("insert into SURVEY values (1,'Hello World','Hello');");
        stmt.execute("drop table if exists \"TEST\"");
        stmt.execute("create table \"TEST\"(NAME varchar(255))");
        try (PreparedStatement pstmt = c.prepareStatement("insert into \"TEST\" values(?)");){
            for (int i = 0; i < 100; ++i) {
                pstmt.setString(1, "name" + i);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        stmt.execute("drop table if exists EMPLOYEE");
        stmt.execute("create table EMPLOYEE ( ID INT PRIMARY KEY AUTO_INCREMENT, FIRSTNAME VARCHAR(50), LASTNAME VARCHAR(50), SALARY DECIMAL, DATEFIELD DATE, TIMEFIELD TIME, SUPERIOR_ID INT, CONSTRAINT FK_SUPERIOR FOREIGN KEY(SUPERIOR_ID) REFERENCES EMPLOYEE(ID) )");
        Connections.addEmployees(INSERT_INTO_EMPLOYEE);
        stmt.execute("drop table if exists TIME_TEST");
        stmt.execute("drop table if exists DATE_TEST");
        stmt.execute(CREATE_TABLE_TIMETEST);
        stmt.execute(CREATE_TABLE_DATETEST);
        stmt.execute("drop table if exists NUMBER_TEST");
        stmt.execute("create table NUMBER_TEST(col1 int)");
        stmt.execute("drop table if exists XML_TEST");
        stmt.execute("create table XML_TEST(COL varchar(128))");
        cubridInited = true;
    }

    public static void initDB2() throws SQLException, ClassNotFoundException {
        targetHolder.set(Target.DB2);
        DB2Templates templates = new DB2Templates();
        Connection c = Connections.getDB2();
        connHolder.set(c);
        Statement stmt = c.createStatement();
        stmtHolder.set(stmt);
        if (db2Inited) {
            return;
        }
        Connections.dropTable((SQLTemplates)templates, "SURVEY");
        stmt.execute("create table SURVEY(ID int generated by default as identity(start with 1, increment by 1), NAME varchar(30),NAME2 varchar(30))");
        stmt.execute("insert into SURVEY values (1,'Hello World','Hello')");
        Connections.dropTable((SQLTemplates)templates, "TEST");
        stmt.execute(CREATE_TABLE_TEST);
        stmt.execute("create index test_name on test(name)");
        try (PreparedStatement pstmt = c.prepareStatement(INSERT_INTO_TEST_VALUES);){
            for (int i = 0; i < 100; ++i) {
                pstmt.setString(1, "name" + i);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        Connections.dropTable((SQLTemplates)templates, "EMPLOYEE");
        Connections.createEmployeeTable((SQLTemplates)templates);
        Connections.addEmployees(INSERT_INTO_EMPLOYEE);
        Connections.dropTable((SQLTemplates)templates, "TIME_TEST");
        stmt.execute(CREATE_TABLE_TIMETEST);
        Connections.dropTable((SQLTemplates)templates, "DATE_TEST");
        stmt.execute(CREATE_TABLE_DATETEST);
        Connections.dropTable((SQLTemplates)templates, "NUMBER_TEST");
        stmt.execute("create table NUMBER_TEST(col1 smallint)");
        Connections.dropTable((SQLTemplates)templates, "XML_TEST");
        stmt.execute("create table XML_TEST(COL varchar(128))");
        db2Inited = true;
    }

    public static void initDerby() throws SQLException, ClassNotFoundException {
        targetHolder.set(Target.DERBY);
        DerbyTemplates templates = new DerbyTemplates();
        Connection c = Connections.getDerby();
        connHolder.set(c);
        Statement stmt = c.createStatement();
        stmtHolder.set(stmt);
        if (derbyInited) {
            return;
        }
        Connections.dropType(stmt, "price restrict");
        stmt.execute("create type price external name 'com.example.Price' language java");
        Connections.dropTable((SQLTemplates)templates, "SURVEY");
        stmt.execute("create table SURVEY(ID int generated by default as identity(start with 1, increment by 1), NAME varchar(30),NAME2 varchar(30))");
        stmt.execute("insert into SURVEY values (1,'Hello World','Hello')");
        Connections.dropTable((SQLTemplates)templates, "TEST");
        stmt.execute(CREATE_TABLE_TEST);
        stmt.execute("create index test_name on test(name)");
        try (PreparedStatement pstmt = c.prepareStatement(INSERT_INTO_TEST_VALUES);){
            for (int i = 0; i < 100; ++i) {
                pstmt.setString(1, "name" + i);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        Connections.dropTable((SQLTemplates)templates, "EMPLOYEE");
        Connections.createEmployeeTable((SQLTemplates)templates);
        Connections.addEmployees(INSERT_INTO_EMPLOYEE);
        Connections.dropTable((SQLTemplates)templates, "TIME_TEST");
        stmt.execute(CREATE_TABLE_TIMETEST);
        Connections.dropTable((SQLTemplates)templates, "DATE_TEST");
        stmt.execute(CREATE_TABLE_DATETEST);
        Connections.dropTable((SQLTemplates)templates, "NUMBER_TEST");
        stmt.execute("create table NUMBER_TEST(col1 boolean)");
        Connections.dropTable((SQLTemplates)templates, "XML_TEST");
        stmt.execute("create table XML_TEST(COL varchar(128))");
        derbyInited = true;
    }

    public static void initFirebird() throws SQLException, ClassNotFoundException {
        targetHolder.set(Target.FIREBIRD);
        FirebirdTemplates templates = new FirebirdTemplates();
        Connection c = Connections.getFirebird();
        connHolder.set(c);
        Statement stmt = c.createStatement();
        stmtHolder.set(stmt);
        if (firebirdInited) {
            return;
        }
        try {
            stmt.execute("DECLARE EXTERNAL FUNCTION ltrim\n   CSTRING(255)\n   RETURNS CSTRING(255) FREE_IT\n   ENTRY_POINT 'IB_UDF_ltrim' MODULE_NAME 'ib_udf'");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            stmt.execute("DECLARE EXTERNAL FUNCTION rtrim\n   CSTRING(255) NULL\n   RETURNS CSTRING(255) FREE_IT\n   ENTRY_POINT 'IB_UDF_rtrim' MODULE_NAME 'ib_udf'");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Connections.dropTable((SQLTemplates)templates, "SURVEY");
        stmt.execute("create table SURVEY(ID int primary key, NAME varchar(30),NAME2 varchar(30))");
        stmt.execute("insert into SURVEY values (1,'Hello World','Hello');");
        try {
            stmt.execute("DROP GENERATOR survey_gen_id;");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("CREATE GENERATOR survey_gen_id;");
        stmt.execute("SET GENERATOR survey_gen_id TO 30;");
        stmt.execute("CREATE TRIGGER survey_auto_id FOR survey\nACTIVE BEFORE INSERT POSITION 0\nAS\nBEGIN\nIF (NEW.id IS NULL) THEN\nNEW.id = GEN_ID(survey_gen_id,1);\nEND ");
        Connections.dropTable((SQLTemplates)templates, "TEST");
        stmt.execute(CREATE_TABLE_TEST);
        try (PreparedStatement pstmt = c.prepareStatement(INSERT_INTO_TEST_VALUES);){
            for (int i = 0; i < 100; ++i) {
                pstmt.setString(1, "name" + i);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        Connections.dropTable((SQLTemplates)templates, "EMPLOYEE");
        stmt.execute("create table EMPLOYEE ( ID INT PRIMARY KEY, FIRSTNAME VARCHAR(50), LASTNAME VARCHAR(50), SALARY DECIMAL, DATEFIELD DATE, TIMEFIELD TIME, SUPERIOR_ID INT, CONSTRAINT FK_SUPERIOR FOREIGN KEY(SUPERIOR_ID) REFERENCES EMPLOYEE(ID) )");
        try {
            stmt.execute("DROP GENERATOR employee_gen_id;");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("CREATE GENERATOR employee_gen_id;");
        stmt.execute("SET GENERATOR employee_gen_id TO 30;");
        stmt.execute("CREATE TRIGGER employee_auto_id FOR employee\nACTIVE BEFORE INSERT POSITION 0\nAS\nBEGIN\nIF (NEW.id IS NULL) THEN\nNEW.id = GEN_ID(employee_gen_id,1);\nEND ");
        Connections.addEmployees(INSERT_INTO_EMPLOYEE);
        Connections.dropTable((SQLTemplates)templates, "TIME_TEST");
        Connections.dropTable((SQLTemplates)templates, "DATE_TEST");
        stmt.execute(CREATE_TABLE_TIMETEST);
        stmt.execute(CREATE_TABLE_DATETEST);
        Connections.dropTable((SQLTemplates)templates, "NUMBER_TEST");
        stmt.execute("create table NUMBER_TEST(col1 char(1))");
        Connections.dropTable((SQLTemplates)templates, "XML_TEST");
        stmt.execute("create table XML_TEST(COL varchar(128))");
        firebirdInited = true;
    }

    public static void initH2() throws SQLException, ClassNotFoundException {
        targetHolder.set(Target.H2);
        H2Templates templates = new H2Templates();
        Connection c = Connections.getH2();
        connHolder.set(c);
        Statement stmt = c.createStatement();
        stmtHolder.set(stmt);
        if (h2Inited) {
            return;
        }
        stmt.execute("DROP ALIAS IF EXISTS H2GIS_SPATIAL");
        stmt.execute("CREATE ALIAS IF NOT EXISTS H2GIS_SPATIAL FOR \"org.h2gis.functions.factory.H2GISFunctions.load\"");
        stmt.execute("CALL H2GIS_SPATIAL();");
        Connections.dropTable((SQLTemplates)templates, "SHAPES");
        stmt.execute("create table SHAPES (ID int not null primary key, GEOMETRY geometry)");
        for (Map.Entry<Integer, String> entry : Connections.getSpatialData().entrySet()) {
            stmt.execute("insert into SHAPES values(" + entry.getKey() + ", ST_GeomFromText('" + entry.getValue() + "'))");
        }
        stmt.execute("drop table QTEST if exists");
        stmt.execute("create table QTEST (ID int IDENTITY(1,1) NOT NULL,  C1 int NULL)");
        stmt.execute("drop table if exists UUIDS");
        stmt.execute("create table UUIDS (FIELD uuid)");
        stmt.execute("drop table SURVEY if exists");
        stmt.execute(CREATE_TABLE_SURVEY);
        stmt.execute("insert into SURVEY values (1, 'Hello World', 'Hello');");
        stmt.execute("alter table SURVEY alter column id int auto_increment");
        stmt.execute("drop table TEST if exists");
        stmt.execute(CREATE_TABLE_TEST);
        try (PreparedStatement pstmt = c.prepareStatement(INSERT_INTO_TEST_VALUES);){
            for (int i = 0; i < 100; ++i) {
                pstmt.setString(1, "name" + i);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        stmt.execute("drop table EMPLOYEE if exists");
        Connections.createEmployeeTable((SQLTemplates)templates);
        stmt.execute("alter table EMPLOYEE alter column id int auto_increment");
        Connections.addEmployees(INSERT_INTO_EMPLOYEE);
        stmt.execute("drop table TIME_TEST if exists");
        stmt.execute("drop table DATE_TEST if exists");
        stmt.execute(CREATE_TABLE_TIMETEST);
        stmt.execute(CREATE_TABLE_DATETEST);
        Connections.dropTable((SQLTemplates)templates, "NUMBER_TEST");
        stmt.execute("create table NUMBER_TEST(col1 boolean)");
        Connections.dropTable((SQLTemplates)templates, "XML_TEST");
        stmt.execute("create table XML_TEST(COL varchar(128))");
        h2Inited = true;
    }

    public static void initHSQL() throws SQLException, ClassNotFoundException {
        targetHolder.set(Target.HSQLDB);
        HSQLDBTemplates templates = new HSQLDBTemplates();
        Connection c = Connections.getHSQL();
        connHolder.set(c);
        Statement stmt = c.createStatement();
        stmtHolder.set(stmt);
        if (hsqlInited) {
            return;
        }
        stmt.execute("drop table ARRAYTEST if exists");
        stmt.execute("create table ARRAYTEST ( ID bigint primary key, INTEGERS integer array, MYARRAY varchar(8) array)");
        stmt.execute("drop table DUAL if exists");
        stmt.execute("create table DUAL ( DUMMY varchar(1) )");
        stmt.execute("insert into DUAL (DUMMY) values ('X')");
        stmt.execute("drop table SURVEY if exists");
        stmt.execute("create table SURVEY(ID int generated by default as identity, NAME varchar(30),NAME2 varchar(30))");
        stmt.execute("insert into SURVEY values (1, 'Hello World', 'Hello')");
        stmt.execute("drop table TEST if exists");
        stmt.execute(CREATE_TABLE_TEST);
        try (PreparedStatement pstmt = c.prepareStatement(INSERT_INTO_TEST_VALUES);){
            for (int i = 0; i < 100; ++i) {
                pstmt.setString(1, "name" + i);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        stmt.execute("drop table EMPLOYEE if exists");
        Connections.createEmployeeTable((SQLTemplates)templates);
        stmt.execute("alter table EMPLOYEE alter column id int generated by default as identity");
        Connections.addEmployees(INSERT_INTO_EMPLOYEE);
        stmt.execute("drop table TIME_TEST if exists");
        stmt.execute("drop table DATE_TEST if exists");
        stmt.execute(CREATE_TABLE_TIMETEST);
        stmt.execute(CREATE_TABLE_DATETEST);
        Connections.dropTable((SQLTemplates)templates, "NUMBER_TEST");
        stmt.execute("create table NUMBER_TEST(col1 boolean)");
        Connections.dropTable((SQLTemplates)templates, "XML_TEST");
        stmt.execute("create table XML_TEST(COL varchar(128))");
        hsqlInited = true;
    }

    public static void initMySQL() throws SQLException, ClassNotFoundException {
        targetHolder.set(Target.MYSQL);
        Connection c = Connections.getMySQL();
        connHolder.set(c);
        Statement stmt = c.createStatement();
        stmtHolder.set(stmt);
        if (mysqlInited) {
            return;
        }
        stmt.execute("drop table if exists SHAPES");
        stmt.execute("create table SHAPES (ID int not null primary key, GEOMETRY geometry)");
        for (Map.Entry<Integer, String> entry : Connections.getSpatialData().entrySet()) {
            stmt.execute("insert into SHAPES values(" + entry.getKey() + ", GeomFromText('" + entry.getValue() + "'))");
        }
        stmt.execute("drop table if exists SURVEY");
        stmt.execute("create table SURVEY(ID int primary key auto_increment, NAME varchar(30),NAME2 varchar(30))");
        stmt.execute("insert into SURVEY values (1,'Hello World','Hello');");
        stmt.execute("drop table if exists TEST");
        stmt.execute(CREATE_TABLE_TEST);
        try (PreparedStatement pstmt = c.prepareStatement(INSERT_INTO_TEST_VALUES);){
            for (int i = 0; i < 100; ++i) {
                pstmt.setString(1, "name" + i);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        stmt.execute("drop table if exists EMPLOYEE");
        stmt.execute("create table EMPLOYEE ( ID INT PRIMARY KEY AUTO_INCREMENT, FIRSTNAME VARCHAR(50), LASTNAME VARCHAR(50), SALARY DECIMAL, DATEFIELD DATE, TIMEFIELD TIME, SUPERIOR_ID INT, CONSTRAINT FK_SUPERIOR FOREIGN KEY(SUPERIOR_ID) REFERENCES EMPLOYEE(ID) )");
        Connections.addEmployees(INSERT_INTO_EMPLOYEE);
        stmt.execute("drop table if exists TIME_TEST");
        stmt.execute("drop table if exists DATE_TEST");
        stmt.execute(CREATE_TABLE_TIMETEST);
        stmt.execute(CREATE_TABLE_DATETEST);
        stmt.execute("drop table if exists NUMBER_TEST");
        stmt.execute("create table NUMBER_TEST(col1 tinyint(1))");
        stmt.execute("drop table if exists XML_TEST");
        stmt.execute("create table XML_TEST(COL varchar(128))");
        mysqlInited = true;
    }

    public static void initOracle() throws SQLException, ClassNotFoundException {
        Statement stmt;
        Connection c;
        OracleTemplates templates;
        block4: {
            targetHolder.set(Target.ORACLE);
            templates = new OracleTemplates();
            c = Connections.getOracle();
            connHolder.set(c);
            stmt = c.createStatement();
            stmtHolder.set(stmt);
            if (oracleInited) {
                return;
            }
            stmt.execute("create or replace type ssn_t as object (ssn_type char(11))");
            Connections.dropTable((SQLTemplates)templates, "SURVEY");
            stmt.execute("create table SURVEY (ID number(10,0), NAME varchar(30 char),NAME2 varchar(30 char))");
            try {
                stmt.execute("drop sequence survey_seq");
            }
            catch (SQLException e) {
                if (e.getMessage().contains("sequence does not exist")) break block4;
                throw e;
            }
        }
        stmt.execute("create sequence survey_seq");
        stmt.execute("create or replace trigger survey_trigger\nbefore insert on survey\nfor each row\nwhen (new.id is null)\nbegin\n  select survey_seq.nextval into :new.id from dual;\nend;\n");
        stmt.execute("insert into SURVEY values (1,'Hello World','Hello')");
        Connections.dropTable((SQLTemplates)templates, "TEST");
        stmt.execute("create table TEST(name varchar(255))");
        String sql = INSERT_INTO_TEST_VALUES;
        PreparedStatement pstmt = c.prepareStatement(sql);
        for (int i = 0; i < 100; ++i) {
            pstmt.setString(1, "name" + i);
            pstmt.addBatch();
        }
        pstmt.executeBatch();
        Connections.dropTable((SQLTemplates)templates, "EMPLOYEE");
        stmt.execute("create table EMPLOYEE ( ID NUMBER(10,0), FIRSTNAME VARCHAR2(50 CHAR), LASTNAME VARCHAR2(50 CHAR), SALARY DOUBLE PRECISION, DATEFIELD DATE, TIMEFIELD TIMESTAMP, SUPERIOR_ID NUMBER(10,0), CONSTRAINT PK_EMPLOYEE PRIMARY KEY(ID), CONSTRAINT FK_SUPERIOR FOREIGN KEY(SUPERIOR_ID) REFERENCES EMPLOYEE(ID))");
        Connections.addEmployees(INSERT_INTO_EMPLOYEE);
        Connections.dropTable((SQLTemplates)templates, "DATE_TEST");
        stmt.execute("create table date_test(date_test date)");
        Connections.dropTable((SQLTemplates)templates, "NUMBER_TEST");
        stmt.execute("create table NUMBER_TEST(col1 number(1,0))");
        Connections.dropTable((SQLTemplates)templates, "XML_TEST");
        stmt.execute("create table XML_TEST(COL XMLTYPE)");
        oracleInited = true;
    }

    public static void initPostgreSQL() throws SQLException, ClassNotFoundException {
        Statement stmt;
        Connection c;
        PostgreSQLTemplates templates;
        block11: {
            targetHolder.set(Target.POSTGRESQL);
            templates = new PostgreSQLTemplates(true);
            c = Connections.getPostgreSQL();
            connHolder.set(c);
            stmt = c.createStatement();
            stmtHolder.set(stmt);
            if (postgresqlInited) {
                return;
            }
            Connections.dropTable((SQLTemplates)templates, "SHAPES");
            stmt.execute("create table \"SHAPES\" (\"ID\" int not null primary key)");
            stmt.execute("select AddGeometryColumn('SHAPES', 'GEOMETRY', -1, 'GEOMETRY', 2)");
            for (Map.Entry<Integer, String> entry : Connections.getSpatialData().entrySet()) {
                stmt.execute("insert into \"SHAPES\" values(" + entry.getKey() + ", '" + entry.getValue() + "')");
            }
            Connections.dropType(stmt, "u_country");
            stmt.execute("create type u_country as enum ('Brazil', 'England', 'Germany')");
            Connections.dropType(stmt, "u_street_type");
            stmt.execute("create type u_street_type as (street VARCHAR(100), number VARCHAR(30))");
            Connections.dropTable((SQLTemplates)templates, "ARRAYTEST");
            stmt.execute("create table \"ARRAYTEST\" (\n\"ID\" bigint primary key,\n\"INTEGERS\" integer[],\n\"MYARRAY\" varchar(8)[])");
            Connections.dropTable((SQLTemplates)templates, "UUIDS");
            stmt.execute("create table \"UUIDS\" (\"FIELD\" uuid)");
            Connections.dropTable((SQLTemplates)templates, "SURVEY");
            try {
                stmt.execute("drop sequence SURVEY_SEQ");
            }
            catch (SQLException e) {
                if (e.getMessage().contains("does not exist")) break block11;
                throw e;
            }
        }
        stmt.execute("create sequence SURVEY_SEQ");
        stmt.execute("create table \"SURVEY\"(\"ID\" int DEFAULT NEXTVAL('SURVEY_SEQ'), \"NAME\" varchar(30), \"NAME2\" varchar(30))");
        stmt.execute("insert into \"SURVEY\" values (1, 'Hello World', 'Hello')");
        Connections.dropTable((SQLTemplates)templates, "TEST");
        stmt.execute(Connections.quote(CREATE_TABLE_TEST, "TEST", "NAME"));
        String sql = Connections.quote(INSERT_INTO_TEST_VALUES, "TEST");
        try (PreparedStatement pstmt = c.prepareStatement(sql);){
            for (int i = 0; i < 100; ++i) {
                pstmt.setString(1, "name" + i);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        Connections.dropTable((SQLTemplates)templates, "EMPLOYEE");
        Connections.createEmployeeTable((SQLTemplates)templates);
        Connections.addEmployees("insert into \"EMPLOYEE\" (\"ID\", \"FIRSTNAME\", \"LASTNAME\", \"SALARY\", \"DATEFIELD\", \"TIMEFIELD\", \"SUPERIOR_ID\") values (?,?,?,?,?,?,?)");
        Connections.dropTable((SQLTemplates)templates, "TIME_TEST");
        Connections.dropTable((SQLTemplates)templates, "DATE_TEST");
        stmt.execute(Connections.quote(CREATE_TABLE_TIMETEST, "TIME_TEST"));
        stmt.execute(Connections.quote(CREATE_TABLE_DATETEST, "DATE_TEST"));
        Connections.dropTable((SQLTemplates)templates, "NUMBER_TEST");
        stmt.execute("create table \"NUMBER_TEST\"(\"COL1\" boolean)");
        Connections.dropTable((SQLTemplates)templates, "XML_TEST");
        stmt.execute("create table \"XML_TEST\"(\"COL\" XML)");
        postgresqlInited = true;
    }

    public static void initSQLite() throws SQLException, ClassNotFoundException {
        targetHolder.set(Target.SQLITE);
        Connection c = Connections.getSQLite();
        connHolder.set(c);
        Statement stmt = c.createStatement();
        stmtHolder.set(stmt);
        if (sqliteInited) {
            return;
        }
        stmt.execute("drop table if exists QTEST");
        stmt.execute("create table QTEST (ID int IDENTITY(1,1) NOT NULL,  C1 int NULL)");
        stmt.execute("drop table if exists SURVEY");
        stmt.execute("create table SURVEY(ID int auto_increment, NAME varchar(30),NAME2 varchar(30),constraint survey_pk primary key(ID))");
        stmt.execute("insert into SURVEY values (1,'Hello World','Hello');");
        stmt.execute("drop table if exists TEST");
        stmt.execute(CREATE_TABLE_TEST);
        try (PreparedStatement pstmt = c.prepareStatement(INSERT_INTO_TEST_VALUES);){
            for (int i = 0; i < 100; ++i) {
                pstmt.setString(1, "name" + i);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        stmt.execute("drop table if exists EMPLOYEE");
        stmt.execute("create table EMPLOYEE ( ID INT AUTO_INCREMENT, FIRSTNAME VARCHAR(50), LASTNAME VARCHAR(50), SALARY DECIMAL, DATEFIELD DATE, TIMEFIELD TIME, SUPERIOR_ID INT, CONSTRAINT PK_EMPLOYEE PRIMARY KEY(ID),CONSTRAINT FK_SUPERIOR FOREIGN KEY(SUPERIOR_ID) REFERENCES EMPLOYEE(ID) )");
        Connections.addEmployees(INSERT_INTO_EMPLOYEE);
        stmt.execute("drop table if exists TIME_TEST");
        stmt.execute("drop table if exists DATE_TEST");
        stmt.execute(CREATE_TABLE_TIMETEST);
        stmt.execute(CREATE_TABLE_DATETEST);
        stmt.execute("drop table if exists NUMBER_TEST");
        stmt.execute("create table NUMBER_TEST(col1 integer)");
        stmt.execute("drop table if exists XML_TEST");
        stmt.execute("create table XML_TEST(COL varchar(128))");
        sqliteInited = true;
    }

    public static void initSQLServer() throws SQLException, ClassNotFoundException {
        targetHolder.set(Target.SQLSERVER);
        SQLServerTemplates templates = new SQLServerTemplates();
        Connection c = Connections.getSQLServer();
        connHolder.set(c);
        Statement stmt = c.createStatement();
        stmtHolder.set(stmt);
        if (sqlServerInited) {
            return;
        }
        Connections.dropTable((SQLTemplates)templates, "SHAPES");
        stmt.execute("create table SHAPES (ID int not null primary key, GEOMETRY geometry)");
        for (Map.Entry<Integer, String> entry : Connections.getSpatialData().entrySet()) {
            stmt.execute("insert into SHAPES values(" + entry.getKey() + ", geometry::STGeomFromText('" + entry.getValue() + "', 0))");
        }
        Connections.dropTable((SQLTemplates)templates, "SURVEY");
        stmt.execute("create table SURVEY(ID int, NAME varchar(30), NAME2 varchar(30))");
        stmt.execute("insert into SURVEY values (1, 'Hello World', 'Hello')");
        Connections.dropTable((SQLTemplates)templates, "TEST");
        stmt.execute(CREATE_TABLE_TEST);
        try (PreparedStatement pstmt = c.prepareStatement(INSERT_INTO_TEST_VALUES);){
            for (int i = 0; i < 100; ++i) {
                pstmt.setString(1, "name" + i);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        Connections.dropTable((SQLTemplates)templates, "EMPLOYEE");
        Connections.createEmployeeTable((SQLTemplates)templates);
        Connections.addEmployees(INSERT_INTO_EMPLOYEE);
        Connections.dropTable((SQLTemplates)templates, "TIME_TEST");
        Connections.dropTable((SQLTemplates)templates, "DATE_TEST");
        stmt.execute(CREATE_TABLE_TIMETEST);
        stmt.execute(CREATE_TABLE_DATETEST);
        Connections.dropTable((SQLTemplates)templates, "NUMBER_TEST");
        stmt.execute("create table NUMBER_TEST(col1 bit)");
        Connections.dropTable((SQLTemplates)templates, "XML_TEST");
        stmt.execute("create table XML_TEST(COL XML)");
        sqlServerInited = true;
    }

    public static void initTeradata() throws SQLException, ClassNotFoundException {
        targetHolder.set(Target.TERADATA);
        TeradataTemplates templates = new TeradataTemplates();
        Connection c = Connections.getTeradata();
        connHolder.set(c);
        Statement stmt = c.createStatement();
        stmtHolder.set(stmt);
        if (teradataInited) {
            return;
        }
        String identity = "GENERATED ALWAYS AS IDENTITY(START WITH 1 INCREMENT BY 1)";
        Connections.dropTable((SQLTemplates)templates, "SHAPES");
        stmt.execute("create table SHAPES (ID int not null primary key, GEOMETRY ST_GEOMETRY)");
        for (Map.Entry<Integer, String> entry : Connections.getSpatialData().entrySet()) {
            stmt.execute("insert into SHAPES values(" + entry.getKey() + ", '" + entry.getValue() + "')");
        }
        Connections.dropTable((SQLTemplates)templates, "QTEST");
        stmt.execute("create table QTEST (ID int " + identity + " NOT NULL, C1 int NULL)");
        Connections.dropTable((SQLTemplates)templates, "SURVEY");
        stmt.execute("create table SURVEY(ID int " + identity + ", NAME varchar(30), NAME2 varchar(30))");
        stmt.execute("insert into SURVEY values (1, 'Hello World', 'Hello');");
        Connections.dropTable((SQLTemplates)templates, "TEST");
        stmt.execute(CREATE_TABLE_TEST);
        try (PreparedStatement pstmt = c.prepareStatement(INSERT_INTO_TEST_VALUES);){
            for (int i = 0; i < 100; ++i) {
                pstmt.setString(1, "name" + i);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        Connections.dropTable((SQLTemplates)templates, "EMPLOYEE");
        stmt.execute("create table EMPLOYEE (\nID INTEGER NOT NULL PRIMARY KEY, \nFIRSTNAME VARCHAR(100),\nLASTNAME VARCHAR(100),\nSALARY DOUBLE PRECISION,\nDATEFIELD DATE,\nTIMEFIELD TIME,\nSUPERIOR_ID INTEGER,\nCONSTRAINT FK_SUPERIOR FOREIGN KEY(SUPERIOR_ID) REFERENCES EMPLOYEE(ID))");
        Connections.addEmployees(INSERT_INTO_EMPLOYEE);
        Connections.dropTable((SQLTemplates)templates, "TIME_TEST");
        Connections.dropTable((SQLTemplates)templates, "DATE_TEST");
        stmt.execute(CREATE_TABLE_TIMETEST);
        stmt.execute(CREATE_TABLE_DATETEST);
        Connections.dropTable((SQLTemplates)templates, "NUMBER_TEST");
        stmt.execute("create table NUMBER_TEST(ID int " + identity + " NOT NULL, col1 int)");
        Connections.dropTable((SQLTemplates)templates, "XML_TEST");
        stmt.execute("create table XML_TEST(ID int " + identity + " NOT NULL, COL varchar(128))");
        teradataInited = true;
    }

    static void addEmployee(String sql, int id, String firstName, String lastName, double salary, int superiorId) throws SQLException {
        PreparedStatement stmt = connHolder.get().prepareStatement(sql);
        stmt.setInt(1, id);
        stmt.setString(2, firstName);
        stmt.setString(3, lastName);
        stmt.setDouble(4, salary);
        stmt.setDate(5, Constants.date);
        stmt.setTime(6, Constants.time);
        if (superiorId <= 0) {
            stmt.setNull(7, 4);
        } else {
            stmt.setInt(7, superiorId);
        }
        stmt.execute();
        stmt.close();
    }

    private static void addEmployees(String sql) throws SQLException {
        Connections.addEmployee(sql, 1, "Mike", "Smith", 160000.0, -1);
        Connections.addEmployee(sql, 2, "Mary", "Smith", 140000.0, -1);
        Connections.addEmployee(sql, 10, "Joe", "Divis", 50000.0, 1);
        Connections.addEmployee(sql, 11, "Peter", "Mason", 45000.0, 1);
        Connections.addEmployee(sql, 12, "Steve", "Johnson", 40000.0, 1);
        Connections.addEmployee(sql, 13, "Jim", "Hood", 35000.0, 1);
        Connections.addEmployee(sql, 20, "Jennifer", "Divis", 60000.0, 2);
        Connections.addEmployee(sql, 21, "Helen", "Mason", 50000.0, 2);
        Connections.addEmployee(sql, 22, "Daisy", "Johnson", 40000.0, 2);
        Connections.addEmployee(sql, 23, "Barbara", "Hood", 30000.0, 2);
    }

    private static String quote(String sql, String ... identifiers) {
        String rv = sql;
        for (String id : identifiers) {
            rv = rv.replace(id, "\"" + id + "\"");
        }
        return rv;
    }

    private Connections() {
    }
}

