/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.Target;
import com.querydsl.core.testutil.ExcludeIn;
import com.querydsl.core.testutil.IncludeIn;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.Param;
import com.querydsl.sql.AbstractBaseTest;
import com.querydsl.sql.Constants;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.domain.QEmployee;
import com.querydsl.sql.domain.QSurvey;
import java.sql.SQLException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeleteBase
extends AbstractBaseTest {
    private void reset() throws SQLException {
        ((SQLDeleteClause)this.delete((RelationalPath<?>)Constants.survey).where((Predicate)Constants.survey.name.isNotNull())).execute();
        ((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{1, "Hello World", "Hello"})).execute();
    }

    @Before
    public void setUp() throws SQLException {
        this.reset();
    }

    @After
    public void tearDown() throws SQLException {
        this.reset();
    }

    @Test
    public void batch() throws SQLException {
        ((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{2, "A", "B"})).execute();
        ((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{3, "B", "C"})).execute();
        SQLDeleteClause delete = this.delete((RelationalPath<?>)Constants.survey);
        ((SQLDeleteClause)delete.where((Predicate)Constants.survey.name.eq((Object)"A"))).addBatch();
        Assert.assertEquals((long)1L, (long)delete.getBatchCount());
        ((SQLDeleteClause)delete.where((Predicate)Constants.survey.name.eq((Object)"B"))).addBatch();
        Assert.assertEquals((long)2L, (long)delete.getBatchCount());
        Assert.assertEquals((long)2L, (long)delete.execute());
    }

    @Test
    @ExcludeIn(value={Target.CUBRID, Target.SQLITE})
    public void batch_templates() throws SQLException {
        ((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{2, "A", "B"})).execute();
        ((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{3, "B", "C"})).execute();
        SQLDeleteClause delete = this.delete((RelationalPath<?>)Constants.survey);
        ((SQLDeleteClause)delete.where((Predicate)Constants.survey.name.eq((Expression)Expressions.stringTemplate((String)"'A'", (Object[])new Object[0])))).addBatch();
        ((SQLDeleteClause)delete.where((Predicate)Constants.survey.name.eq((Expression)Expressions.stringTemplate((String)"'B'", (Object[])new Object[0])))).addBatch();
        Assert.assertEquals((long)2L, (long)delete.execute());
    }

    @Test
    @ExcludeIn(value={Target.MYSQL})
    public void delete() throws SQLException {
        long count = ((SQLQuery)this.query().from((Expression)Constants.survey)).fetchCount();
        Assert.assertEquals((long)0L, (long)((SQLDeleteClause)this.delete((RelationalPath<?>)Constants.survey).where((Predicate)Constants.survey.name.eq((Object)"XXX"))).execute());
        Assert.assertEquals((long)count, (long)this.delete((RelationalPath<?>)Constants.survey).execute());
    }

    @Test
    @IncludeIn(value={Target.CUBRID, Target.H2, Target.MYSQL, Target.ORACLE, Target.SQLSERVER})
    public void delete_limit() {
        ((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{2, "A", "B"})).execute();
        ((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{3, "B", "C"})).execute();
        ((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{4, "D", "E"})).execute();
        Assert.assertEquals((long)2L, (long)((SQLDeleteClause)this.delete((RelationalPath<?>)Constants.survey).limit(2L)).execute());
    }

    @Test
    public void delete_with_subQuery_exists() {
        QSurvey survey1 = new QSurvey("s1");
        QEmployee employee = new QEmployee("e");
        SQLDeleteClause delete = this.delete((RelationalPath<?>)survey1);
        delete.where(new Predicate[]{survey1.name.eq((Object)"XXX"), ((SQLQuery)((SQLQuery)this.query().from((Expression)employee)).where((Predicate)survey1.id.eq(employee.id))).exists()});
        Assert.assertEquals((long)0L, (long)delete.execute());
    }

    @Test
    public void delete_with_subQuery_exists_Params() {
        QSurvey survey1 = new QSurvey("s1");
        QEmployee employee = new QEmployee("e");
        Param param = new Param(Integer.class, "param");
        SQLQuery sq = (SQLQuery)((SQLQuery)this.query().from((Expression)employee)).where((Predicate)employee.id.eq((Expression)param));
        sq.set((ParamExpression)param, (Object)-12478923);
        SQLDeleteClause delete = this.delete((RelationalPath<?>)survey1);
        delete.where(new Predicate[]{survey1.name.eq((Object)"XXX"), sq.exists()});
        Assert.assertEquals((long)0L, (long)delete.execute());
    }

    @Test
    public void delete_with_subQuery_exists2() {
        QSurvey survey1 = new QSurvey("s1");
        QEmployee employee = new QEmployee("e");
        SQLDeleteClause delete = this.delete((RelationalPath<?>)survey1);
        delete.where(new Predicate[]{survey1.name.eq((Object)"XXX"), ((SQLQuery)((SQLQuery)this.query().from((Expression)employee)).where((Predicate)survey1.name.eq((Expression)employee.lastname))).exists()});
        Assert.assertEquals((long)0L, (long)delete.execute());
    }

    @Test
    @ExcludeIn(value={Target.CUBRID, Target.SQLITE})
    public void delete_with_tempateExpression_in_batch() {
        Assert.assertEquals((long)1L, (long)((SQLDeleteClause)((SQLDeleteClause)this.delete((RelationalPath<?>)Constants.survey).where((Predicate)Constants.survey.name.eq((Expression)Expressions.stringTemplate((String)"'Hello World'", (Object[])new Object[0])))).addBatch()).execute());
    }
}

